/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class DefaultRowHeightRecord
extends Record {
    public static final short sid = 549;
    private short field_1_option_flags;
    private short field_2_row_height;

    public DefaultRowHeightRecord() {
    }

    public DefaultRowHeightRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 549) {
            throw new RecordFormatException("NOT A DefaultRowHeight RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_option_flags = recordInputStream.readShort();
        this.field_2_row_height = recordInputStream.readShort();
    }

    public void setOptionFlags(short s) {
        this.field_1_option_flags = s;
    }

    public void setRowHeight(short s) {
        this.field_2_row_height = s;
    }

    public short getOptionFlags() {
        return this.field_1_option_flags;
    }

    public short getRowHeight() {
        return this.field_2_row_height;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DEFAULTROWHEIGHT]\n");
        stringBuffer.append("    .optionflags    = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        stringBuffer.append("    .rowheight      = ").append(Integer.toHexString(this.getRowHeight())).append("\n");
        stringBuffer.append("[/DEFAULTROWHEIGHT]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)549);
        LittleEndian.putShort(byArray, 2 + n, (short)4);
        LittleEndian.putShort(byArray, 4 + n, this.getOptionFlags());
        LittleEndian.putShort(byArray, 6 + n, this.getRowHeight());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 549;
    }

    public Object clone() {
        DefaultRowHeightRecord defaultRowHeightRecord = new DefaultRowHeightRecord();
        defaultRowHeightRecord.field_1_option_flags = this.field_1_option_flags;
        defaultRowHeightRecord.field_2_row_height = this.field_2_row_height;
        return defaultRowHeightRecord;
    }
}

