/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class DatRecord
extends Record {
    public static final short sid = 4195;
    private short field_1_options;
    private BitField horizontalBorder = BitFieldFactory.getInstance(1);
    private BitField verticalBorder = BitFieldFactory.getInstance(2);
    private BitField border = BitFieldFactory.getInstance(4);
    private BitField showSeriesKey = BitFieldFactory.getInstance(8);

    public DatRecord() {
    }

    public DatRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4195) {
            throw new RecordFormatException("Not a Dat record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_options = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DAT]\n");
        stringBuffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .horizontalBorder         = ").append(this.isHorizontalBorder()).append('\n');
        stringBuffer.append("         .verticalBorder           = ").append(this.isVerticalBorder()).append('\n');
        stringBuffer.append("         .border                   = ").append(this.isBorder()).append('\n');
        stringBuffer.append("         .showSeriesKey            = ").append(this.isShowSeriesKey()).append('\n');
        stringBuffer.append("[/DAT]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4195);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n + n2, this.field_1_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4195;
    }

    public Object clone() {
        DatRecord datRecord = new DatRecord();
        datRecord.field_1_options = this.field_1_options;
        return datRecord;
    }

    public short getOptions() {
        return this.field_1_options;
    }

    public void setOptions(short s) {
        this.field_1_options = s;
    }

    public void setHorizontalBorder(boolean bl) {
        this.field_1_options = this.horizontalBorder.setShortBoolean(this.field_1_options, bl);
    }

    public boolean isHorizontalBorder() {
        return this.horizontalBorder.isSet(this.field_1_options);
    }

    public void setVerticalBorder(boolean bl) {
        this.field_1_options = this.verticalBorder.setShortBoolean(this.field_1_options, bl);
    }

    public boolean isVerticalBorder() {
        return this.verticalBorder.isSet(this.field_1_options);
    }

    public void setBorder(boolean bl) {
        this.field_1_options = this.border.setShortBoolean(this.field_1_options, bl);
    }

    public boolean isBorder() {
        return this.border.isSet(this.field_1_options);
    }

    public void setShowSeriesKey(boolean bl) {
        this.field_1_options = this.showSeriesKey.setShortBoolean(this.field_1_options, bl);
    }

    public boolean isShowSeriesKey() {
        return this.showSeriesKey.isSet(this.field_1_options);
    }
}

