/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.util.HSSFCellRangeAddress;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public final class DVRecord
extends Record {
    public static final short sid = 446;
    private int field_option_flags;
    private String field_title_prompt;
    private String field_title_error;
    private String field_text_prompt;
    private String field_text_error;
    private short field_size_first_formula;
    private short field_not_used_1 = (short)16352;
    private Stack field_rpn_token_1;
    private short field_size_sec_formula;
    private short field_not_used_2 = 0;
    private Stack field_rpn_token_2;
    private HSSFCellRangeAddress field_regions;
    public static final Integer STRING_PROMPT_TITLE = new Integer(0);
    public static final Integer STRING_ERROR_TITLE = new Integer(1);
    public static final Integer STRING_PROMPT_TEXT = new Integer(2);
    public static final Integer STRING_ERROR_TEXT = new Integer(3);
    private Hashtable _hash_strings;
    private BitField opt_data_type = new BitField(15);
    private BitField opt_error_style = new BitField(112);
    private BitField opt_string_list_formula = new BitField(128);
    private BitField opt_empty_cell_allowed = new BitField(256);
    private BitField opt_surppres_dropdown_arrow = new BitField(512);
    private BitField opt_show_prompt_on_cell_selected = new BitField(262144);
    private BitField opt_show_error_on_invalid_value = new BitField(524288);
    private BitField opt_condition_operator = new BitField(0xF00000);

    public DVRecord() {
    }

    public DVRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 446) {
            throw new RecordFormatException("NOT a valid DV RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        int n;
        Ptg ptg;
        this.field_rpn_token_1 = new Stack();
        this.field_rpn_token_2 = new Stack();
        this.field_option_flags = recordInputStream.readInt();
        this._hash_strings = new Hashtable(4);
        StringHandler stringHandler = new StringHandler(recordInputStream);
        this.field_title_prompt = stringHandler.getStringData();
        this._hash_strings.put(STRING_PROMPT_TITLE, stringHandler);
        StringHandler stringHandler2 = new StringHandler(recordInputStream);
        this.field_title_error = stringHandler2.getStringData();
        this._hash_strings.put(STRING_ERROR_TITLE, stringHandler2);
        StringHandler stringHandler3 = new StringHandler(recordInputStream);
        this.field_text_prompt = stringHandler3.getStringData();
        this._hash_strings.put(STRING_PROMPT_TEXT, stringHandler3);
        StringHandler stringHandler4 = new StringHandler(recordInputStream);
        this.field_text_error = stringHandler4.getStringData();
        this._hash_strings.put(STRING_ERROR_TEXT, stringHandler4);
        this.field_size_first_formula = recordInputStream.readShort();
        this.field_not_used_1 = recordInputStream.readShort();
        for (n = 0; n < this.field_size_first_formula; n += ptg.getSize()) {
            ptg = Ptg.createPtg(recordInputStream);
            this.field_rpn_token_1.push(ptg);
        }
        this.field_size_sec_formula = recordInputStream.readShort();
        this.field_not_used_2 = recordInputStream.readShort();
        for (n = 0; n < this.field_size_sec_formula; n += ptg.getSize()) {
            ptg = Ptg.createPtg(recordInputStream);
            this.field_rpn_token_2.push(ptg);
        }
        this.field_regions = new HSSFCellRangeAddress(recordInputStream);
    }

    public void setDataType(int n) {
        this.field_option_flags = this.opt_data_type.setValue(this.field_option_flags, n);
    }

    public int getDataType() {
        return this.opt_data_type.getValue(this.field_option_flags);
    }

    public void setErrorStyle(int n) {
        this.field_option_flags = this.opt_error_style.setValue(this.field_option_flags, n);
    }

    public int getErrorStyle() {
        return this.opt_error_style.getValue(this.field_option_flags);
    }

    public void setListExplicitFormula(boolean bl) {
        this.field_option_flags = this.opt_string_list_formula.setBoolean(this.field_option_flags, bl);
    }

    public boolean getListExplicitFormula() {
        return this.opt_string_list_formula.isSet(this.field_option_flags);
    }

    public void setEmptyCellAllowed(boolean bl) {
        this.field_option_flags = this.opt_empty_cell_allowed.setBoolean(this.field_option_flags, bl);
    }

    public boolean getEmptyCellAllowed() {
        return this.opt_empty_cell_allowed.isSet(this.field_option_flags);
    }

    public void setSurppresDropdownArrow(boolean bl) {
        this.field_option_flags = this.opt_surppres_dropdown_arrow.setBoolean(this.field_option_flags, bl);
    }

    public boolean getSurppresDropdownArrow() {
        return this.opt_surppres_dropdown_arrow.isSet(this.field_option_flags);
    }

    public void setShowPromptOnCellSelected(boolean bl) {
        this.field_option_flags = this.opt_show_prompt_on_cell_selected.setBoolean(this.field_option_flags, bl);
    }

    public boolean getShowPromptOnCellSelected() {
        return this.opt_show_prompt_on_cell_selected.isSet(this.field_option_flags);
    }

    public void setShowErrorOnInvalidValue(boolean bl) {
        this.field_option_flags = this.opt_show_error_on_invalid_value.setBoolean(this.field_option_flags, bl);
    }

    public boolean getShowErrorOnInvalidValue() {
        return this.opt_show_error_on_invalid_value.isSet(this.field_option_flags);
    }

    public void setConditionOperator(int n) {
        this.field_option_flags = this.opt_condition_operator.setValue(this.field_option_flags, n);
    }

    public int getConditionOperator() {
        return this.opt_condition_operator.getValue(this.field_option_flags);
    }

    public void setFirstFormulaRPN(Stack stack) {
        this.field_rpn_token_1 = stack;
    }

    public void setFirstFormulaSize(short s) {
        this.field_size_first_formula = s;
    }

    public void setSecFormulaRPN(Stack stack) {
        this.field_rpn_token_2 = stack;
    }

    public void setSecFormulaSize(short s) {
        this.field_size_sec_formula = s;
    }

    public void setStringField(Integer n, String string) {
        if (this._hash_strings == null) {
            this._hash_strings = new Hashtable();
        }
        StringHandler stringHandler = new StringHandler();
        if (string == null) {
            string = "";
        } else {
            stringHandler.setStringLength(string.length());
        }
        stringHandler.setStringData(string);
        stringHandler.setUnicodeFlag((byte)0);
        this._hash_strings.put(n, stringHandler);
    }

    public String getStringField(Integer n) {
        return ((StringHandler)this._hash_strings.get(n)).getStringData();
    }

    public void setCellRangeAddress(HSSFCellRangeAddress hSSFCellRangeAddress) {
        this.field_regions = hSSFCellRangeAddress;
    }

    public HSSFCellRangeAddress getCellRangeAddress() {
        return this.field_regions;
    }

    public int getOptionFlags() {
        return this.field_option_flags;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        Ptg ptg;
        int n2;
        int n3 = this.getRecordSize();
        LittleEndian.putShort(byArray, 0 + n, (short)446);
        LittleEndian.putShort(byArray, 2 + n, (short)(n3 - 4));
        int n4 = 4;
        LittleEndian.putInt(byArray, n4 + n, this.getOptionFlags());
        n4 += 4;
        n4 += ((StringHandler)this._hash_strings.get(STRING_PROMPT_TITLE)).serialize(n4 + n, byArray);
        n4 += ((StringHandler)this._hash_strings.get(STRING_ERROR_TITLE)).serialize(n4 + n, byArray);
        n4 += ((StringHandler)this._hash_strings.get(STRING_PROMPT_TEXT)).serialize(n4 + n, byArray);
        n4 += ((StringHandler)this._hash_strings.get(STRING_ERROR_TEXT)).serialize(n4 + n, byArray);
        LittleEndian.putShort(byArray, n + n4, this.field_size_first_formula);
        LittleEndian.putShort(byArray, n + (n4 += 2), this.field_not_used_1);
        n4 += 2;
        for (n2 = 0; n2 < this.field_rpn_token_1.size(); ++n2) {
            ptg = (Ptg)this.field_rpn_token_1.get(n2);
            ptg.writeBytes(byArray, n4 + n);
            n4 += ptg.getSize();
        }
        LittleEndian.putShort(byArray, n + n4, this.field_size_sec_formula);
        LittleEndian.putShort(byArray, n + (n4 += 2), this.field_not_used_2);
        n4 += 2;
        if (this.field_size_sec_formula > 0) {
            for (n2 = 0; n2 < this.field_rpn_token_2.size(); ++n2) {
                ptg = (Ptg)this.field_rpn_token_2.get(n2);
                ptg.writeBytes(byArray, n4 + n);
                n4 += ptg.getSize();
            }
        }
        this.field_regions.serialize(n4 + n, byArray);
        return n3;
    }

    public int getRecordSize() {
        int n = 16;
        if (this._hash_strings != null) {
            Enumeration enumeration = this._hash_strings.keys();
            while (enumeration.hasMoreElements()) {
                n += ((StringHandler)this._hash_strings.get((Integer)enumeration.nextElement())).getSize();
            }
        }
        n += this.field_size_first_formula + this.field_size_sec_formula;
        return n += this.field_regions.getSize();
    }

    public short getSid() {
        return 446;
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }

    private static final class StringHandler {
        private int _string_length = 1;
        private byte _string_unicode_flag = 0;
        private String _string_data = "0x00";
        private int _start_offset;
        private int _end_offset;

        StringHandler() {
        }

        StringHandler(RecordInputStream recordInputStream) {
            this.fillFields(recordInputStream);
        }

        protected void fillFields(RecordInputStream recordInputStream) {
            this._string_length = recordInputStream.readUShort();
            this._string_unicode_flag = recordInputStream.readByte();
            this._string_data = this._string_unicode_flag == 1 ? recordInputStream.readUnicodeLEString(this._string_length) : recordInputStream.readCompressedUnicode(this._string_length);
        }

        private void setStringData(String string) {
            this._string_data = string;
        }

        private String getStringData() {
            return this._string_data;
        }

        private int getEndOffset() {
            return this._end_offset;
        }

        public int serialize(int n, byte[] byArray) {
            LittleEndian.putUShort(byArray, n, this._string_length);
            byArray[2 + n] = this._string_unicode_flag;
            if (this._string_unicode_flag == 1) {
                StringUtil.putUnicodeLE(this._string_data, byArray, 3 + n);
            } else {
                StringUtil.putCompressedUnicode(this._string_data, byArray, 3 + n);
            }
            return this.getSize();
        }

        private void setUnicodeFlag(byte by) {
            this._string_unicode_flag = by;
        }

        private void setStringLength(int n) {
            this._string_length = n;
        }

        private int getStringByteLength() {
            return this._string_unicode_flag == 1 ? this._string_length * 2 : this._string_length;
        }

        public int getSize() {
            return 3 + this.getStringByteLength();
        }
    }
}

