/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class DSFRecord
extends Record {
    public static final short sid = 353;
    private short field_1_dsf;

    public DSFRecord() {
    }

    public DSFRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 353) {
            throw new RecordFormatException("NOT A DSF RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_dsf = recordInputStream.readShort();
    }

    public void setDsf(short s) {
        this.field_1_dsf = s;
    }

    public short getDsf() {
        return this.field_1_dsf;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DSF]\n");
        stringBuffer.append("    .isDSF           = ").append(Integer.toHexString(this.getDsf())).append("\n");
        stringBuffer.append("[/DSF]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)353);
        LittleEndian.putShort(byArray, 2 + n, (short)2);
        LittleEndian.putShort(byArray, 4 + n, this.getDsf());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 353;
    }
}

