/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class DBCellRecord
extends Record {
    public static final int BLOCK_SIZE = 32;
    public static final short sid = 215;
    private int field_1_row_offset;
    private short[] field_2_cell_offsets;

    public DBCellRecord() {
    }

    public DBCellRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 215) {
            throw new RecordFormatException("NOT A valid DBCell RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_row_offset = recordInputStream.readUShort();
        int n = recordInputStream.remaining();
        this.field_2_cell_offsets = new short[n / 2];
        for (int i = 0; i < this.field_2_cell_offsets.length; ++i) {
            this.field_2_cell_offsets[i] = recordInputStream.readShort();
        }
    }

    public void setRowOffset(int n) {
        this.field_1_row_offset = n;
    }

    public void addCellOffset(short s) {
        if (this.field_2_cell_offsets == null) {
            this.field_2_cell_offsets = new short[1];
        } else {
            short[] sArray = new short[this.field_2_cell_offsets.length + 1];
            System.arraycopy(this.field_2_cell_offsets, 0, sArray, 0, this.field_2_cell_offsets.length);
            this.field_2_cell_offsets = sArray;
        }
        this.field_2_cell_offsets[this.field_2_cell_offsets.length - 1] = s;
    }

    public int getRowOffset() {
        return this.field_1_row_offset;
    }

    public short getCellOffsetAt(int n) {
        return this.field_2_cell_offsets[n];
    }

    public int getNumCellOffsets() {
        return this.field_2_cell_offsets.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DBCELL]\n");
        stringBuffer.append("    .rowoffset       = ").append(Integer.toHexString(this.getRowOffset())).append("\n");
        for (int i = 0; i < this.getNumCellOffsets(); ++i) {
            stringBuffer.append("    .cell_" + i + "          = ").append(Integer.toHexString(this.getCellOffsetAt(i))).append("\n");
        }
        stringBuffer.append("[/DBCELL]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        if (this.field_2_cell_offsets == null) {
            this.field_2_cell_offsets = new short[0];
        }
        LittleEndian.putShort(byArray, 0 + n, (short)215);
        LittleEndian.putShort(byArray, 2 + n, (short)(4 + this.getNumCellOffsets() * 2));
        LittleEndian.putInt(byArray, 4 + n, this.getRowOffset());
        for (int i = 0; i < this.getNumCellOffsets(); ++i) {
            LittleEndian.putShort(byArray, 8 + 2 * i + n, this.getCellOffsetAt(i));
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8 + this.getNumCellOffsets() * 2;
    }

    public static int calculateSizeOfRecords(int n, int n2) {
        return n * 8 + n2 * 2;
    }

    public short getSid() {
        return 215;
    }

    public boolean isInValueSection() {
        return true;
    }
}

