/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class ContinueRecord
extends Record {
    public static final short sid = 60;
    private byte[] field_1_data;

    public ContinueRecord() {
    }

    public ContinueRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    public byte[] serialize() {
        byte[] byArray = new byte[this.field_1_data.length + 4];
        this.serialize(0, byArray);
        return byArray;
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, n, (short)60);
        LittleEndian.putShort(byArray, n + 2, (short)this.field_1_data.length);
        System.arraycopy(this.field_1_data, 0, byArray, n + 4, this.field_1_data.length);
        return this.field_1_data.length + 4;
    }

    public void setData(byte[] byArray) {
        this.field_1_data = byArray;
    }

    public byte[] getData() {
        return this.field_1_data;
    }

    protected void validateSid(short s) {
        if (s != 60) {
            throw new RecordFormatException("Not a Continue Record");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CONTINUE RECORD]\n");
        stringBuffer.append("    .id        = ").append(Integer.toHexString(60)).append("\n");
        stringBuffer.append("[/CONTINUE RECORD]\n");
        return stringBuffer.toString();
    }

    public short getSid() {
        return 60;
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_data = recordInputStream.readRemainder();
    }

    public Object clone() {
        ContinueRecord continueRecord = new ContinueRecord();
        continueRecord.setData(this.field_1_data);
        return continueRecord;
    }
}

