/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class ColumnInfoRecord
extends Record {
    public static final short sid = 125;
    private short field_1_first_col;
    private short field_2_last_col;
    private short field_3_col_width;
    private short field_4_xf_index;
    private short field_5_options;
    private static final BitField hidden = BitFieldFactory.getInstance(1);
    private static final BitField outlevel = BitFieldFactory.getInstance(1792);
    private static final BitField collapsed = BitFieldFactory.getInstance(4096);
    private short field_6_reserved;

    public ColumnInfoRecord() {
        this.field_6_reserved = (short)2;
    }

    public ColumnInfoRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_first_col = recordInputStream.readShort();
        this.field_2_last_col = recordInputStream.readShort();
        this.field_3_col_width = recordInputStream.readShort();
        this.field_4_xf_index = recordInputStream.readShort();
        this.field_5_options = recordInputStream.readShort();
        switch (recordInputStream.remaining()) {
            case 2: {
                this.field_6_reserved = recordInputStream.readShort();
                break;
            }
            case 1: {
                this.field_6_reserved = recordInputStream.readByte();
                break;
            }
            default: {
                throw new RuntimeException("Unusual record size remaining=(" + recordInputStream.remaining() + ")");
            }
        }
    }

    protected void validateSid(short s) {
        if (s != 125) {
            throw new RecordFormatException("NOT A COLINFO RECORD!!");
        }
    }

    public void setFirstColumn(short s) {
        this.field_1_first_col = s;
    }

    public void setLastColumn(short s) {
        this.field_2_last_col = s;
    }

    public void setColumnWidth(short s) {
        this.field_3_col_width = s;
    }

    public void setXFIndex(short s) {
        this.field_4_xf_index = s;
    }

    public void setOptions(short s) {
        this.field_5_options = s;
    }

    public void setHidden(boolean bl) {
        this.field_5_options = hidden.setShortBoolean(this.field_5_options, bl);
    }

    public void setOutlineLevel(short s) {
        this.field_5_options = outlevel.setShortValue(this.field_5_options, s);
    }

    public void setCollapsed(boolean bl) {
        this.field_5_options = collapsed.setShortBoolean(this.field_5_options, bl);
    }

    public short getFirstColumn() {
        return this.field_1_first_col;
    }

    public short getLastColumn() {
        return this.field_2_last_col;
    }

    public short getColumnWidth() {
        return this.field_3_col_width;
    }

    public short getXFIndex() {
        return this.field_4_xf_index;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public boolean getHidden() {
        return hidden.isSet(this.field_5_options);
    }

    public short getOutlineLevel() {
        return outlevel.getShortValue(this.field_5_options);
    }

    public boolean getCollapsed() {
        return collapsed.isSet(this.field_5_options);
    }

    public short getSid() {
        return 125;
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)125);
        LittleEndian.putShort(byArray, 2 + n, (short)12);
        LittleEndian.putShort(byArray, 4 + n, this.getFirstColumn());
        LittleEndian.putShort(byArray, 6 + n, this.getLastColumn());
        LittleEndian.putShort(byArray, 8 + n, this.getColumnWidth());
        LittleEndian.putShort(byArray, 10 + n, this.getXFIndex());
        LittleEndian.putShort(byArray, 12 + n, this.getOptions());
        LittleEndian.putShort(byArray, 14 + n, this.field_6_reserved);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 16;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[COLINFO]\n");
        stringBuffer.append("colfirst       = ").append(this.getFirstColumn()).append("\n");
        stringBuffer.append("collast        = ").append(this.getLastColumn()).append("\n");
        stringBuffer.append("colwidth       = ").append(this.getColumnWidth()).append("\n");
        stringBuffer.append("xfindex        = ").append(this.getXFIndex()).append("\n");
        stringBuffer.append("options        = ").append(this.getOptions()).append("\n");
        stringBuffer.append("  hidden       = ").append(this.getHidden()).append("\n");
        stringBuffer.append("  olevel       = ").append(this.getOutlineLevel()).append("\n");
        stringBuffer.append("  collapsed    = ").append(this.getCollapsed()).append("\n");
        stringBuffer.append("[/COLINFO]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        ColumnInfoRecord columnInfoRecord = new ColumnInfoRecord();
        columnInfoRecord.field_1_first_col = this.field_1_first_col;
        columnInfoRecord.field_2_last_col = this.field_2_last_col;
        columnInfoRecord.field_3_col_width = this.field_3_col_width;
        columnInfoRecord.field_4_xf_index = this.field_4_xf_index;
        columnInfoRecord.field_5_options = this.field_5_options;
        columnInfoRecord.field_6_reserved = this.field_6_reserved;
        return columnInfoRecord;
    }
}

