/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class CodepageRecord
extends Record {
    public static final short sid = 66;
    private short field_1_codepage;
    public static final short CODEPAGE = 1200;

    public CodepageRecord() {
    }

    public CodepageRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 66) {
            throw new RecordFormatException("NOT A CODEPAGE RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_codepage = recordInputStream.readShort();
    }

    public void setCodepage(short s) {
        this.field_1_codepage = s;
    }

    public short getCodepage() {
        return this.field_1_codepage;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CODEPAGE]\n");
        stringBuffer.append("    .codepage        = ").append(Integer.toHexString(this.getCodepage())).append("\n");
        stringBuffer.append("[/CODEPAGE]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)66);
        LittleEndian.putShort(byArray, 2 + n, (short)2);
        LittleEndian.putShort(byArray, 4 + n, this.getCodepage());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 66;
    }
}

