/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;

public class ChartTitleFormatRecord
extends Record {
    public static final short sid = 4176;
    private int m_recs;
    private ArrayList m_formats;

    public ChartTitleFormatRecord() {
    }

    public ChartTitleFormatRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4176) {
            throw new RecordFormatException("NOT A CHARTTITLEFORMAT RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.m_recs = recordInputStream.readUShort();
        if (this.m_formats == null) {
            this.m_formats = new ArrayList(this.m_recs);
        }
        for (int i = 0; i < this.m_recs; ++i) {
            CTFormat cTFormat = new CTFormat(recordInputStream.readShort(), recordInputStream.readShort());
            this.m_formats.add(cTFormat);
        }
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)4176);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n, (short)this.m_formats.size());
        for (int i = 0; i < this.m_formats.size(); ++i) {
            CTFormat cTFormat = (CTFormat)this.m_formats.get(i);
            LittleEndian.putShort(byArray, 6 + i * 4 + n, cTFormat.getOffset());
            LittleEndian.putShort(byArray, 8 + i * 4 + n, cTFormat.getFontIndex());
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6 + 4 * this.m_formats.size();
    }

    public short getSid() {
        return 4176;
    }

    public int getFormatCount() {
        return this.m_formats.size();
    }

    public void modifyFormatRun(short s, short s2) {
        short s3 = 0;
        for (int i = 0; i < this.m_formats.size(); ++i) {
            CTFormat cTFormat = (CTFormat)this.m_formats.get(i);
            if (s3 != 0) {
                cTFormat.setOffset((short)(cTFormat.getOffset() + s3));
                continue;
            }
            if (s != cTFormat.getOffset() || i >= this.m_formats.size() - 1) continue;
            CTFormat cTFormat2 = (CTFormat)this.m_formats.get(i + 1);
            s3 = (short)(s2 - (cTFormat2.getOffset() - cTFormat.getOffset()));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CHARTTITLEFORMAT]\n");
        stringBuffer.append("    .format_runs       = ").append(this.m_recs).append("\n");
        for (int i = 0; i < this.m_formats.size(); ++i) {
            CTFormat cTFormat = (CTFormat)this.m_formats.get(i);
            stringBuffer.append("       .char_offset= ").append(cTFormat.getOffset());
            stringBuffer.append(",.fontidx= ").append(cTFormat.getFontIndex());
            stringBuffer.append("\n");
        }
        stringBuffer.append("[/CHARTTITLEFORMAT]\n");
        return stringBuffer.toString();
    }

    private class CTFormat {
        private short m_offset;
        private short m_fontIndex;

        protected CTFormat(short s, short s2) {
            this.m_offset = s;
            this.m_fontIndex = s2;
        }

        public short getOffset() {
            return this.m_offset;
        }

        public void setOffset(short s) {
            this.m_offset = s;
        }

        public short getFontIndex() {
            return this.m_fontIndex;
        }
    }
}

