/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class ChartRecord
extends Record {
    public static final short sid = 4098;
    private int field_1_x;
    private int field_2_y;
    private int field_3_width;
    private int field_4_height;

    public ChartRecord() {
    }

    public ChartRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4098) {
            throw new RecordFormatException("Not a Chart record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_x = recordInputStream.readInt();
        this.field_2_y = recordInputStream.readInt();
        this.field_3_width = recordInputStream.readInt();
        this.field_4_height = recordInputStream.readInt();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CHART]\n");
        stringBuffer.append("    .x                    = ").append("0x").append(HexDump.toHex(this.getX())).append(" (").append(this.getX()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .y                    = ").append("0x").append(HexDump.toHex(this.getY())).append(" (").append(this.getY()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .width                = ").append("0x").append(HexDump.toHex(this.getWidth())).append(" (").append(this.getWidth()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .height               = ").append("0x").append(HexDump.toHex(this.getHeight())).append(" (").append(this.getHeight()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/CHART]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4098);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putInt(byArray, 4 + n + n2, this.field_1_x);
        LittleEndian.putInt(byArray, 8 + n + n2, this.field_2_y);
        LittleEndian.putInt(byArray, 12 + n + n2, this.field_3_width);
        LittleEndian.putInt(byArray, 16 + n + n2, this.field_4_height);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20;
    }

    public short getSid() {
        return 4098;
    }

    public Object clone() {
        ChartRecord chartRecord = new ChartRecord();
        chartRecord.field_1_x = this.field_1_x;
        chartRecord.field_2_y = this.field_2_y;
        chartRecord.field_3_width = this.field_3_width;
        chartRecord.field_4_height = this.field_4_height;
        return chartRecord;
    }

    public int getX() {
        return this.field_1_x;
    }

    public void setX(int n) {
        this.field_1_x = n;
    }

    public int getY() {
        return this.field_2_y;
    }

    public void setY(int n) {
        this.field_2_y = n;
    }

    public int getWidth() {
        return this.field_3_width;
    }

    public void setWidth(int n) {
        this.field_3_width = n;
    }

    public int getHeight() {
        return this.field_4_height;
    }

    public void setHeight(int n) {
        this.field_4_height = n;
    }
}

