/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class ChartFormatRecord
extends Record {
    public static final short sid = 4116;
    private int field1_x_position;
    private int field2_y_position;
    private int field3_width;
    private int field4_height;
    private short field5_grbit;
    private BitField varyDisplayPattern = BitFieldFactory.getInstance(1);

    public ChartFormatRecord() {
    }

    public ChartFormatRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4116) {
            throw new RecordFormatException("NOT A CHARTFORMAT RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field1_x_position = recordInputStream.readInt();
        this.field2_y_position = recordInputStream.readInt();
        this.field3_width = recordInputStream.readInt();
        this.field4_height = recordInputStream.readInt();
        this.field5_grbit = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CHARTFORMAT]\n");
        stringBuffer.append("    .xPosition       = ").append(this.getXPosition()).append("\n");
        stringBuffer.append("    .yPosition       = ").append(this.getYPosition()).append("\n");
        stringBuffer.append("    .width           = ").append(this.getWidth()).append("\n");
        stringBuffer.append("    .height          = ").append(this.getHeight()).append("\n");
        stringBuffer.append("    .grBit           = ").append(Integer.toHexString(this.field5_grbit)).append("\n");
        stringBuffer.append("[/CHARTFORMAT]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)4116);
        LittleEndian.putShort(byArray, 2 + n, (short)22);
        LittleEndian.putInt(byArray, 4 + n, this.getXPosition());
        LittleEndian.putInt(byArray, 8 + n, this.getYPosition());
        LittleEndian.putInt(byArray, 12 + n, this.getWidth());
        LittleEndian.putInt(byArray, 16 + n, this.getHeight());
        LittleEndian.putShort(byArray, 20 + n, this.field5_grbit);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 4116;
    }

    public int getXPosition() {
        return this.field1_x_position;
    }

    public void setXPosition(int n) {
        this.field1_x_position = n;
    }

    public int getYPosition() {
        return this.field2_y_position;
    }

    public void setYPosition(int n) {
        this.field2_y_position = n;
    }

    public int getWidth() {
        return this.field3_width;
    }

    public void setWidth(int n) {
        this.field3_width = n;
    }

    public int getHeight() {
        return this.field4_height;
    }

    public void setHeight(int n) {
        this.field4_height = n;
    }

    public boolean getVaryDisplayPattern() {
        return this.varyDisplayPattern.isSet(this.field5_grbit);
    }

    public void setVaryDisplayPattern(boolean bl) {
        this.field5_grbit = this.varyDisplayPattern.setShortBoolean(this.field5_grbit, bl);
    }
}

