/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class CategorySeriesAxisRecord
extends Record {
    public static final short sid = 4128;
    private short field_1_crossingPoint;
    private short field_2_labelFrequency;
    private short field_3_tickMarkFrequency;
    private short field_4_options;
    private BitField valueAxisCrossing = BitFieldFactory.getInstance(1);
    private BitField crossesFarRight = BitFieldFactory.getInstance(2);
    private BitField reversed = BitFieldFactory.getInstance(4);

    public CategorySeriesAxisRecord() {
    }

    public CategorySeriesAxisRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4128) {
            throw new RecordFormatException("Not a CategorySeriesAxis record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_crossingPoint = recordInputStream.readShort();
        this.field_2_labelFrequency = recordInputStream.readShort();
        this.field_3_tickMarkFrequency = recordInputStream.readShort();
        this.field_4_options = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CATSERRANGE]\n");
        stringBuffer.append("    .crossingPoint        = ").append("0x").append(HexDump.toHex(this.getCrossingPoint())).append(" (").append(this.getCrossingPoint()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .labelFrequency       = ").append("0x").append(HexDump.toHex(this.getLabelFrequency())).append(" (").append(this.getLabelFrequency()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .tickMarkFrequency    = ").append("0x").append(HexDump.toHex(this.getTickMarkFrequency())).append(" (").append(this.getTickMarkFrequency()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .valueAxisCrossing        = ").append(this.isValueAxisCrossing()).append('\n');
        stringBuffer.append("         .crossesFarRight          = ").append(this.isCrossesFarRight()).append('\n');
        stringBuffer.append("         .reversed                 = ").append(this.isReversed()).append('\n');
        stringBuffer.append("[/CATSERRANGE]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4128);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n + n2, this.field_1_crossingPoint);
        LittleEndian.putShort(byArray, 6 + n + n2, this.field_2_labelFrequency);
        LittleEndian.putShort(byArray, 8 + n + n2, this.field_3_tickMarkFrequency);
        LittleEndian.putShort(byArray, 10 + n + n2, this.field_4_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSid() {
        return 4128;
    }

    public Object clone() {
        CategorySeriesAxisRecord categorySeriesAxisRecord = new CategorySeriesAxisRecord();
        categorySeriesAxisRecord.field_1_crossingPoint = this.field_1_crossingPoint;
        categorySeriesAxisRecord.field_2_labelFrequency = this.field_2_labelFrequency;
        categorySeriesAxisRecord.field_3_tickMarkFrequency = this.field_3_tickMarkFrequency;
        categorySeriesAxisRecord.field_4_options = this.field_4_options;
        return categorySeriesAxisRecord;
    }

    public short getCrossingPoint() {
        return this.field_1_crossingPoint;
    }

    public void setCrossingPoint(short s) {
        this.field_1_crossingPoint = s;
    }

    public short getLabelFrequency() {
        return this.field_2_labelFrequency;
    }

    public void setLabelFrequency(short s) {
        this.field_2_labelFrequency = s;
    }

    public short getTickMarkFrequency() {
        return this.field_3_tickMarkFrequency;
    }

    public void setTickMarkFrequency(short s) {
        this.field_3_tickMarkFrequency = s;
    }

    public short getOptions() {
        return this.field_4_options;
    }

    public void setOptions(short s) {
        this.field_4_options = s;
    }

    public void setValueAxisCrossing(boolean bl) {
        this.field_4_options = this.valueAxisCrossing.setShortBoolean(this.field_4_options, bl);
    }

    public boolean isValueAxisCrossing() {
        return this.valueAxisCrossing.isSet(this.field_4_options);
    }

    public void setCrossesFarRight(boolean bl) {
        this.field_4_options = this.crossesFarRight.setShortBoolean(this.field_4_options, bl);
    }

    public boolean isCrossesFarRight() {
        return this.crossesFarRight.isSet(this.field_4_options);
    }

    public void setReversed(boolean bl) {
        this.field_4_options = this.reversed.setShortBoolean(this.field_4_options, bl);
    }

    public boolean isReversed() {
        return this.reversed.isSet(this.field_4_options);
    }
}

