/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class CalcCountRecord
extends Record {
    public static final short sid = 12;
    private short field_1_iterations;

    public CalcCountRecord() {
    }

    public CalcCountRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 12) {
            throw new RecordFormatException("NOT An Calc Count RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_iterations = recordInputStream.readShort();
    }

    public void setIterations(short s) {
        this.field_1_iterations = s;
    }

    public short getIterations() {
        return this.field_1_iterations;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CALCCOUNT]\n");
        stringBuffer.append("    .iterations     = ").append(Integer.toHexString(this.getIterations())).append("\n");
        stringBuffer.append("[/CALCCOUNT]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)12);
        LittleEndian.putShort(byArray, 2 + n, (short)2);
        LittleEndian.putShort(byArray, 4 + n, this.getIterations());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 12;
    }

    public Object clone() {
        CalcCountRecord calcCountRecord = new CalcCountRecord();
        calcCountRecord.field_1_iterations = this.field_1_iterations;
        return calcCountRecord;
    }
}

