/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.constant.ConstantValueParser;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class CRNRecord
extends Record {
    public static final short sid = 90;
    private int field_1_last_column_index;
    private int field_2_first_column_index;
    private int field_3_row_index;
    private Object[] field_4_constant_values;

    public CRNRecord() {
        throw new RuntimeException("incomplete code");
    }

    public CRNRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 90) {
            throw new RecordFormatException("NOT An XCT RECORD");
        }
    }

    public int getNumberOfCRNs() {
        return this.field_1_last_column_index;
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_last_column_index = recordInputStream.readByte() & 0xFF;
        this.field_2_first_column_index = recordInputStream.readByte() & 0xFF;
        this.field_3_row_index = recordInputStream.readShort();
        int n = this.field_1_last_column_index - this.field_2_first_column_index + 1;
        this.field_4_constant_values = ConstantValueParser.parse(recordInputStream, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(" [CRN");
        stringBuffer.append(" rowIx=").append(this.field_3_row_index);
        stringBuffer.append(" firstColIx=").append(this.field_2_first_column_index);
        stringBuffer.append(" lastColIx=").append(this.field_1_last_column_index);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private int getDataSize() {
        return 4 + ConstantValueParser.getEncodedSize(this.field_4_constant_values);
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = this.getDataSize();
        LittleEndian.putShort(byArray, 0 + n, (short)90);
        LittleEndian.putShort(byArray, 2 + n, (short)n2);
        LittleEndian.putByte(byArray, 4 + n, this.field_1_last_column_index);
        LittleEndian.putByte(byArray, 5 + n, this.field_2_first_column_index);
        LittleEndian.putShort(byArray, 6 + n, (short)this.field_3_row_index);
        ConstantValueParser.encode(byArray, 8 + n, this.field_4_constant_values);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return this.getDataSize() + 4;
    }

    public short getSid() {
        return 90;
    }
}

