/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class CRNCountRecord
extends Record {
    public static final short sid = 89;
    private static final short BASE_RECORD_SIZE = 4;
    private int field_1_number_crn_records;
    private int field_2_sheet_table_index;

    public CRNCountRecord() {
        throw new RuntimeException("incomplete code");
    }

    public CRNCountRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 89) {
            throw new RecordFormatException("NOT An XCT RECORD");
        }
    }

    public int getNumberOfCRNs() {
        return this.field_1_number_crn_records;
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_number_crn_records = recordInputStream.readShort();
        if (this.field_1_number_crn_records < 0) {
            this.field_1_number_crn_records = (short)(-this.field_1_number_crn_records);
        }
        this.field_2_sheet_table_index = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(" [XCT");
        stringBuffer.append(" nCRNs=").append(this.field_1_number_crn_records);
        stringBuffer.append(" sheetIx=").append(this.field_2_sheet_table_index);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)89);
        LittleEndian.putShort(byArray, 2 + n, (short)4);
        LittleEndian.putShort(byArray, 4 + n, (short)this.field_1_number_crn_records);
        LittleEndian.putShort(byArray, 6 + n, (short)this.field_2_sheet_table_index);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 89;
    }
}

