/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.model.FormulaParser;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.cf.BorderFormatting;
import com.fr.third.org.apache.poi.hssf.record.cf.FontFormatting;
import com.fr.third.org.apache.poi.hssf.record.cf.PatternFormatting;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class CFRuleRecord
extends Record {
    public static final short sid = 433;
    private byte field_1_condition_type;
    public static final byte CONDITION_TYPE_CELL_VALUE_IS = 1;
    public static final byte CONDITION_TYPE_FORMULA = 2;
    private byte field_2_comparison_operator;
    private int field_5_options;
    private static final BitField modificationBits = CFRuleRecord.bf(0x3FFFFF);
    private static final BitField alignHor = CFRuleRecord.bf(1);
    private static final BitField alignVer = CFRuleRecord.bf(2);
    private static final BitField alignWrap = CFRuleRecord.bf(4);
    private static final BitField alignRot = CFRuleRecord.bf(8);
    private static final BitField alignJustLast = CFRuleRecord.bf(16);
    private static final BitField alignIndent = CFRuleRecord.bf(32);
    private static final BitField alignShrin = CFRuleRecord.bf(64);
    private static final BitField notUsed1 = CFRuleRecord.bf(128);
    private static final BitField protLocked = CFRuleRecord.bf(256);
    private static final BitField protHidden = CFRuleRecord.bf(512);
    private static final BitField bordLeft = CFRuleRecord.bf(1024);
    private static final BitField bordRight = CFRuleRecord.bf(2048);
    private static final BitField bordTop = CFRuleRecord.bf(4096);
    private static final BitField bordBot = CFRuleRecord.bf(8192);
    private static final BitField bordTlBr = CFRuleRecord.bf(16384);
    private static final BitField bordBlTr = CFRuleRecord.bf(32768);
    private static final BitField pattStyle = CFRuleRecord.bf(65536);
    private static final BitField pattCol = CFRuleRecord.bf(131072);
    private static final BitField pattBgCol = CFRuleRecord.bf(262144);
    private static final BitField notUsed2 = CFRuleRecord.bf(0x380000);
    private static final BitField undocumented = CFRuleRecord.bf(0x3C00000);
    private static final BitField fmtBlockBits = CFRuleRecord.bf(0x7C000000);
    private static final BitField font = CFRuleRecord.bf(0x4000000);
    private static final BitField align = CFRuleRecord.bf(0x8000000);
    private static final BitField bord = CFRuleRecord.bf(0x10000000);
    private static final BitField patt = CFRuleRecord.bf(0x20000000);
    private static final BitField prot = CFRuleRecord.bf(0x40000000);
    private static final BitField alignTextDir = CFRuleRecord.bf(Integer.MIN_VALUE);
    private short field_6_not_used;
    private FontFormatting fontFormatting;
    private byte field_8_align_text_break;
    private byte field_9_align_text_rotation_angle;
    private short field_10_align_indentation;
    private short field_11_relative_indentation;
    private short field_12_not_used;
    private BorderFormatting borderFormatting;
    private PatternFormatting patternFormatting;
    private Ptg[] field_17_formula1;
    private Ptg[] field_18_formula2;

    private static BitField bf(int n) {
        return BitFieldFactory.getInstance(n);
    }

    private CFRuleRecord(byte by, byte by2) {
        this.field_1_condition_type = by;
        this.field_2_comparison_operator = by2;
        this.field_5_options = modificationBits.setValue(this.field_5_options, -1);
        this.field_5_options = fmtBlockBits.setValue(this.field_5_options, 0);
        this.field_5_options = undocumented.clear(this.field_5_options);
        this.field_6_not_used = (short)-32766;
        this.fontFormatting = null;
        this.field_8_align_text_break = 0;
        this.field_9_align_text_rotation_angle = 0;
        this.field_10_align_indentation = 0;
        this.field_11_relative_indentation = 0;
        this.field_12_not_used = 0;
        this.borderFormatting = null;
        this.patternFormatting = null;
        this.field_17_formula1 = null;
        this.field_18_formula2 = null;
    }

    private CFRuleRecord(byte by, byte by2, Ptg[] ptgArray, Ptg[] ptgArray2) {
        this(by, by2);
        this.field_1_condition_type = 1;
        this.field_2_comparison_operator = by2;
        this.field_17_formula1 = ptgArray;
        this.field_18_formula2 = ptgArray2;
    }

    public static CFRuleRecord create(HSSFWorkbook hSSFWorkbook, String string) {
        Ptg[] ptgArray = CFRuleRecord.parseFormula(string, hSSFWorkbook);
        return new CFRuleRecord(2, 0, ptgArray, null);
    }

    public static CFRuleRecord create(HSSFWorkbook hSSFWorkbook, byte by, String string, String string2) {
        Ptg[] ptgArray = CFRuleRecord.parseFormula(string, hSSFWorkbook);
        Ptg[] ptgArray2 = CFRuleRecord.parseFormula(string2, hSSFWorkbook);
        return new CFRuleRecord(1, by, ptgArray, ptgArray2);
    }

    public CFRuleRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_condition_type = recordInputStream.readByte();
        this.field_2_comparison_operator = recordInputStream.readByte();
        int n = recordInputStream.readUShort();
        int n2 = recordInputStream.readUShort();
        this.field_5_options = recordInputStream.readInt();
        this.field_6_not_used = recordInputStream.readShort();
        if (this.containsFontFormattingBlock()) {
            this.fontFormatting = new FontFormatting(recordInputStream);
        }
        if (this.containsBorderFormattingBlock()) {
            this.borderFormatting = new BorderFormatting(recordInputStream);
        }
        if (this.containsPatternFormattingBlock()) {
            this.patternFormatting = new PatternFormatting(recordInputStream);
        }
        if (n > 0) {
            this.field_17_formula1 = Ptg.readTokens(n, recordInputStream);
        }
        if (n2 > 0) {
            this.field_18_formula2 = Ptg.readTokens(n2, recordInputStream);
        }
    }

    public byte getConditionType() {
        return this.field_1_condition_type;
    }

    public boolean containsFontFormattingBlock() {
        return this.getOptionFlag(font);
    }

    public void setFontFormatting(FontFormatting fontFormatting) {
        this.fontFormatting = fontFormatting;
        this.setOptionFlag(fontFormatting != null, font);
    }

    public FontFormatting getFontFormatting() {
        if (this.containsFontFormattingBlock()) {
            return this.fontFormatting;
        }
        return null;
    }

    public boolean containsAlignFormattingBlock() {
        return this.getOptionFlag(align);
    }

    public void setAlignFormattingUnchanged() {
        this.setOptionFlag(false, align);
    }

    public boolean containsBorderFormattingBlock() {
        return this.getOptionFlag(bord);
    }

    public void setBorderFormatting(BorderFormatting borderFormatting) {
        this.borderFormatting = borderFormatting;
        this.setOptionFlag(borderFormatting != null, bord);
    }

    public BorderFormatting getBorderFormatting() {
        if (this.containsBorderFormattingBlock()) {
            return this.borderFormatting;
        }
        return null;
    }

    public boolean containsPatternFormattingBlock() {
        return this.getOptionFlag(patt);
    }

    public void setPatternFormatting(PatternFormatting patternFormatting) {
        this.patternFormatting = patternFormatting;
        this.setOptionFlag(patternFormatting != null, patt);
    }

    public PatternFormatting getPatternFormatting() {
        if (this.containsPatternFormattingBlock()) {
            return this.patternFormatting;
        }
        return null;
    }

    public boolean containsProtectionFormattingBlock() {
        return this.getOptionFlag(prot);
    }

    public void setProtectionFormattingUnchanged() {
        this.setOptionFlag(false, prot);
    }

    public void setComparisonOperation(byte by) {
        this.field_2_comparison_operator = by;
    }

    public byte getComparisonOperation() {
        return this.field_2_comparison_operator;
    }

    public int getOptions() {
        return this.field_5_options;
    }

    private boolean isModified(BitField bitField) {
        return !bitField.isSet(this.field_5_options);
    }

    private void setModified(boolean bl, BitField bitField) {
        this.field_5_options = bitField.setBoolean(this.field_5_options, !bl);
    }

    public boolean isLeftBorderModified() {
        return this.isModified(bordLeft);
    }

    public void setLeftBorderModified(boolean bl) {
        this.setModified(bl, bordLeft);
    }

    public boolean isRightBorderModified() {
        return this.isModified(bordRight);
    }

    public void setRightBorderModified(boolean bl) {
        this.setModified(bl, bordRight);
    }

    public boolean isTopBorderModified() {
        return this.isModified(bordTop);
    }

    public void setTopBorderModified(boolean bl) {
        this.setModified(bl, bordTop);
    }

    public boolean isBottomBorderModified() {
        return this.isModified(bordBot);
    }

    public void setBottomBorderModified(boolean bl) {
        this.setModified(bl, bordBot);
    }

    public boolean isTopLeftBottomRightBorderModified() {
        return this.isModified(bordTlBr);
    }

    public void setTopLeftBottomRightBorderModified(boolean bl) {
        this.setModified(bl, bordTlBr);
    }

    public boolean isBottomLeftTopRightBorderModified() {
        return this.isModified(bordBlTr);
    }

    public void setBottomLeftTopRightBorderModified(boolean bl) {
        this.setModified(bl, bordBlTr);
    }

    public boolean isPatternStyleModified() {
        return this.isModified(pattStyle);
    }

    public void setPatternStyleModified(boolean bl) {
        this.setModified(bl, pattStyle);
    }

    public boolean isPatternColorModified() {
        return this.isModified(pattCol);
    }

    public void setPatternColorModified(boolean bl) {
        this.setModified(bl, pattCol);
    }

    public boolean isPatternBackgroundColorModified() {
        return this.isModified(pattBgCol);
    }

    public void setPatternBackgroundColorModified(boolean bl) {
        this.setModified(bl, pattBgCol);
    }

    private boolean getOptionFlag(BitField bitField) {
        return bitField.isSet(this.field_5_options);
    }

    private void setOptionFlag(boolean bl, BitField bitField) {
        this.field_5_options = bitField.setBoolean(this.field_5_options, bl);
    }

    public Ptg[] getParsedExpression1() {
        return this.field_17_formula1;
    }

    public Ptg[] getParsedExpression2() {
        return this.field_18_formula2;
    }

    protected void validateSid(short s) {
        if (s != 433) {
            throw new RecordFormatException("NOT A CFRULE RECORD");
        }
    }

    public short getSid() {
        return 433;
    }

    private static int getFormulaSize(Ptg[] ptgArray) {
        if (ptgArray == null) {
            return 0;
        }
        return Ptg.getEncodedSize(ptgArray);
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = CFRuleRecord.getFormulaSize(this.field_17_formula1);
        int n3 = CFRuleRecord.getFormulaSize(this.field_18_formula2);
        int n4 = n;
        int n5 = this.getRecordSize();
        LittleEndian.putShort(byArray, 0 + n4, (short)433);
        LittleEndian.putShort(byArray, 2 + n4, (short)(n5 - 4));
        byArray[4 + n4] = this.field_1_condition_type;
        byArray[5 + n4] = this.field_2_comparison_operator;
        LittleEndian.putUShort(byArray, 6 + n4, n2);
        LittleEndian.putUShort(byArray, 8 + n4, n3);
        LittleEndian.putInt(byArray, 10 + n4, this.field_5_options);
        LittleEndian.putShort(byArray, 14 + n4, this.field_6_not_used);
        n4 += 16;
        if (this.containsFontFormattingBlock()) {
            byte[] byArray2 = this.fontFormatting.getRawRecord();
            System.arraycopy(byArray2, 0, byArray, n4, byArray2.length);
            n4 += byArray2.length;
        }
        if (this.containsBorderFormattingBlock()) {
            n4 += this.borderFormatting.serialize(n4, byArray);
        }
        if (this.containsPatternFormattingBlock()) {
            n4 += this.patternFormatting.serialize(n4, byArray);
        }
        if (this.field_17_formula1 != null) {
            n4 += Ptg.serializePtgs(this.field_17_formula1, byArray, n4);
        }
        if (this.field_18_formula2 != null) {
            n4 += Ptg.serializePtgs(this.field_18_formula2, byArray, n4);
        }
        if (n4 - n != n5) {
            throw new IllegalStateException("write mismatch (" + (n4 - n) + "!=" + n5 + ")");
        }
        return n5;
    }

    public int getRecordSize() {
        int n = 16 + (this.containsFontFormattingBlock() ? this.fontFormatting.getRawRecord().length : 0) + (this.containsBorderFormattingBlock() ? 8 : 0) + (this.containsPatternFormattingBlock() ? 4 : 0) + CFRuleRecord.getFormulaSize(this.field_17_formula1) + CFRuleRecord.getFormulaSize(this.field_18_formula2);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CFRULE]\n");
        stringBuffer.append("    OPTION FLAGS=0x" + Integer.toHexString(this.getOptions()));
        return stringBuffer.toString();
    }

    public Object clone() {
        CFRuleRecord cFRuleRecord = new CFRuleRecord(this.field_1_condition_type, this.field_2_comparison_operator);
        cFRuleRecord.field_5_options = this.field_5_options;
        cFRuleRecord.field_6_not_used = this.field_6_not_used;
        if (this.containsFontFormattingBlock()) {
            cFRuleRecord.fontFormatting = (FontFormatting)this.fontFormatting.clone();
        }
        if (this.containsBorderFormattingBlock()) {
            cFRuleRecord.borderFormatting = (BorderFormatting)this.borderFormatting.clone();
        }
        if (this.containsPatternFormattingBlock()) {
            cFRuleRecord.patternFormatting = (PatternFormatting)this.patternFormatting.clone();
        }
        if (this.field_17_formula1 != null) {
            cFRuleRecord.field_17_formula1 = (Ptg[])this.field_17_formula1.clone();
        }
        if (this.field_18_formula2 != null) {
            cFRuleRecord.field_18_formula2 = (Ptg[])this.field_18_formula2.clone();
        }
        return cFRuleRecord;
    }

    private static Ptg[] parseFormula(String string, HSSFWorkbook hSSFWorkbook) {
        if (string == null) {
            return null;
        }
        return FormulaParser.parse(string, hSSFWorkbook);
    }

    public static final class ComparisonOperator {
        public static final byte NO_COMPARISON = 0;
        public static final byte BETWEEN = 1;
        public static final byte NOT_BETWEEN = 2;
        public static final byte EQUAL = 3;
        public static final byte NOT_EQUAL = 4;
        public static final byte GT = 5;
        public static final byte LT = 6;
        public static final byte GE = 7;
        public static final byte LE = 8;
    }
}

