/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.cf.CellRange;
import com.fr.third.org.apache.poi.hssf.util.Region;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class CFHeaderRecord
extends Record {
    public static final short sid = 432;
    private static final CellRange[] EMPTY_CELL_RANGE_ARRAY = new CellRange[0];
    private int field_1_numcf;
    private int field_2_need_recalculation;
    private CellRange field_3_enclosing_cell_range;
    private CellRange[] field_4_cell_ranges;

    public CFHeaderRecord() {
        this.field_4_cell_ranges = EMPTY_CELL_RANGE_ARRAY;
    }

    public CFHeaderRecord(Region[] regionArray) {
        CellRange[] cellRangeArray = CellRange.convertRegionsToCellRanges(regionArray);
        CellRange[] cellRangeArray2 = CellRange.mergeCellRanges(cellRangeArray);
        this.setCellRanges(cellRangeArray2);
    }

    public CFHeaderRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_numcf = recordInputStream.readShort();
        this.field_2_need_recalculation = recordInputStream.readShort();
        this.field_3_enclosing_cell_range = new CellRange(recordInputStream.readUShort(), recordInputStream.readUShort(), recordInputStream.readUShort(), recordInputStream.readUShort());
        int n = recordInputStream.readShort();
        CellRange[] cellRangeArray = new CellRange[n];
        for (int i = 0; i < n; ++i) {
            cellRangeArray[i] = new CellRange(recordInputStream.readUShort(), recordInputStream.readUShort(), recordInputStream.readUShort(), recordInputStream.readUShort());
        }
        this.field_4_cell_ranges = cellRangeArray;
    }

    public int getNumberOfConditionalFormats() {
        return this.field_1_numcf;
    }

    public void setNumberOfConditionalFormats(int n) {
        this.field_1_numcf = n;
    }

    public boolean getNeedRecalculation() {
        return this.field_2_need_recalculation == 1;
    }

    public void setNeedRecalculation(boolean bl) {
        this.field_2_need_recalculation = bl ? 1 : 0;
    }

    public CellRange getEnclosingCellRange() {
        return this.field_3_enclosing_cell_range;
    }

    public void setEnclosingCellRange(CellRange cellRange) {
        this.field_3_enclosing_cell_range = cellRange.cloneCellRange();
    }

    public void setCellRanges(CellRange[] cellRangeArray) {
        if (cellRangeArray == null) {
            throw new IllegalArgumentException("cellRanges must not be null");
        }
        this.field_4_cell_ranges = (CellRange[])cellRangeArray.clone();
        CellRange cellRange = null;
        for (int i = 0; i < cellRangeArray.length; ++i) {
            cellRange = cellRangeArray[i].createEnclosingCellRange(cellRange);
        }
        this.field_3_enclosing_cell_range = cellRange;
    }

    public CellRange[] getCellRanges() {
        return (CellRange[])this.field_4_cell_ranges.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CFHEADER]\n");
        stringBuffer.append("\t.id\t\t= ").append(Integer.toHexString(432)).append("\n");
        stringBuffer.append("\t.numCF\t\t\t= ").append(this.getNumberOfConditionalFormats()).append("\n");
        stringBuffer.append("\t.needRecalc\t   = ").append(this.getNeedRecalculation()).append("\n");
        stringBuffer.append("\t.enclosingCellRange= ").append(this.getEnclosingCellRange()).append("\n");
        if (this.field_4_cell_ranges.length > 0) {
            stringBuffer.append("\t.cfranges=[");
            for (int i = 0; i < this.field_4_cell_ranges.length; ++i) {
                stringBuffer.append(i == 0 ? "" : ",").append(this.field_4_cell_ranges[i].toString());
            }
            stringBuffer.append("]\n");
        }
        stringBuffer.append("[/CFHEADER]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = this.getRecordSize();
        LittleEndian.putShort(byArray, 0 + n, (short)432);
        LittleEndian.putShort(byArray, 2 + n, (short)(n2 - 4));
        LittleEndian.putShort(byArray, 4 + n, (short)this.field_1_numcf);
        LittleEndian.putShort(byArray, 6 + n, (short)this.field_2_need_recalculation);
        LittleEndian.putShort(byArray, 8 + n, (short)this.field_3_enclosing_cell_range.getFirstRow());
        LittleEndian.putShort(byArray, 10 + n, (short)this.field_3_enclosing_cell_range.getLastRow());
        LittleEndian.putShort(byArray, 12 + n, (short)this.field_3_enclosing_cell_range.getFirstColumn());
        LittleEndian.putShort(byArray, 14 + n, (short)this.field_3_enclosing_cell_range.getLastColumn());
        LittleEndian.putShort(byArray, 16 + n, (short)this.field_4_cell_ranges.length);
        for (int i = 0; i != this.field_4_cell_ranges.length; ++i) {
            CellRange cellRange = this.field_4_cell_ranges[i];
            LittleEndian.putShort(byArray, 18 + 8 * i + n, (short)cellRange.getFirstRow());
            LittleEndian.putShort(byArray, 20 + 8 * i + n, (short)cellRange.getLastRow());
            LittleEndian.putShort(byArray, 22 + 8 * i + n, (short)cellRange.getFirstColumn());
            LittleEndian.putShort(byArray, 24 + 8 * i + n, (short)cellRange.getLastColumn());
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 18 + 8 * this.field_4_cell_ranges.length;
    }

    protected void validateSid(short s) {
        if (s != 432) {
            throw new RecordFormatException("NOT A ConditionalFormattingHeaderRecord RECORD");
        }
    }

    public short getSid() {
        return 432;
    }

    public Object clone() {
        CFHeaderRecord cFHeaderRecord = new CFHeaderRecord();
        cFHeaderRecord.field_1_numcf = this.field_1_numcf;
        cFHeaderRecord.field_2_need_recalculation = this.field_2_need_recalculation;
        cFHeaderRecord.field_3_enclosing_cell_range = this.field_3_enclosing_cell_range;
        CellRange[] cellRangeArray = new CellRange[this.field_4_cell_ranges.length];
        for (int i = 0; i < cellRangeArray.length; ++i) {
            cellRangeArray[i] = this.field_4_cell_ranges[i].cloneCellRange();
        }
        cFHeaderRecord.field_4_cell_ranges = cellRangeArray;
        return cFHeaderRecord;
    }
}

