/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class BoundSheetRecord
extends Record {
    private static final short HIDDEN_FLAG_MASK = 1;
    public static final short sid = 133;
    private int field_1_position_of_BOF;
    private short field_2_option_flags;
    private byte field_3_sheetname_length;
    private byte field_4_compressed_unicode_flag;
    private String field_5_sheetname;

    public BoundSheetRecord() {
    }

    public BoundSheetRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 133) {
            throw new RecordFormatException("NOT A Bound Sheet RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_position_of_BOF = recordInputStream.readInt();
        this.field_2_option_flags = recordInputStream.readShort();
        this.field_3_sheetname_length = recordInputStream.readByte();
        this.field_4_compressed_unicode_flag = recordInputStream.readByte();
        int n = LittleEndian.ubyteToInt(this.field_3_sheetname_length);
        this.field_5_sheetname = (this.field_4_compressed_unicode_flag & 1) == 1 ? recordInputStream.readUnicodeLEString(n) : recordInputStream.readCompressedUnicode(n);
    }

    public void setPositionOfBof(int n) {
        this.field_1_position_of_BOF = n;
    }

    public void setOptionFlags(short s) {
        this.field_2_option_flags = s;
    }

    public void setSheetnameLength(byte by) {
        this.field_3_sheetname_length = by;
    }

    public void setCompressedUnicodeFlag(byte by) {
        this.field_4_compressed_unicode_flag = by;
    }

    public void setSheetname(String string) {
        if (string == null || string.length() == 0 || string.length() > 31 || string.indexOf("/") > -1 || string.indexOf("\\") > -1 || string.indexOf("?") > -1 || string.indexOf("*") > -1 || string.indexOf("]") > -1 || string.indexOf("[") > -1) {
            throw new IllegalArgumentException("Sheet name cannot be blank, greater than 31 chars, or contain any of /\\*?[]");
        }
        this.field_5_sheetname = string;
        this.setCompressedUnicodeFlag(StringUtil.hasMultibyte(string) ? (byte)1 : 0);
    }

    public int getPositionOfBof() {
        return this.field_1_position_of_BOF;
    }

    public short getOptionFlags() {
        return this.field_2_option_flags;
    }

    public byte getSheetnameLength() {
        return this.field_3_sheetname_length;
    }

    public byte getRawSheetnameLength() {
        return (byte)((this.field_4_compressed_unicode_flag & 1) == 1 ? 2 * this.field_3_sheetname_length : this.field_3_sheetname_length);
    }

    public byte getCompressedUnicodeFlag() {
        return this.field_4_compressed_unicode_flag;
    }

    public String getSheetname() {
        return this.field_5_sheetname;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BOUNDSHEET]\n");
        stringBuffer.append("    .bof             = ").append(Integer.toHexString(this.getPositionOfBof())).append("\n");
        stringBuffer.append("    .optionflags     = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        stringBuffer.append("    .sheetname length= ").append(Integer.toHexString(this.getSheetnameLength())).append("\n");
        stringBuffer.append("    .unicodeflag     = ").append(Integer.toHexString(this.getCompressedUnicodeFlag())).append("\n");
        stringBuffer.append("    .sheetname       = ").append(this.getSheetname()).append("\n");
        stringBuffer.append("[/BOUNDSHEET]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)133);
        LittleEndian.putShort(byArray, 2 + n, (short)(8 + this.getRawSheetnameLength()));
        LittleEndian.putInt(byArray, 4 + n, this.getPositionOfBof());
        LittleEndian.putShort(byArray, 8 + n, this.getOptionFlags());
        byArray[10 + n] = this.getSheetnameLength();
        byArray[11 + n] = this.getCompressedUnicodeFlag();
        if ((this.field_4_compressed_unicode_flag & 1) == 1) {
            StringUtil.putUnicodeLE(this.getSheetname(), byArray, 12 + n);
        } else {
            StringUtil.putCompressedUnicode(this.getSheetname(), byArray, 12 + n);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 12 + this.getRawSheetnameLength();
    }

    public short getSid() {
        return 133;
    }

    public boolean isHidden() {
        return BitFieldFactory.getInstance(1).isSet(this.field_2_option_flags);
    }

    public void setHidden(boolean bl) {
        this.field_2_option_flags = BitFieldFactory.getInstance(1).setShortBoolean(this.field_2_option_flags, bl);
    }
}

