/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class BoolErrRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    public static final short sid = 517;
    private int field_1_row;
    private short field_2_column;
    private short field_3_xf_index;
    private byte field_4_bBoolErr;
    private byte field_5_fError;

    public BoolErrRecord() {
    }

    public BoolErrRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_column = recordInputStream.readShort();
        this.field_3_xf_index = recordInputStream.readShort();
        this.field_4_bBoolErr = recordInputStream.readByte();
        this.field_5_fError = recordInputStream.readByte();
    }

    public void setRow(int n) {
        this.field_1_row = n;
    }

    public void setColumn(short s) {
        this.field_2_column = s;
    }

    public void setXFIndex(short s) {
        this.field_3_xf_index = s;
    }

    public void setValue(boolean bl) {
        this.field_4_bBoolErr = bl ? (byte)1 : 0;
        this.field_5_fError = 0;
    }

    public void setValue(byte by) {
        if (by != 0 && by != 7 && by != 15 && by != 23 && by != 29 && by != 36 && by != 42) {
            throw new RuntimeException("Error Value can only be 0,7,15,23,29,36 or 42. It cannot be " + by);
        }
        this.field_4_bBoolErr = by;
        this.field_5_fError = 1;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_column;
    }

    public short getXFIndex() {
        return this.field_3_xf_index;
    }

    public boolean getBooleanValue() {
        return this.field_4_bBoolErr != 0;
    }

    public byte getErrorValue() {
        return this.field_4_bBoolErr;
    }

    public boolean isBoolean() {
        return this.field_5_fError == 0;
    }

    public void setError(boolean bl) {
        this.field_5_fError = (byte)(bl ? 1 : 0);
    }

    public boolean isError() {
        return this.field_5_fError != 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BOOLERR]\n");
        stringBuffer.append("    .row            = ").append(Integer.toHexString(this.getRow())).append("\n");
        stringBuffer.append("    .col            = ").append(Integer.toHexString(this.getColumn())).append("\n");
        stringBuffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        if (this.isBoolean()) {
            stringBuffer.append("    .booleanValue   = ").append(this.getBooleanValue()).append("\n");
        } else {
            stringBuffer.append("    .errorValue     = ").append(this.getErrorValue()).append("\n");
        }
        stringBuffer.append("[/BOOLERR]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)517);
        LittleEndian.putShort(byArray, 2 + n, (short)8);
        LittleEndian.putShort(byArray, 4 + n, (short)this.getRow());
        LittleEndian.putShort(byArray, 6 + n, this.getColumn());
        LittleEndian.putShort(byArray, 8 + n, this.getXFIndex());
        byArray[10 + n] = this.field_4_bBoolErr;
        byArray[11 + n] = this.field_5_fError;
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 12;
    }

    protected void validateSid(short s) {
        if (s != 517) {
            throw new RecordFormatException("Not a valid BoolErrRecord");
        }
    }

    public short getSid() {
        return 517;
    }

    public boolean isBefore(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() > cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() > cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isAfter(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() < cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() < cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isEqual(CellValueRecordInterface cellValueRecordInterface) {
        return this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn();
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public int compareTo(Object object) {
        CellValueRecordInterface cellValueRecordInterface = (CellValueRecordInterface)object;
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn()) {
            return 0;
        }
        if (this.getRow() < cellValueRecordInterface.getRow()) {
            return -1;
        }
        if (this.getRow() > cellValueRecordInterface.getRow()) {
            return 1;
        }
        if (this.getColumn() < cellValueRecordInterface.getColumn()) {
            return -1;
        }
        if (this.getColumn() > cellValueRecordInterface.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface cellValueRecordInterface = (CellValueRecordInterface)object;
        return this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn();
    }

    public Object clone() {
        BoolErrRecord boolErrRecord = new BoolErrRecord();
        boolErrRecord.field_1_row = this.field_1_row;
        boolErrRecord.field_2_column = this.field_2_column;
        boolErrRecord.field_3_xf_index = this.field_3_xf_index;
        boolErrRecord.field_4_bBoolErr = this.field_4_bBoolErr;
        boolErrRecord.field_5_fError = this.field_5_fError;
        return boolErrRecord;
    }
}

