/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class BlankRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    public static final short sid = 513;
    private int field_1_row;
    private short field_2_col;
    private short field_3_xf;

    public BlankRecord() {
    }

    public BlankRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_col = recordInputStream.readShort();
        this.field_3_xf = recordInputStream.readShort();
    }

    protected void validateSid(short s) {
        if (s != 513) {
            throw new RecordFormatException("NOT A BLANKRECORD!");
        }
    }

    public void setRow(int n) {
        this.field_1_row = n;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_col;
    }

    public void setXFIndex(short s) {
        this.field_3_xf = s;
    }

    public short getXFIndex() {
        return this.field_3_xf;
    }

    public void setColumn(short s) {
        this.field_2_col = s;
    }

    public boolean isBefore(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() > cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() > cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isAfter(CellValueRecordInterface cellValueRecordInterface) {
        if (this.getRow() < cellValueRecordInterface.getRow()) {
            return false;
        }
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() < cellValueRecordInterface.getColumn()) {
            return false;
        }
        return this.getRow() != cellValueRecordInterface.getRow() || this.getColumn() != cellValueRecordInterface.getColumn();
    }

    public boolean isEqual(CellValueRecordInterface cellValueRecordInterface) {
        return this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn();
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public short getSid() {
        return 513;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BLANK]\n");
        stringBuffer.append("row       = ").append(Integer.toHexString(this.getRow())).append("\n");
        stringBuffer.append("col       = ").append(Integer.toHexString(this.getColumn())).append("\n");
        stringBuffer.append("xf        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        stringBuffer.append("[/BLANK]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)513);
        LittleEndian.putShort(byArray, 2 + n, (short)6);
        LittleEndian.putShort(byArray, 4 + n, (short)this.getRow());
        LittleEndian.putShort(byArray, 6 + n, this.getColumn());
        LittleEndian.putShort(byArray, 8 + n, this.getXFIndex());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 10;
    }

    public int compareTo(Object object) {
        CellValueRecordInterface cellValueRecordInterface = (CellValueRecordInterface)object;
        if (this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn()) {
            return 0;
        }
        if (this.getRow() < cellValueRecordInterface.getRow()) {
            return -1;
        }
        if (this.getRow() > cellValueRecordInterface.getRow()) {
            return 1;
        }
        if (this.getColumn() < cellValueRecordInterface.getColumn()) {
            return -1;
        }
        if (this.getColumn() > cellValueRecordInterface.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface cellValueRecordInterface = (CellValueRecordInterface)object;
        return this.getRow() == cellValueRecordInterface.getRow() && this.getColumn() == cellValueRecordInterface.getColumn();
    }

    public Object clone() {
        BlankRecord blankRecord = new BlankRecord();
        blankRecord.field_1_row = this.field_1_row;
        blankRecord.field_2_col = this.field_2_col;
        blankRecord.field_3_xf = this.field_3_xf;
        return blankRecord;
    }
}

