/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class BarRecord
extends Record {
    public static final short sid = 4119;
    private short field_1_barSpace;
    private short field_2_categorySpace;
    private short field_3_formatFlags;
    private BitField horizontal = BitFieldFactory.getInstance(1);
    private BitField stacked = BitFieldFactory.getInstance(2);
    private BitField displayAsPercentage = BitFieldFactory.getInstance(4);
    private BitField shadow = BitFieldFactory.getInstance(8);

    public BarRecord() {
    }

    public BarRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4119) {
            throw new RecordFormatException("Not a Bar record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_barSpace = recordInputStream.readShort();
        this.field_2_categorySpace = recordInputStream.readShort();
        this.field_3_formatFlags = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BAR]\n");
        stringBuffer.append("    .barSpace             = ").append("0x").append(HexDump.toHex(this.getBarSpace())).append(" (").append(this.getBarSpace()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .categorySpace        = ").append("0x").append(HexDump.toHex(this.getCategorySpace())).append(" (").append(this.getCategorySpace()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .formatFlags          = ").append("0x").append(HexDump.toHex(this.getFormatFlags())).append(" (").append(this.getFormatFlags()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .horizontal               = ").append(this.isHorizontal()).append('\n');
        stringBuffer.append("         .stacked                  = ").append(this.isStacked()).append('\n');
        stringBuffer.append("         .displayAsPercentage      = ").append(this.isDisplayAsPercentage()).append('\n');
        stringBuffer.append("         .shadow                   = ").append(this.isShadow()).append('\n');
        stringBuffer.append("[/BAR]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4119);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n + n2, this.field_1_barSpace);
        LittleEndian.putShort(byArray, 6 + n + n2, this.field_2_categorySpace);
        LittleEndian.putShort(byArray, 8 + n + n2, this.field_3_formatFlags);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 10;
    }

    public short getSid() {
        return 4119;
    }

    public Object clone() {
        BarRecord barRecord = new BarRecord();
        barRecord.field_1_barSpace = this.field_1_barSpace;
        barRecord.field_2_categorySpace = this.field_2_categorySpace;
        barRecord.field_3_formatFlags = this.field_3_formatFlags;
        return barRecord;
    }

    public short getBarSpace() {
        return this.field_1_barSpace;
    }

    public void setBarSpace(short s) {
        this.field_1_barSpace = s;
    }

    public short getCategorySpace() {
        return this.field_2_categorySpace;
    }

    public void setCategorySpace(short s) {
        this.field_2_categorySpace = s;
    }

    public short getFormatFlags() {
        return this.field_3_formatFlags;
    }

    public void setFormatFlags(short s) {
        this.field_3_formatFlags = s;
    }

    public void setHorizontal(boolean bl) {
        this.field_3_formatFlags = this.horizontal.setShortBoolean(this.field_3_formatFlags, bl);
    }

    public boolean isHorizontal() {
        return this.horizontal.isSet(this.field_3_formatFlags);
    }

    public void setStacked(boolean bl) {
        this.field_3_formatFlags = this.stacked.setShortBoolean(this.field_3_formatFlags, bl);
    }

    public boolean isStacked() {
        return this.stacked.isSet(this.field_3_formatFlags);
    }

    public void setDisplayAsPercentage(boolean bl) {
        this.field_3_formatFlags = this.displayAsPercentage.setShortBoolean(this.field_3_formatFlags, bl);
    }

    public boolean isDisplayAsPercentage() {
        return this.displayAsPercentage.isSet(this.field_3_formatFlags);
    }

    public void setShadow(boolean bl) {
        this.field_3_formatFlags = this.shadow.setShortBoolean(this.field_3_formatFlags, bl);
    }

    public boolean isShadow() {
        return this.shadow.isSet(this.field_3_formatFlags);
    }
}

