/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class BOFRecord
extends Record {
    public static final short sid = 2057;
    private short field_1_version;
    private short field_2_type;
    private short field_3_build;
    private short field_4_year;
    private int field_5_history;
    private int field_6_rversion;
    public static final short VERSION = 6;
    public static final short BUILD = 4307;
    public static final short BUILD_YEAR = 1996;
    public static final short HISTORY_MASK = 65;
    public static final short TYPE_WORKBOOK = 5;
    public static final short TYPE_VB_MODULE = 6;
    public static final short TYPE_WORKSHEET = 16;
    public static final short TYPE_CHART = 32;
    public static final short TYPE_EXCEL_4_MACRO = 64;
    public static final short TYPE_WORKSPACE_FILE = 256;

    public BOFRecord() {
    }

    public BOFRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 2057) {
            throw new RecordFormatException("NOT A BOF RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_version = recordInputStream.readShort();
        this.field_2_type = recordInputStream.readShort();
        if (recordInputStream.remaining() >= 2) {
            this.field_3_build = recordInputStream.readShort();
        }
        if (recordInputStream.remaining() >= 2) {
            this.field_4_year = recordInputStream.readShort();
        }
        if (recordInputStream.remaining() >= 4) {
            this.field_5_history = recordInputStream.readInt();
        }
        if (recordInputStream.remaining() >= 4) {
            this.field_6_rversion = recordInputStream.readInt();
        }
    }

    public void setVersion(short s) {
        this.field_1_version = s;
    }

    public void setType(short s) {
        this.field_2_type = s;
    }

    public void setBuild(short s) {
        this.field_3_build = s;
    }

    public void setBuildYear(short s) {
        this.field_4_year = s;
    }

    public void setHistoryBitMask(int n) {
        this.field_5_history = n;
    }

    public void setRequiredVersion(int n) {
        this.field_6_rversion = n;
    }

    public short getVersion() {
        return this.field_1_version;
    }

    public short getType() {
        return this.field_2_type;
    }

    public short getBuild() {
        return this.field_3_build;
    }

    public short getBuildYear() {
        return this.field_4_year;
    }

    public int getHistoryBitMask() {
        return this.field_5_history;
    }

    public int getRequiredVersion() {
        return this.field_6_rversion;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BOF RECORD]\n");
        stringBuffer.append("    .version         = ").append(Integer.toHexString(this.getVersion())).append("\n");
        stringBuffer.append("    .type            = ").append(Integer.toHexString(this.getType())).append("\n");
        stringBuffer.append("    .build           = ").append(Integer.toHexString(this.getBuild())).append("\n");
        stringBuffer.append("    .buildyear       = ").append(this.getBuildYear()).append("\n");
        stringBuffer.append("    .history         = ").append(Integer.toHexString(this.getHistoryBitMask())).append("\n");
        stringBuffer.append("    .requiredversion = ").append(Integer.toHexString(this.getRequiredVersion())).append("\n");
        stringBuffer.append("[/BOF RECORD]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)2057);
        LittleEndian.putShort(byArray, 2 + n, (short)16);
        LittleEndian.putShort(byArray, 4 + n, this.getVersion());
        LittleEndian.putShort(byArray, 6 + n, this.getType());
        LittleEndian.putShort(byArray, 8 + n, this.getBuild());
        LittleEndian.putShort(byArray, 10 + n, this.getBuildYear());
        LittleEndian.putInt(byArray, 12 + n, this.getHistoryBitMask());
        LittleEndian.putInt(byArray, 16 + n, this.getRequiredVersion());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20;
    }

    public short getSid() {
        return 2057;
    }

    public Object clone() {
        BOFRecord bOFRecord = new BOFRecord();
        bOFRecord.field_1_version = this.field_1_version;
        bOFRecord.field_2_type = this.field_2_type;
        bOFRecord.field_3_build = this.field_3_build;
        bOFRecord.field_4_year = this.field_4_year;
        bOFRecord.field_5_history = this.field_5_history;
        bOFRecord.field_6_rversion = this.field_6_rversion;
        return bOFRecord;
    }
}

