/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class AxisOptionsRecord
extends Record {
    public static final short sid = 4194;
    private short field_1_minimumCategory;
    private short field_2_maximumCategory;
    private short field_3_majorUnitValue;
    private short field_4_majorUnit;
    private short field_5_minorUnitValue;
    private short field_6_minorUnit;
    private short field_7_baseUnit;
    private short field_8_crossingPoint;
    private short field_9_options;
    private BitField defaultMinimum = BitFieldFactory.getInstance(1);
    private BitField defaultMaximum = BitFieldFactory.getInstance(2);
    private BitField defaultMajor = BitFieldFactory.getInstance(4);
    private BitField defaultMinorUnit = BitFieldFactory.getInstance(8);
    private BitField isDate = BitFieldFactory.getInstance(16);
    private BitField defaultBase = BitFieldFactory.getInstance(32);
    private BitField defaultCross = BitFieldFactory.getInstance(64);
    private BitField defaultDateSettings = BitFieldFactory.getInstance(128);

    public AxisOptionsRecord() {
    }

    public AxisOptionsRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4194) {
            throw new RecordFormatException("Not a AxisOptions record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_minimumCategory = recordInputStream.readShort();
        this.field_2_maximumCategory = recordInputStream.readShort();
        this.field_3_majorUnitValue = recordInputStream.readShort();
        this.field_4_majorUnit = recordInputStream.readShort();
        this.field_5_minorUnitValue = recordInputStream.readShort();
        this.field_6_minorUnit = recordInputStream.readShort();
        this.field_7_baseUnit = recordInputStream.readShort();
        this.field_8_crossingPoint = recordInputStream.readShort();
        this.field_9_options = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[AXCEXT]\n");
        stringBuffer.append("    .minimumCategory      = ").append("0x").append(HexDump.toHex(this.getMinimumCategory())).append(" (").append(this.getMinimumCategory()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .maximumCategory      = ").append("0x").append(HexDump.toHex(this.getMaximumCategory())).append(" (").append(this.getMaximumCategory()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .majorUnitValue       = ").append("0x").append(HexDump.toHex(this.getMajorUnitValue())).append(" (").append(this.getMajorUnitValue()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .majorUnit            = ").append("0x").append(HexDump.toHex(this.getMajorUnit())).append(" (").append(this.getMajorUnit()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .minorUnitValue       = ").append("0x").append(HexDump.toHex(this.getMinorUnitValue())).append(" (").append(this.getMinorUnitValue()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .minorUnit            = ").append("0x").append(HexDump.toHex(this.getMinorUnit())).append(" (").append(this.getMinorUnit()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .baseUnit             = ").append("0x").append(HexDump.toHex(this.getBaseUnit())).append(" (").append(this.getBaseUnit()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .crossingPoint        = ").append("0x").append(HexDump.toHex(this.getCrossingPoint())).append(" (").append(this.getCrossingPoint()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .defaultMinimum           = ").append(this.isDefaultMinimum()).append('\n');
        stringBuffer.append("         .defaultMaximum           = ").append(this.isDefaultMaximum()).append('\n');
        stringBuffer.append("         .defaultMajor             = ").append(this.isDefaultMajor()).append('\n');
        stringBuffer.append("         .defaultMinorUnit         = ").append(this.isDefaultMinorUnit()).append('\n');
        stringBuffer.append("         .isDate                   = ").append(this.isIsDate()).append('\n');
        stringBuffer.append("         .defaultBase              = ").append(this.isDefaultBase()).append('\n');
        stringBuffer.append("         .defaultCross             = ").append(this.isDefaultCross()).append('\n');
        stringBuffer.append("         .defaultDateSettings      = ").append(this.isDefaultDateSettings()).append('\n');
        stringBuffer.append("[/AXCEXT]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4194);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n + n2, this.field_1_minimumCategory);
        LittleEndian.putShort(byArray, 6 + n + n2, this.field_2_maximumCategory);
        LittleEndian.putShort(byArray, 8 + n + n2, this.field_3_majorUnitValue);
        LittleEndian.putShort(byArray, 10 + n + n2, this.field_4_majorUnit);
        LittleEndian.putShort(byArray, 12 + n + n2, this.field_5_minorUnitValue);
        LittleEndian.putShort(byArray, 14 + n + n2, this.field_6_minorUnit);
        LittleEndian.putShort(byArray, 16 + n + n2, this.field_7_baseUnit);
        LittleEndian.putShort(byArray, 18 + n + n2, this.field_8_crossingPoint);
        LittleEndian.putShort(byArray, 20 + n + n2, this.field_9_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 4194;
    }

    public Object clone() {
        AxisOptionsRecord axisOptionsRecord = new AxisOptionsRecord();
        axisOptionsRecord.field_1_minimumCategory = this.field_1_minimumCategory;
        axisOptionsRecord.field_2_maximumCategory = this.field_2_maximumCategory;
        axisOptionsRecord.field_3_majorUnitValue = this.field_3_majorUnitValue;
        axisOptionsRecord.field_4_majorUnit = this.field_4_majorUnit;
        axisOptionsRecord.field_5_minorUnitValue = this.field_5_minorUnitValue;
        axisOptionsRecord.field_6_minorUnit = this.field_6_minorUnit;
        axisOptionsRecord.field_7_baseUnit = this.field_7_baseUnit;
        axisOptionsRecord.field_8_crossingPoint = this.field_8_crossingPoint;
        axisOptionsRecord.field_9_options = this.field_9_options;
        return axisOptionsRecord;
    }

    public short getMinimumCategory() {
        return this.field_1_minimumCategory;
    }

    public void setMinimumCategory(short s) {
        this.field_1_minimumCategory = s;
    }

    public short getMaximumCategory() {
        return this.field_2_maximumCategory;
    }

    public void setMaximumCategory(short s) {
        this.field_2_maximumCategory = s;
    }

    public short getMajorUnitValue() {
        return this.field_3_majorUnitValue;
    }

    public void setMajorUnitValue(short s) {
        this.field_3_majorUnitValue = s;
    }

    public short getMajorUnit() {
        return this.field_4_majorUnit;
    }

    public void setMajorUnit(short s) {
        this.field_4_majorUnit = s;
    }

    public short getMinorUnitValue() {
        return this.field_5_minorUnitValue;
    }

    public void setMinorUnitValue(short s) {
        this.field_5_minorUnitValue = s;
    }

    public short getMinorUnit() {
        return this.field_6_minorUnit;
    }

    public void setMinorUnit(short s) {
        this.field_6_minorUnit = s;
    }

    public short getBaseUnit() {
        return this.field_7_baseUnit;
    }

    public void setBaseUnit(short s) {
        this.field_7_baseUnit = s;
    }

    public short getCrossingPoint() {
        return this.field_8_crossingPoint;
    }

    public void setCrossingPoint(short s) {
        this.field_8_crossingPoint = s;
    }

    public short getOptions() {
        return this.field_9_options;
    }

    public void setOptions(short s) {
        this.field_9_options = s;
    }

    public void setDefaultMinimum(boolean bl) {
        this.field_9_options = this.defaultMinimum.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultMinimum() {
        return this.defaultMinimum.isSet(this.field_9_options);
    }

    public void setDefaultMaximum(boolean bl) {
        this.field_9_options = this.defaultMaximum.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultMaximum() {
        return this.defaultMaximum.isSet(this.field_9_options);
    }

    public void setDefaultMajor(boolean bl) {
        this.field_9_options = this.defaultMajor.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultMajor() {
        return this.defaultMajor.isSet(this.field_9_options);
    }

    public void setDefaultMinorUnit(boolean bl) {
        this.field_9_options = this.defaultMinorUnit.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultMinorUnit() {
        return this.defaultMinorUnit.isSet(this.field_9_options);
    }

    public void setIsDate(boolean bl) {
        this.field_9_options = this.isDate.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isIsDate() {
        return this.isDate.isSet(this.field_9_options);
    }

    public void setDefaultBase(boolean bl) {
        this.field_9_options = this.defaultBase.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultBase() {
        return this.defaultBase.isSet(this.field_9_options);
    }

    public void setDefaultCross(boolean bl) {
        this.field_9_options = this.defaultCross.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultCross() {
        return this.defaultCross.isSet(this.field_9_options);
    }

    public void setDefaultDateSettings(boolean bl) {
        this.field_9_options = this.defaultDateSettings.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultDateSettings() {
        return this.defaultDateSettings.isSet(this.field_9_options);
    }
}

