/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class AreaRecord
extends Record {
    public static final short sid = 4122;
    private short field_1_formatFlags;
    private BitField stacked = BitFieldFactory.getInstance(1);
    private BitField displayAsPercentage = BitFieldFactory.getInstance(2);
    private BitField shadow = BitFieldFactory.getInstance(4);

    public AreaRecord() {
    }

    public AreaRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4122) {
            throw new RecordFormatException("Not a Area record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_formatFlags = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[AREA]\n");
        stringBuffer.append("    .formatFlags          = ").append("0x").append(HexDump.toHex(this.getFormatFlags())).append(" (").append(this.getFormatFlags()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .stacked                  = ").append(this.isStacked()).append('\n');
        stringBuffer.append("         .displayAsPercentage      = ").append(this.isDisplayAsPercentage()).append('\n');
        stringBuffer.append("         .shadow                   = ").append(this.isShadow()).append('\n');
        stringBuffer.append("[/AREA]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4122);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n + n2, this.field_1_formatFlags);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4122;
    }

    public Object clone() {
        AreaRecord areaRecord = new AreaRecord();
        areaRecord.field_1_formatFlags = this.field_1_formatFlags;
        return areaRecord;
    }

    public short getFormatFlags() {
        return this.field_1_formatFlags;
    }

    public void setFormatFlags(short s) {
        this.field_1_formatFlags = s;
    }

    public void setStacked(boolean bl) {
        this.field_1_formatFlags = this.stacked.setShortBoolean(this.field_1_formatFlags, bl);
    }

    public boolean isStacked() {
        return this.stacked.isSet(this.field_1_formatFlags);
    }

    public void setDisplayAsPercentage(boolean bl) {
        this.field_1_formatFlags = this.displayAsPercentage.setShortBoolean(this.field_1_formatFlags, bl);
    }

    public boolean isDisplayAsPercentage() {
        return this.displayAsPercentage.isSet(this.field_1_formatFlags);
    }

    public void setShadow(boolean bl) {
        this.field_1_formatFlags = this.shadow.setShortBoolean(this.field_1_formatFlags, bl);
    }

    public boolean isShadow() {
        return this.shadow.isSet(this.field_1_formatFlags);
    }
}

