/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.ddf.DefaultEscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherContainerRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.NullEscherSerializationListener;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractEscherHolderRecord
extends Record {
    private static boolean DESERIALISE;
    private List escherRecords;
    private byte[] rawData;

    public AbstractEscherHolderRecord() {
        this.escherRecords = new ArrayList();
    }

    public AbstractEscherHolderRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != this.getSid()) {
            throw new RecordFormatException("Not an escher record! (sid was " + s + ", expecting " + this.getSid() + ")");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.escherRecords = new ArrayList();
        if (!DESERIALISE) {
            this.rawData = recordInputStream.readRemainder();
        } else {
            byte[] byArray = recordInputStream.readAllContinuedRemainder();
            this.convertToEscherRecords(0, byArray.length, byArray);
        }
    }

    protected void convertRawBytesToEscherRecords() {
        this.convertToEscherRecords(0, this.rawData.length, this.rawData);
    }

    private void convertToEscherRecords(int n, int n2, byte[] byArray) {
        int n3;
        DefaultEscherRecordFactory defaultEscherRecordFactory = new DefaultEscherRecordFactory();
        for (int i = n; i < n + n2; i += n3) {
            EscherRecord escherRecord = defaultEscherRecordFactory.createRecord(byArray, i);
            n3 = escherRecord.fillFields(byArray, i, defaultEscherRecordFactory);
            this.escherRecords.add(escherRecord);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append('[' + this.getRecordName() + ']' + string);
        if (this.escherRecords.size() == 0) {
            stringBuffer.append("No Escher Records Decoded" + string);
        }
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            stringBuffer.append(escherRecord.toString());
        }
        stringBuffer.append("[/" + this.getRecordName() + ']' + string);
        return stringBuffer.toString();
    }

    protected abstract String getRecordName();

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, this.getSid());
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        if (this.escherRecords.size() == 0 && this.rawData != null) {
            LittleEndian.putShort(byArray, 0 + n, this.getSid());
            LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
            System.arraycopy(this.rawData, 0, byArray, 4 + n, this.rawData.length);
            return this.rawData.length + 4;
        }
        LittleEndian.putShort(byArray, 0 + n, this.getSid());
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        int n2 = n + 4;
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            n2 += escherRecord.serialize(n2, byArray, new NullEscherSerializationListener());
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        if (this.escherRecords.size() == 0 && this.rawData != null) {
            return this.rawData.length + 4;
        }
        int n = 4;
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            n += escherRecord.getRecordSize();
        }
        return n;
    }

    public abstract short getSid();

    public Object clone() {
        return this.cloneViaReserialise();
    }

    public void addEscherRecord(int n, EscherRecord escherRecord) {
        this.escherRecords.add(n, escherRecord);
    }

    public boolean addEscherRecord(EscherRecord escherRecord) {
        return this.escherRecords.add(escherRecord);
    }

    public List getEscherRecords() {
        return this.escherRecords;
    }

    public void clearEscherRecords() {
        this.escherRecords.clear();
    }

    public EscherContainerRecord getEscherContainer() {
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EscherContainerRecord)) continue;
            return (EscherContainerRecord)e;
        }
        return null;
    }

    public EscherRecord findFirstWithId(short s) {
        return this.findFirstWithId(s, this.getEscherRecords());
    }

    private EscherRecord findFirstWithId(short s, List list) {
        EscherRecord escherRecord;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            escherRecord = (EscherRecord)iterator.next();
            if (escherRecord.getRecordId() != s) continue;
            return escherRecord;
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord2;
            escherRecord = (EscherRecord)iterator.next();
            if (!escherRecord.isContainerRecord() || (escherRecord2 = this.findFirstWithId(s, escherRecord.getChildRecords())) == null) continue;
            return escherRecord2;
        }
        return null;
    }

    public EscherRecord getEscherRecord(int n) {
        return (EscherRecord)this.escherRecords.get(n);
    }

    public void join(AbstractEscherHolderRecord abstractEscherHolderRecord) {
        int n = this.rawData.length + abstractEscherHolderRecord.getRawData().length;
        byte[] byArray = new byte[n];
        System.arraycopy(this.rawData, 0, byArray, 0, this.rawData.length);
        System.arraycopy(abstractEscherHolderRecord.getRawData(), 0, byArray, this.rawData.length, abstractEscherHolderRecord.getRawData().length);
        this.rawData = byArray;
    }

    public void processContinueRecord(byte[] byArray) {
        int n = this.rawData.length + byArray.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(this.rawData, 0, byArray2, 0, this.rawData.length);
        System.arraycopy(byArray, 0, byArray2, this.rawData.length, byArray.length);
        this.rawData = byArray2;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public void setRawData(byte[] byArray) {
        this.rawData = byArray;
    }

    public void decode() {
        this.convertToEscherRecords(0, this.rawData.length, this.rawData);
    }

    static {
        try {
            DESERIALISE = System.getProperty("poi.deserialize.escher") != null;
        }
        catch (SecurityException securityException) {
            DESERIALISE = false;
        }
    }
}

