/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.model;

import com.fr.third.org.apache.poi.ddf.EscherBSERecord;
import com.fr.third.org.apache.poi.ddf.EscherBoolProperty;
import com.fr.third.org.apache.poi.ddf.EscherContainerRecord;
import com.fr.third.org.apache.poi.ddf.EscherDggRecord;
import com.fr.third.org.apache.poi.ddf.EscherOptRecord;
import com.fr.third.org.apache.poi.ddf.EscherRGBProperty;
import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherSplitMenuColorsRecord;
import com.fr.third.org.apache.poi.hssf.model.DrawingManager2;
import com.fr.third.org.apache.poi.hssf.model.LinkTable;
import com.fr.third.org.apache.poi.hssf.model.Model;
import com.fr.third.org.apache.poi.hssf.model.WorkbookRecordList;
import com.fr.third.org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import com.fr.third.org.apache.poi.hssf.record.BOFRecord;
import com.fr.third.org.apache.poi.hssf.record.BackupRecord;
import com.fr.third.org.apache.poi.hssf.record.BookBoolRecord;
import com.fr.third.org.apache.poi.hssf.record.BoundSheetRecord;
import com.fr.third.org.apache.poi.hssf.record.CodepageRecord;
import com.fr.third.org.apache.poi.hssf.record.CountryRecord;
import com.fr.third.org.apache.poi.hssf.record.DSFRecord;
import com.fr.third.org.apache.poi.hssf.record.DateWindow1904Record;
import com.fr.third.org.apache.poi.hssf.record.DrawingGroupRecord;
import com.fr.third.org.apache.poi.hssf.record.EOFRecord;
import com.fr.third.org.apache.poi.hssf.record.ExtSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.ExtendedFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.FilePassRecord;
import com.fr.third.org.apache.poi.hssf.record.FileSharingRecord;
import com.fr.third.org.apache.poi.hssf.record.FnGroupCountRecord;
import com.fr.third.org.apache.poi.hssf.record.FontRecord;
import com.fr.third.org.apache.poi.hssf.record.FormatRecord;
import com.fr.third.org.apache.poi.hssf.record.HideObjRecord;
import com.fr.third.org.apache.poi.hssf.record.InterfaceEndRecord;
import com.fr.third.org.apache.poi.hssf.record.InterfaceHdrRecord;
import com.fr.third.org.apache.poi.hssf.record.MMSRecord;
import com.fr.third.org.apache.poi.hssf.record.NameRecord;
import com.fr.third.org.apache.poi.hssf.record.PaletteRecord;
import com.fr.third.org.apache.poi.hssf.record.PasswordRecord;
import com.fr.third.org.apache.poi.hssf.record.PasswordRev4Record;
import com.fr.third.org.apache.poi.hssf.record.PrecisionRecord;
import com.fr.third.org.apache.poi.hssf.record.ProtectRecord;
import com.fr.third.org.apache.poi.hssf.record.ProtectionRev4Record;
import com.fr.third.org.apache.poi.hssf.record.RecalcIdRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RefreshAllRecord;
import com.fr.third.org.apache.poi.hssf.record.SSTRecord;
import com.fr.third.org.apache.poi.hssf.record.StyleRecord;
import com.fr.third.org.apache.poi.hssf.record.TabIdRecord;
import com.fr.third.org.apache.poi.hssf.record.UnicodeString;
import com.fr.third.org.apache.poi.hssf.record.UseSelFSRecord;
import com.fr.third.org.apache.poi.hssf.record.WindowOneRecord;
import com.fr.third.org.apache.poi.hssf.record.WindowProtectRecord;
import com.fr.third.org.apache.poi.hssf.record.WriteAccessRecord;
import com.fr.third.org.apache.poi.hssf.record.WriteProtectRecord;
import com.fr.third.org.apache.poi.hssf.util.SheetReferences;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class Workbook
implements Model {
    private static final int DEBUG = 1;
    private static final short CODEPAGE = 1200;
    protected WorkbookRecordList records = new WorkbookRecordList();
    protected SSTRecord sst = null;
    private LinkTable linkTable;
    protected ArrayList boundsheets = new ArrayList();
    protected ArrayList formats = new ArrayList();
    protected ArrayList hyperlinks = new ArrayList();
    protected int numxfs = 0;
    protected int numfonts = 0;
    private short maxformatid = (short)-1;
    private boolean uses1904datewindowing = false;
    private DrawingManager2 drawingManager;
    private List escherBSERecords = new ArrayList();
    private WindowOneRecord windowOne;
    private FileSharingRecord fileShare;
    private WriteAccessRecord writeAccess;
    private WriteProtectRecord writeProtect;
    private FilePassRecord filePassRecord;
    private static POILogger log = POILogFactory.getLogger(class$com$fr$third$org$apache$poi$hssf$model$Workbook == null ? (class$com$fr$third$org$apache$poi$hssf$model$Workbook = Workbook.class$("com.fr.third.org.apache.poi.hssf.model.Workbook")) : class$com$fr$third$org$apache$poi$hssf$model$Workbook);
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$model$Workbook;

    public FilePassRecord getFilePassRecord() {
        return this.filePassRecord;
    }

    public void setFilePassword(String string) {
        if (this.filePassRecord == null) {
            this.filePassRecord = new FilePassRecord();
            this.filePassRecord.setPassword(string);
            this.records.add(1, this.filePassRecord);
        } else {
            this.filePassRecord.setPassword(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Workbook createWorkbook(List list) {
        Record record;
        int n;
        if (log.check(1)) {
            log.log(1, (Object)"Workbook (readfile) created with reclen=", new Integer(list.size()));
        }
        Workbook workbook = new Workbook();
        ArrayList<Record> arrayList = new ArrayList<Record>(list.size() / 3);
        workbook.records.setRecords(arrayList);
        block21: for (n = 0; n < list.size(); ++n) {
            record = (Record)list.get(n);
            if (record.getSid() == 10) {
                arrayList.add(record);
                if (!log.check(1)) break;
                log.log(1, "found workbook eof record at " + n);
                break;
            }
            switch (record.getSid()) {
                case 133: {
                    if (log.check(1)) {
                        log.log(1, "found boundsheet record at " + n);
                    }
                    workbook.boundsheets.add(record);
                    workbook.records.setBspos(n);
                    break;
                }
                case 252: {
                    if (log.check(1)) {
                        log.log(1, "found sst record at " + n);
                    }
                    workbook.sst = (SSTRecord)record;
                    break;
                }
                case 49: {
                    if (log.check(1)) {
                        log.log(1, "found font record at " + n);
                    }
                    workbook.records.setFontpos(n);
                    ++workbook.numfonts;
                    break;
                }
                case 224: {
                    if (log.check(1)) {
                        log.log(1, "found XF record at " + n);
                    }
                    workbook.records.setXfpos(n);
                    ++workbook.numxfs;
                    break;
                }
                case 317: {
                    if (log.check(1)) {
                        log.log(1, "found tabid record at " + n);
                    }
                    workbook.records.setTabpos(n);
                    break;
                }
                case 18: {
                    if (log.check(1)) {
                        log.log(1, "found protect record at " + n);
                    }
                    workbook.records.setProtpos(n);
                    break;
                }
                case 64: {
                    if (log.check(1)) {
                        log.log(1, "found backup record at " + n);
                    }
                    workbook.records.setBackuppos(n);
                    break;
                }
                case 23: {
                    throw new RuntimeException("Extern sheet is part of LinkTable");
                }
                case 24: 
                case 430: {
                    if (log.check(1)) {
                        log.log(1, "found SupBook record at " + n);
                    }
                    workbook.linkTable = new LinkTable(list, n, workbook.records);
                    n += workbook.linkTable.getRecordCount() - 1;
                    continue block21;
                }
                case 1054: {
                    if (log.check(1)) {
                        log.log(1, "found format record at " + n);
                    }
                    workbook.formats.add(record);
                    workbook.maxformatid = workbook.maxformatid >= ((FormatRecord)record).getIndexCode() ? workbook.maxformatid : ((FormatRecord)record).getIndexCode();
                    break;
                }
                case 34: {
                    if (log.check(1)) {
                        log.log(1, "found datewindow1904 record at " + n);
                    }
                    workbook.uses1904datewindowing = ((DateWindow1904Record)record).getWindowing() == 1;
                    break;
                }
                case 146: {
                    if (log.check(1)) {
                        log.log(1, "found palette record at " + n);
                    }
                    workbook.records.setPalettepos(n);
                    break;
                }
                case 61: {
                    if (log.check(1)) {
                        log.log(1, "found WindowOneRecord at " + n);
                    }
                    workbook.windowOne = (WindowOneRecord)record;
                    break;
                }
                case 92: {
                    if (log.check(1)) {
                        log.log(1, "found WriteAccess at " + n);
                    }
                    workbook.writeAccess = (WriteAccessRecord)record;
                    break;
                }
                case 134: {
                    if (log.check(1)) {
                        log.log(1, "found WriteProtect at " + n);
                    }
                    workbook.writeProtect = (WriteProtectRecord)record;
                    break;
                }
                case 91: {
                    if (log.check(1)) {
                        log.log(1, "found FileSharing at " + n);
                    }
                    workbook.fileShare = (FileSharingRecord)record;
                }
            }
            arrayList.add(record);
        }
        while (n < list.size()) {
            record = (Record)list.get(n);
            switch (record.getSid()) {
                case 440: {
                    workbook.hyperlinks.add(record);
                    break;
                }
            }
            ++n;
        }
        if (workbook.windowOne == null) {
            workbook.windowOne = (WindowOneRecord)workbook.createWindowOne();
        }
        if (log.check(1)) {
            log.log(1, "exit create workbook from existing file function");
        }
        return workbook;
    }

    public static Workbook createWorkbook() {
        int n;
        int n2;
        if (log.check(1)) {
            log.log(1, "creating new workbook from scratch");
        }
        Workbook workbook = new Workbook();
        ArrayList<Record> arrayList = new ArrayList<Record>(30);
        workbook.records.setRecords(arrayList);
        ArrayList<Record> arrayList2 = new ArrayList<Record>(8);
        arrayList.add(workbook.createBOF());
        arrayList.add(workbook.createInterfaceHdr());
        arrayList.add(workbook.createMMS());
        arrayList.add(workbook.createInterfaceEnd());
        arrayList.add(workbook.createWriteAccess());
        arrayList.add(workbook.createCodepage());
        arrayList.add(workbook.createDSF());
        arrayList.add(workbook.createTabId());
        workbook.records.setTabpos(arrayList.size() - 1);
        arrayList.add(workbook.createFnGroupCount());
        arrayList.add(workbook.createWindowProtect());
        arrayList.add(workbook.createProtect());
        workbook.records.setProtpos(arrayList.size() - 1);
        arrayList.add(workbook.createPassword());
        arrayList.add(workbook.createProtectionRev4());
        arrayList.add(workbook.createPasswordRev4());
        workbook.windowOne = (WindowOneRecord)workbook.createWindowOne();
        arrayList.add(workbook.windowOne);
        arrayList.add(workbook.createBackup());
        workbook.records.setBackuppos(arrayList.size() - 1);
        arrayList.add(workbook.createHideObj());
        arrayList.add(workbook.createDateWindow1904());
        arrayList.add(workbook.createPrecision());
        arrayList.add(workbook.createRefreshAll());
        arrayList.add(workbook.createBookBool());
        arrayList.add(workbook.createFont());
        arrayList.add(workbook.createFont());
        arrayList.add(workbook.createFont());
        arrayList.add(workbook.createFont());
        workbook.records.setFontpos(arrayList.size() - 1);
        workbook.numfonts = 4;
        for (n2 = 0; n2 <= 7; ++n2) {
            Record record = workbook.createFormat(n2);
            workbook.maxformatid = workbook.maxformatid >= ((FormatRecord)record).getIndexCode() ? workbook.maxformatid : ((FormatRecord)record).getIndexCode();
            arrayList2.add(record);
            arrayList.add(record);
        }
        workbook.formats = arrayList2;
        for (n2 = 0; n2 < 21; ++n2) {
            arrayList.add(workbook.createExtendedFormat(n2));
            ++workbook.numxfs;
        }
        workbook.records.setXfpos(arrayList.size() - 1);
        for (n2 = 0; n2 < 6; ++n2) {
            arrayList.add(workbook.createStyle(n2));
        }
        arrayList.add(workbook.createUseSelFS());
        n2 = 1;
        for (n = 0; n < n2; ++n) {
            BoundSheetRecord boundSheetRecord = (BoundSheetRecord)workbook.createBoundSheet(n);
            arrayList.add(boundSheetRecord);
            workbook.boundsheets.add(boundSheetRecord);
            workbook.records.setBspos(arrayList.size() - 1);
        }
        arrayList.add(workbook.createCountry());
        for (n = 0; n < n2; ++n) {
            workbook.getOrCreateLinkTable().checkExternSheet(n);
        }
        workbook.sst = (SSTRecord)workbook.createSST();
        arrayList.add(workbook.sst);
        arrayList.add(workbook.createExtendedSST());
        arrayList.add(workbook.createEOF());
        if (log.check(1)) {
            log.log(1, "exit create new workbook from scratch");
        }
        return workbook;
    }

    public NameRecord getSpecificBuiltinRecord(byte by, int n) {
        return this.getOrCreateLinkTable().getSpecificBuiltinRecord(by, n);
    }

    public void removeBuiltinRecord(byte by, int n) {
        this.linkTable.removeBuiltinRecord(by, n);
    }

    public int getNumRecords() {
        return this.records.size();
    }

    public FontRecord getFontRecordAt(int n) {
        int n2 = n;
        if (n2 > 4) {
            --n2;
        }
        if (n2 > this.numfonts - 1) {
            throw new ArrayIndexOutOfBoundsException("There are only " + this.numfonts + " font records, you asked for " + n);
        }
        FontRecord fontRecord = (FontRecord)this.records.get(this.records.getFontpos() - (this.numfonts - 1) + n2);
        return fontRecord;
    }

    public FontRecord createNewFont() {
        FontRecord fontRecord = (FontRecord)this.createFont();
        this.records.add(this.records.getFontpos() + 1, fontRecord);
        this.records.setFontpos(this.records.getFontpos() + 1);
        ++this.numfonts;
        return fontRecord;
    }

    public int getNumberOfFontRecords() {
        return this.numfonts;
    }

    public void setSheetBof(int n, int n2) {
        if (log.check(1)) {
            log.log(1, (Object)"setting bof for sheetnum =", (Object)new Integer(n), (Object)" at pos=", new Integer(n2));
        }
        this.checkSheets(n);
        ((BoundSheetRecord)this.boundsheets.get(n)).setPositionOfBof(n2);
    }

    public BackupRecord getBackupRecord() {
        return (BackupRecord)this.records.get(this.records.getBackuppos());
    }

    public void setSheetName(int n, String string) {
        this.checkSheets(n);
        BoundSheetRecord boundSheetRecord = (BoundSheetRecord)this.boundsheets.get(n);
        boundSheetRecord.setSheetname(string);
        boundSheetRecord.setSheetnameLength((byte)string.length());
    }

    public boolean doesContainsSheetName(String string, int n) {
        for (int i = 0; i < this.boundsheets.size(); ++i) {
            BoundSheetRecord boundSheetRecord = (BoundSheetRecord)this.boundsheets.get(i);
            if (n == i || !string.equalsIgnoreCase(boundSheetRecord.getSheetname())) continue;
            return true;
        }
        return false;
    }

    public void setSheetName(int n, String string, short s) {
        this.checkSheets(n);
        BoundSheetRecord boundSheetRecord = (BoundSheetRecord)this.boundsheets.get(n);
        boundSheetRecord.setSheetname(string);
        boundSheetRecord.setSheetnameLength((byte)string.length());
        boundSheetRecord.setCompressedUnicodeFlag((byte)s);
    }

    public void setSheetOrder(String string, int n) {
        int n2 = this.getSheetIndex(string);
        this.boundsheets.add(n, this.boundsheets.remove(n2));
    }

    public String getSheetName(int n) {
        return ((BoundSheetRecord)this.boundsheets.get(n)).getSheetname();
    }

    public boolean isSheetHidden(int n) {
        BoundSheetRecord boundSheetRecord = (BoundSheetRecord)this.boundsheets.get(n);
        return boundSheetRecord.isHidden();
    }

    public void setSheetHidden(int n, boolean bl) {
        BoundSheetRecord boundSheetRecord = (BoundSheetRecord)this.boundsheets.get(n);
        boundSheetRecord.setHidden(bl);
    }

    public int getSheetIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.boundsheets.size(); ++i) {
            String string2 = this.getSheetName(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    private void checkSheets(int n) {
        if (this.boundsheets.size() <= n) {
            if (this.boundsheets.size() + 1 <= n) {
                throw new RuntimeException("Sheet number out of bounds!");
            }
            BoundSheetRecord boundSheetRecord = (BoundSheetRecord)this.createBoundSheet(n);
            this.records.add(this.records.getBspos() + 1, boundSheetRecord);
            this.records.setBspos(this.records.getBspos() + 1);
            this.boundsheets.add(boundSheetRecord);
            this.getOrCreateLinkTable().checkExternSheet(n);
            this.fixTabIdRecord();
        }
    }

    public void removeSheet(int n) {
        if (this.boundsheets.size() > n) {
            this.records.remove(this.records.getBspos() - (this.boundsheets.size() - 1) + n);
            this.boundsheets.remove(n);
            this.fixTabIdRecord();
        }
        int n2 = n + 1;
        for (int i = 0; i < this.getNumNames(); ++i) {
            NameRecord nameRecord = this.getNameRecord(i);
            if (nameRecord.getIndexToSheet() == n2) {
                nameRecord.setEqualsToIndexToSheet((short)0);
                continue;
            }
            if (nameRecord.getIndexToSheet() <= n2) continue;
            nameRecord.setEqualsToIndexToSheet((short)(nameRecord.getEqualsToIndexToSheet() - 1));
        }
    }

    private void fixTabIdRecord() {
        TabIdRecord tabIdRecord = (TabIdRecord)this.records.get(this.records.getTabpos());
        short[] sArray = new short[this.boundsheets.size()];
        for (int n = 0; n < sArray.length; n = (int)((short)(n + 1))) {
            sArray[n] = n;
        }
        tabIdRecord.setTabIdArray(sArray);
    }

    public int getNumSheets() {
        if (log.check(1)) {
            log.log(1, (Object)"getNumSheets=", new Integer(this.boundsheets.size()));
        }
        return this.boundsheets.size();
    }

    public int getNumExFormats() {
        if (log.check(1)) {
            log.log(1, (Object)"getXF=", new Integer(this.numxfs));
        }
        return this.numxfs;
    }

    public ExtendedFormatRecord getExFormatAt(int n) {
        int n2 = this.records.getXfpos() - (this.numxfs - 1);
        ExtendedFormatRecord extendedFormatRecord = (ExtendedFormatRecord)this.records.get(n2 += n);
        return extendedFormatRecord;
    }

    public ExtendedFormatRecord createCellXF() {
        ExtendedFormatRecord extendedFormatRecord = this.createExtendedFormat();
        this.records.add(this.records.getXfpos() + 1, extendedFormatRecord);
        this.records.setXfpos(this.records.getXfpos() + 1);
        ++this.numxfs;
        return extendedFormatRecord;
    }

    public int addSSTString(UnicodeString unicodeString) {
        if (log.check(1)) {
            log.log(1, (Object)"insert to sst string='", unicodeString);
        }
        if (this.sst == null) {
            this.insertSST();
        }
        return this.sst.addString(unicodeString);
    }

    public UnicodeString getSSTString(int n) {
        if (this.sst == null) {
            this.insertSST();
        }
        UnicodeString unicodeString = this.sst.getString(n);
        if (log.check(1)) {
            log.log(1, (Object)"Returning SST for index=", (Object)new Integer(n), (Object)" String= ", unicodeString);
        }
        return unicodeString;
    }

    public void insertSST() {
        if (log.check(1)) {
            log.log(1, "creating new SST via insertSST!");
        }
        this.sst = (SSTRecord)this.createSST();
        this.records.add(this.records.size() - 1, this.createExtendedSST());
        this.records.add(this.records.size() - 2, this.sst);
    }

    public int serialize(int n, byte[] byArray) {
        if (log.check(1)) {
            log.log(1, "Serializing Workbook with offsets");
        }
        int n2 = 0;
        SSTRecord sSTRecord = null;
        int n3 = 0;
        boolean bl = false;
        for (int i = 0; i < this.records.size(); ++i) {
            Record record = this.records.get(i);
            if (record.getSid() == 449 && !((RecalcIdRecord)record).isNeeded()) continue;
            int n4 = 0;
            if (record instanceof SSTRecord) {
                sSTRecord = (SSTRecord)record;
                n3 = n2;
            }
            if (record.getSid() == 255 && sSTRecord != null) {
                record = sSTRecord.createExtSSTRecord(n3 + n);
            }
            if (record instanceof BoundSheetRecord) {
                if (!bl) {
                    for (int j = 0; j < this.boundsheets.size(); ++j) {
                        n4 += ((BoundSheetRecord)this.boundsheets.get(j)).serialize(n2 + n + n4, byArray);
                    }
                    bl = true;
                }
            } else {
                n4 = record.serialize(n2 + n, byArray);
            }
            n2 += n4;
        }
        if (log.check(1)) {
            log.log(1, "Exiting serialize workbook");
        }
        return n2;
    }

    public int getSize() {
        int n = 0;
        SSTRecord sSTRecord = null;
        for (int i = 0; i < this.records.size(); ++i) {
            Record record = this.records.get(i);
            if (record.getSid() == 449 && !((RecalcIdRecord)record).isNeeded()) continue;
            if (record instanceof SSTRecord) {
                sSTRecord = (SSTRecord)record;
            }
            if (record.getSid() == 255 && sSTRecord != null) {
                n += sSTRecord.calcExtSSTRecordSize();
                continue;
            }
            n += record.getRecordSize();
        }
        return n;
    }

    protected Record createBOF() {
        BOFRecord bOFRecord = new BOFRecord();
        bOFRecord.setVersion((short)1536);
        bOFRecord.setType((short)5);
        bOFRecord.setBuild((short)4307);
        bOFRecord.setBuildYear((short)1996);
        bOFRecord.setHistoryBitMask(65);
        bOFRecord.setRequiredVersion(6);
        return bOFRecord;
    }

    protected Record createInterfaceHdr() {
        InterfaceHdrRecord interfaceHdrRecord = new InterfaceHdrRecord();
        interfaceHdrRecord.setCodepage((short)1200);
        return interfaceHdrRecord;
    }

    protected Record createMMS() {
        MMSRecord mMSRecord = new MMSRecord();
        mMSRecord.setAddMenuCount((byte)0);
        mMSRecord.setDelMenuCount((byte)0);
        return mMSRecord;
    }

    protected Record createInterfaceEnd() {
        return new InterfaceEndRecord();
    }

    protected Record createWriteAccess() {
        WriteAccessRecord writeAccessRecord = new WriteAccessRecord();
        try {
            writeAccessRecord.setUsername(System.getProperty("user.name"));
        }
        catch (AccessControlException accessControlException) {
            writeAccessRecord.setUsername("POI");
        }
        return writeAccessRecord;
    }

    protected Record createCodepage() {
        CodepageRecord codepageRecord = new CodepageRecord();
        codepageRecord.setCodepage((short)1200);
        return codepageRecord;
    }

    protected Record createDSF() {
        DSFRecord dSFRecord = new DSFRecord();
        dSFRecord.setDsf((short)0);
        return dSFRecord;
    }

    protected Record createTabId() {
        TabIdRecord tabIdRecord = new TabIdRecord();
        short[] sArray = new short[]{0};
        tabIdRecord.setTabIdArray(sArray);
        return tabIdRecord;
    }

    protected Record createFnGroupCount() {
        FnGroupCountRecord fnGroupCountRecord = new FnGroupCountRecord();
        fnGroupCountRecord.setCount((short)14);
        return fnGroupCountRecord;
    }

    protected Record createWindowProtect() {
        WindowProtectRecord windowProtectRecord = new WindowProtectRecord();
        windowProtectRecord.setProtect(false);
        return windowProtectRecord;
    }

    protected Record createProtect() {
        ProtectRecord protectRecord = new ProtectRecord();
        protectRecord.setProtect(false);
        return protectRecord;
    }

    protected Record createPassword() {
        PasswordRecord passwordRecord = new PasswordRecord();
        passwordRecord.setPassword((short)0);
        return passwordRecord;
    }

    protected Record createProtectionRev4() {
        ProtectionRev4Record protectionRev4Record = new ProtectionRev4Record();
        protectionRev4Record.setProtect(false);
        return protectionRev4Record;
    }

    protected Record createPasswordRev4() {
        PasswordRev4Record passwordRev4Record = new PasswordRev4Record();
        passwordRev4Record.setPassword((short)0);
        return passwordRev4Record;
    }

    protected Record createWindowOne() {
        WindowOneRecord windowOneRecord = new WindowOneRecord();
        windowOneRecord.setHorizontalHold((short)360);
        windowOneRecord.setVerticalHold((short)270);
        windowOneRecord.setWidth((short)14940);
        windowOneRecord.setHeight((short)9150);
        windowOneRecord.setOptions((short)56);
        windowOneRecord.setSelectedTab((short)0);
        windowOneRecord.setDisplayedTab((short)0);
        windowOneRecord.setNumSelectedTabs((short)1);
        windowOneRecord.setTabWidthRatio((short)600);
        return windowOneRecord;
    }

    protected Record createBackup() {
        BackupRecord backupRecord = new BackupRecord();
        backupRecord.setBackup((short)0);
        return backupRecord;
    }

    protected Record createHideObj() {
        HideObjRecord hideObjRecord = new HideObjRecord();
        hideObjRecord.setHideObj((short)0);
        return hideObjRecord;
    }

    protected Record createDateWindow1904() {
        DateWindow1904Record dateWindow1904Record = new DateWindow1904Record();
        dateWindow1904Record.setWindowing((short)0);
        return dateWindow1904Record;
    }

    protected Record createPrecision() {
        PrecisionRecord precisionRecord = new PrecisionRecord();
        precisionRecord.setFullPrecision(true);
        return precisionRecord;
    }

    protected Record createRefreshAll() {
        RefreshAllRecord refreshAllRecord = new RefreshAllRecord();
        refreshAllRecord.setRefreshAll(false);
        return refreshAllRecord;
    }

    protected Record createBookBool() {
        BookBoolRecord bookBoolRecord = new BookBoolRecord();
        bookBoolRecord.setSaveLinkValues((short)0);
        return bookBoolRecord;
    }

    protected Record createFont() {
        FontRecord fontRecord = new FontRecord();
        fontRecord.setFontHeight((short)200);
        fontRecord.setAttributes((short)0);
        fontRecord.setColorPaletteIndex((short)Short.MAX_VALUE);
        fontRecord.setBoldWeight((short)400);
        fontRecord.setFontNameLength((byte)5);
        fontRecord.setFontName("Arial");
        return fontRecord;
    }

    protected Record createFormat(int n) {
        FormatRecord formatRecord = new FormatRecord();
        switch (n) {
            case 0: {
                formatRecord.setIndexCode((short)5);
                formatRecord.setFormatStringLength((byte)23);
                formatRecord.setFormatString("\"$\"#,##0_);\\(\"$\"#,##0\\)");
                break;
            }
            case 1: {
                formatRecord.setIndexCode((short)6);
                formatRecord.setFormatStringLength((byte)28);
                formatRecord.setFormatString("\"$\"#,##0_);[Red]\\(\"$\"#,##0\\)");
                break;
            }
            case 2: {
                formatRecord.setIndexCode((short)7);
                formatRecord.setFormatStringLength((byte)29);
                formatRecord.setFormatString("\"$\"#,##0.00_);\\(\"$\"#,##0.00\\)");
                break;
            }
            case 3: {
                formatRecord.setIndexCode((short)8);
                formatRecord.setFormatStringLength((byte)34);
                formatRecord.setFormatString("\"$\"#,##0.00_);[Red]\\(\"$\"#,##0.00\\)");
                break;
            }
            case 4: {
                formatRecord.setIndexCode((short)42);
                formatRecord.setFormatStringLength((byte)50);
                formatRecord.setFormatString("_(\"$\"* #,##0_);_(\"$\"* \\(#,##0\\);_(\"$\"* \"-\"_);_(@_)");
                break;
            }
            case 5: {
                formatRecord.setIndexCode((short)41);
                formatRecord.setFormatStringLength((byte)41);
                formatRecord.setFormatString("_(* #,##0_);_(* \\(#,##0\\);_(* \"-\"_);_(@_)");
                break;
            }
            case 6: {
                formatRecord.setIndexCode((short)44);
                formatRecord.setFormatStringLength((byte)58);
                formatRecord.setFormatString("_(\"$\"* #,##0.00_);_(\"$\"* \\(#,##0.00\\);_(\"$\"* \"-\"??_);_(@_)");
                break;
            }
            case 7: {
                formatRecord.setIndexCode((short)43);
                formatRecord.setFormatStringLength((byte)49);
                formatRecord.setFormatString("_(* #,##0.00_);_(* \\(#,##0.00\\);_(* \"-\"??_);_(@_)");
            }
        }
        return formatRecord;
    }

    protected Record createExtendedFormat(int n) {
        ExtendedFormatRecord extendedFormatRecord = new ExtendedFormatRecord();
        switch (n) {
            case 0: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)0);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 1: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 2: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 3: {
                extendedFormatRecord.setFontIndex((short)2);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 4: {
                extendedFormatRecord.setFontIndex((short)2);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 5: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 6: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 7: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 8: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 9: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 10: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 11: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 12: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 13: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 14: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-3072);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 15: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)0);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 16: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)43);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 17: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)41);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 18: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)44);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 19: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)42);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 20: {
                extendedFormatRecord.setFontIndex((short)1);
                extendedFormatRecord.setFormatIndex((short)9);
                extendedFormatRecord.setCellOptions((short)-11);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)-2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 21: {
                extendedFormatRecord.setFontIndex((short)5);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)2048);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 22: {
                extendedFormatRecord.setFontIndex((short)6);
                extendedFormatRecord.setFormatIndex((short)0);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)23552);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 23: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)49);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)23552);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 24: {
                extendedFormatRecord.setFontIndex((short)0);
                extendedFormatRecord.setFormatIndex((short)8);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)23552);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
                break;
            }
            case 25: {
                extendedFormatRecord.setFontIndex((short)6);
                extendedFormatRecord.setFormatIndex((short)8);
                extendedFormatRecord.setCellOptions((short)1);
                extendedFormatRecord.setAlignmentOptions((short)32);
                extendedFormatRecord.setIndentionOptions((short)23552);
                extendedFormatRecord.setBorderOptions((short)0);
                extendedFormatRecord.setPaletteOptions((short)0);
                extendedFormatRecord.setAdtlPaletteOptions((short)0);
                extendedFormatRecord.setFillPaletteOptions((short)8384);
            }
        }
        return extendedFormatRecord;
    }

    protected ExtendedFormatRecord createExtendedFormat() {
        ExtendedFormatRecord extendedFormatRecord = new ExtendedFormatRecord();
        extendedFormatRecord.setFontIndex((short)0);
        extendedFormatRecord.setFormatIndex((short)0);
        extendedFormatRecord.setCellOptions((short)1);
        extendedFormatRecord.setAlignmentOptions((short)32);
        extendedFormatRecord.setIndentionOptions((short)0);
        extendedFormatRecord.setBorderOptions((short)0);
        extendedFormatRecord.setPaletteOptions((short)0);
        extendedFormatRecord.setAdtlPaletteOptions((short)0);
        extendedFormatRecord.setFillPaletteOptions((short)8384);
        extendedFormatRecord.setTopBorderPaletteIdx((short)8);
        extendedFormatRecord.setBottomBorderPaletteIdx((short)8);
        extendedFormatRecord.setLeftBorderPaletteIdx((short)8);
        extendedFormatRecord.setRightBorderPaletteIdx((short)8);
        return extendedFormatRecord;
    }

    protected Record createStyle(int n) {
        StyleRecord styleRecord = new StyleRecord();
        switch (n) {
            case 0: {
                styleRecord.setIndex((short)-32752);
                styleRecord.setBuiltin((byte)3);
                styleRecord.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 1: {
                styleRecord.setIndex((short)-32751);
                styleRecord.setBuiltin((byte)6);
                styleRecord.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 2: {
                styleRecord.setIndex((short)-32750);
                styleRecord.setBuiltin((byte)4);
                styleRecord.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 3: {
                styleRecord.setIndex((short)-32749);
                styleRecord.setBuiltin((byte)7);
                styleRecord.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 4: {
                styleRecord.setIndex((short)Short.MIN_VALUE);
                styleRecord.setBuiltin((byte)0);
                styleRecord.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 5: {
                styleRecord.setIndex((short)-32748);
                styleRecord.setBuiltin((byte)5);
                styleRecord.setOutlineStyleLevel((byte)-1);
            }
        }
        return styleRecord;
    }

    protected PaletteRecord createPalette() {
        return new PaletteRecord();
    }

    protected Record createUseSelFS() {
        UseSelFSRecord useSelFSRecord = new UseSelFSRecord();
        useSelFSRecord.setFlag((short)0);
        return useSelFSRecord;
    }

    protected Record createBoundSheet(int n) {
        BoundSheetRecord boundSheetRecord = new BoundSheetRecord();
        switch (n) {
            case 0: {
                boundSheetRecord.setPositionOfBof(0);
                boundSheetRecord.setOptionFlags((short)0);
                boundSheetRecord.setSheetnameLength((byte)6);
                boundSheetRecord.setCompressedUnicodeFlag((byte)0);
                boundSheetRecord.setSheetname("Sheet1");
                break;
            }
            case 1: {
                boundSheetRecord.setPositionOfBof(0);
                boundSheetRecord.setOptionFlags((short)0);
                boundSheetRecord.setSheetnameLength((byte)6);
                boundSheetRecord.setCompressedUnicodeFlag((byte)0);
                boundSheetRecord.setSheetname("Sheet2");
                break;
            }
            case 2: {
                boundSheetRecord.setPositionOfBof(0);
                boundSheetRecord.setOptionFlags((short)0);
                boundSheetRecord.setSheetnameLength((byte)6);
                boundSheetRecord.setCompressedUnicodeFlag((byte)0);
                boundSheetRecord.setSheetname("Sheet3");
            }
        }
        return boundSheetRecord;
    }

    protected Record createCountry() {
        CountryRecord countryRecord = new CountryRecord();
        countryRecord.setDefaultCountry((short)1);
        if (Locale.getDefault().toString().equals("ru_RU")) {
            countryRecord.setCurrentCountry((short)7);
        } else {
            countryRecord.setCurrentCountry((short)1);
        }
        return countryRecord;
    }

    protected Record createSST() {
        return new SSTRecord();
    }

    protected Record createExtendedSST() {
        ExtSSTRecord extSSTRecord = new ExtSSTRecord();
        extSSTRecord.setNumStringsPerBucket((short)8);
        return extSSTRecord;
    }

    protected Record createEOF() {
        return new EOFRecord();
    }

    private LinkTable getOrCreateLinkTable() {
        if (this.linkTable == null) {
            this.linkTable = new LinkTable((short)this.getNumSheets(), this.records);
        }
        return this.linkTable;
    }

    public SheetReferences getSheetReferences() {
        SheetReferences sheetReferences = new SheetReferences();
        if (this.linkTable != null) {
            short s = this.linkTable.getNumberOfREFStructures();
            for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                String string = this.findSheetNameFromExternSheet(s2);
                sheetReferences.addSheetReference(string, s2);
            }
        }
        return sheetReferences;
    }

    public String findSheetNameFromExternSheet(short s) {
        String string = "";
        short s2 = this.linkTable.getIndexToSheet(s);
        if (s2 > -1) {
            string = this.getSheetName(s2);
        }
        return string;
    }

    public int getSheetIndexFromExternSheetIndex(int n) {
        return this.linkTable.getSheetIndexFromExternSheetIndex(n);
    }

    public short checkExternSheet(int n) {
        return this.getOrCreateLinkTable().checkExternSheet(n);
    }

    public int getNumNames() {
        if (this.linkTable == null) {
            return 0;
        }
        return this.linkTable.getNumNames();
    }

    public NameRecord getNameRecord(int n) {
        return this.linkTable.getNameRecord(n);
    }

    public NameRecord createName() {
        return this.addName(new NameRecord());
    }

    public NameRecord addName(NameRecord nameRecord) {
        this.getOrCreateLinkTable().addName(nameRecord);
        return nameRecord;
    }

    public NameRecord createBuiltInName(byte by, int n) {
        if (n == -1 || n + 1 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Index is not valid [" + n + "]");
        }
        NameRecord nameRecord = new NameRecord(by, (short)n);
        this.addName(nameRecord);
        return nameRecord;
    }

    public void removeName(int n) {
        if (this.linkTable.getNumNames() > n) {
            int n2 = this.findFirstRecordLocBySid((short)24);
            this.records.remove(n2 + n);
            this.linkTable.removeName(n);
        }
    }

    public short getFormat(String string, boolean bl) {
        Iterator iterator = this.formats.iterator();
        while (iterator.hasNext()) {
            FormatRecord formatRecord = (FormatRecord)iterator.next();
            if (!formatRecord.getFormatString().equals(string)) continue;
            return formatRecord.getIndexCode();
        }
        if (bl) {
            return this.createFormat(string);
        }
        return -1;
    }

    public ArrayList getFormats() {
        return this.formats;
    }

    public short createFormat(String string) {
        FormatRecord formatRecord = new FormatRecord();
        this.maxformatid = (short)(this.maxformatid >= 164 ? (int)(this.maxformatid + 1) : 164);
        formatRecord.setIndexCode(this.maxformatid);
        formatRecord.setFormatStringLength((byte)string.length());
        formatRecord.setFormatString(string);
        for (int i = 0; i < this.records.size() && this.records.get(i).getSid() != 1054; ++i) {
        }
        this.formats.add(formatRecord);
        this.records.add(i += this.formats.size(), formatRecord);
        return this.maxformatid;
    }

    public Record findFirstRecordBySid(short s) {
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() != s) continue;
            return record;
        }
        return null;
    }

    public int findFirstRecordLocBySid(short s) {
        int n = 0;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() == s) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Record findNextRecordBySid(short s, int n) {
        int n2 = 0;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() != s || n2++ != n) continue;
            return record;
        }
        return null;
    }

    public List getHyperlinks() {
        return this.hyperlinks;
    }

    public List getRecords() {
        return this.records.getRecords();
    }

    public boolean isUsing1904DateWindowing() {
        return this.uses1904datewindowing;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PaletteRecord getCustomPalette() {
        int n = this.records.getPalettepos();
        if (n != -1) {
            Record record = this.records.get(n);
            if (!(record instanceof PaletteRecord)) throw new RuntimeException("InternalError: Expected PaletteRecord but got a '" + record + "'");
            return (PaletteRecord)record;
        }
        PaletteRecord paletteRecord = this.createPalette();
        this.records.add(1, paletteRecord);
        this.records.setPalettepos(1);
        return paletteRecord;
    }

    public void findDrawingGroup() {
        EscherDggRecord escherDggRecord;
        Object object;
        Object object2;
        Record record;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            record = (Record)iterator.next();
            if (!(record instanceof DrawingGroupRecord)) continue;
            object2 = (DrawingGroupRecord)record;
            ((DrawingGroupRecord)object2).processChildRecords();
            object = ((AbstractEscherHolderRecord)object2).getEscherContainer();
            if (object == null) continue;
            escherDggRecord = null;
            Iterator iterator2 = ((EscherContainerRecord)object).getChildRecords().iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (!(e instanceof EscherDggRecord)) continue;
                escherDggRecord = (EscherDggRecord)e;
            }
            if (escherDggRecord == null) continue;
            this.drawingManager = new DrawingManager2(escherDggRecord);
            return;
        }
        int n = this.findFirstRecordLocBySid((short)235);
        if (n != -1) {
            record = (DrawingGroupRecord)this.records.get(n);
            object2 = null;
            object = ((AbstractEscherHolderRecord)record).getEscherRecords().iterator();
            while (object.hasNext()) {
                escherDggRecord = (EscherDggRecord)object.next();
                if (!(escherDggRecord instanceof EscherDggRecord)) continue;
                object2 = escherDggRecord;
            }
            if (object2 != null) {
                this.drawingManager = new DrawingManager2((EscherDggRecord)object2);
            }
        }
    }

    public void createDrawingGroup() {
        if (this.drawingManager == null) {
            Object object;
            EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
            EscherDggRecord escherDggRecord = new EscherDggRecord();
            EscherOptRecord escherOptRecord = new EscherOptRecord();
            EscherSplitMenuColorsRecord escherSplitMenuColorsRecord = new EscherSplitMenuColorsRecord();
            escherContainerRecord.setRecordId((short)-4096);
            escherContainerRecord.setOptions((short)15);
            escherDggRecord.setRecordId((short)-4090);
            escherDggRecord.setOptions((short)0);
            escherDggRecord.setShapeIdMax(1024);
            escherDggRecord.setNumShapesSaved(0);
            escherDggRecord.setDrawingsSaved(0);
            escherDggRecord.setFileIdClusters(new EscherDggRecord.FileIdCluster[0]);
            this.drawingManager = new DrawingManager2(escherDggRecord);
            EscherContainerRecord escherContainerRecord2 = null;
            if (this.escherBSERecords.size() > 0) {
                escherContainerRecord2 = new EscherContainerRecord();
                escherContainerRecord2.setRecordId((short)-4095);
                escherContainerRecord2.setOptions((short)(this.escherBSERecords.size() << 4 | 0xF));
                Iterator iterator = this.escherBSERecords.iterator();
                while (iterator.hasNext()) {
                    object = (EscherRecord)iterator.next();
                    escherContainerRecord2.addChildRecord((EscherRecord)object);
                }
            }
            escherOptRecord.setRecordId((short)-4085);
            escherOptRecord.setOptions((short)51);
            escherOptRecord.addEscherProperty(new EscherBoolProperty(191, 524296));
            escherOptRecord.addEscherProperty(new EscherRGBProperty(385, 134217793));
            escherOptRecord.addEscherProperty(new EscherRGBProperty(448, 0x8000040));
            escherSplitMenuColorsRecord.setRecordId((short)-3810);
            escherSplitMenuColorsRecord.setOptions((short)64);
            escherSplitMenuColorsRecord.setColor1(0x800000D);
            escherSplitMenuColorsRecord.setColor2(0x800000C);
            escherSplitMenuColorsRecord.setColor3(134217751);
            escherSplitMenuColorsRecord.setColor4(268435703);
            escherContainerRecord.addChildRecord(escherDggRecord);
            if (escherContainerRecord2 != null) {
                escherContainerRecord.addChildRecord(escherContainerRecord2);
            }
            escherContainerRecord.addChildRecord(escherOptRecord);
            escherContainerRecord.addChildRecord(escherSplitMenuColorsRecord);
            int n = this.findFirstRecordLocBySid((short)235);
            if (n == -1) {
                object = new DrawingGroupRecord();
                ((AbstractEscherHolderRecord)object).addEscherRecord(escherContainerRecord);
                int n2 = this.findFirstRecordLocBySid((short)140);
                this.getRecords().add(n2 + 1, object);
            } else {
                object = new DrawingGroupRecord();
                ((AbstractEscherHolderRecord)object).addEscherRecord(escherContainerRecord);
                this.getRecords().set(n, object);
            }
        }
    }

    public WindowOneRecord getWindowOne() {
        return this.windowOne;
    }

    public EscherBSERecord getBSERecord(int n) {
        return (EscherBSERecord)this.escherBSERecords.get(n - 1);
    }

    public int addBSERecord(EscherBSERecord escherBSERecord) {
        EscherContainerRecord escherContainerRecord;
        this.createDrawingGroup();
        this.escherBSERecords.add(escherBSERecord);
        int n = this.findFirstRecordLocBySid((short)235);
        DrawingGroupRecord drawingGroupRecord = (DrawingGroupRecord)this.getRecords().get(n);
        EscherContainerRecord escherContainerRecord2 = (EscherContainerRecord)drawingGroupRecord.getEscherRecord(0);
        if (escherContainerRecord2.getChild(1).getRecordId() == -4095) {
            escherContainerRecord = (EscherContainerRecord)escherContainerRecord2.getChild(1);
        } else {
            escherContainerRecord = new EscherContainerRecord();
            escherContainerRecord.setRecordId((short)-4095);
            escherContainerRecord2.getChildRecords().add(1, escherContainerRecord);
        }
        escherContainerRecord.setOptions((short)(this.escherBSERecords.size() << 4 | 0xF));
        escherContainerRecord.addChildRecord(escherBSERecord);
        return this.escherBSERecords.size();
    }

    public DrawingManager2 getDrawingManager() {
        return this.drawingManager;
    }

    public WriteProtectRecord getWriteProtect() {
        if (this.writeProtect == null) {
            this.writeProtect = new WriteProtectRecord();
            int n = 0;
            for (n = 0; n < this.records.size() && !(this.records.get(n) instanceof BOFRecord); ++n) {
            }
            this.records.add(n + 1, this.writeProtect);
        }
        return this.writeProtect;
    }

    public WriteAccessRecord getWriteAccess() {
        if (this.writeAccess == null) {
            this.writeAccess = (WriteAccessRecord)this.createWriteAccess();
            int n = 0;
            for (n = 0; n < this.records.size() && !(this.records.get(n) instanceof InterfaceEndRecord); ++n) {
            }
            this.records.add(n + 1, this.writeAccess);
        }
        return this.writeAccess;
    }

    public FileSharingRecord getFileSharing() {
        if (this.fileShare == null) {
            this.fileShare = new FileSharingRecord();
            int n = 0;
            for (n = 0; n < this.records.size() && !(this.records.get(n) instanceof WriteAccessRecord); ++n) {
            }
            this.records.add(n + 1, this.fileShare);
        }
        return this.fileShare;
    }

    public boolean isWriteProtected() {
        if (this.fileShare == null) {
            return false;
        }
        FileSharingRecord fileSharingRecord = this.getFileSharing();
        return fileSharingRecord.getReadOnly() == 1;
    }

    public void writeProtectWorkbook(String string, String string2) {
        int n = -1;
        FileSharingRecord fileSharingRecord = this.getFileSharing();
        WriteAccessRecord writeAccessRecord = this.getWriteAccess();
        WriteProtectRecord writeProtectRecord = this.getWriteProtect();
        fileSharingRecord.setReadOnly((short)1);
        fileSharingRecord.setPassword(FileSharingRecord.hashPassword(string));
        fileSharingRecord.setUsername(string2);
        writeAccessRecord.setUsername(string2);
    }

    public void unwriteProtectWorkbook() {
        this.records.remove(this.fileShare);
        this.records.remove(this.writeProtect);
        this.fileShare = null;
        this.writeProtect = null;
    }

    public String resolveNameXText(int n, int n2) {
        return this.linkTable.resolveNameXText(n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

