/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.model;

import com.fr.third.org.apache.poi.hssf.model.DrawingManager2;
import com.fr.third.org.apache.poi.hssf.model.FormulaParser;
import com.fr.third.org.apache.poi.hssf.model.Model;
import com.fr.third.org.apache.poi.hssf.record.BOFRecord;
import com.fr.third.org.apache.poi.hssf.record.BlankRecord;
import com.fr.third.org.apache.poi.hssf.record.BottomMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.CalcCountRecord;
import com.fr.third.org.apache.poi.hssf.record.CalcModeRecord;
import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.ColumnInfoRecord;
import com.fr.third.org.apache.poi.hssf.record.DBCellRecord;
import com.fr.third.org.apache.poi.hssf.record.DefaultColWidthRecord;
import com.fr.third.org.apache.poi.hssf.record.DefaultRowHeightRecord;
import com.fr.third.org.apache.poi.hssf.record.DeltaRecord;
import com.fr.third.org.apache.poi.hssf.record.DimensionsRecord;
import com.fr.third.org.apache.poi.hssf.record.DrawingRecord;
import com.fr.third.org.apache.poi.hssf.record.EOFRecord;
import com.fr.third.org.apache.poi.hssf.record.EscherAggregate;
import com.fr.third.org.apache.poi.hssf.record.FooterRecord;
import com.fr.third.org.apache.poi.hssf.record.FormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.GridsetRecord;
import com.fr.third.org.apache.poi.hssf.record.GutsRecord;
import com.fr.third.org.apache.poi.hssf.record.HCenterRecord;
import com.fr.third.org.apache.poi.hssf.record.HeaderRecord;
import com.fr.third.org.apache.poi.hssf.record.IndexRecord;
import com.fr.third.org.apache.poi.hssf.record.IterationRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.LeftMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.Margin;
import com.fr.third.org.apache.poi.hssf.record.MergeCellsRecord;
import com.fr.third.org.apache.poi.hssf.record.NumberRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjectProtectRecord;
import com.fr.third.org.apache.poi.hssf.record.PageBreakRecord;
import com.fr.third.org.apache.poi.hssf.record.PaneRecord;
import com.fr.third.org.apache.poi.hssf.record.PasswordRecord;
import com.fr.third.org.apache.poi.hssf.record.PrintGridlinesRecord;
import com.fr.third.org.apache.poi.hssf.record.PrintHeadersRecord;
import com.fr.third.org.apache.poi.hssf.record.PrintSetupRecord;
import com.fr.third.org.apache.poi.hssf.record.ProtectRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RefModeRecord;
import com.fr.third.org.apache.poi.hssf.record.RightMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.RowRecord;
import com.fr.third.org.apache.poi.hssf.record.SCLRecord;
import com.fr.third.org.apache.poi.hssf.record.SaveRecalcRecord;
import com.fr.third.org.apache.poi.hssf.record.ScenarioProtectRecord;
import com.fr.third.org.apache.poi.hssf.record.SelectionRecord;
import com.fr.third.org.apache.poi.hssf.record.TopMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.UncalcedRecord;
import com.fr.third.org.apache.poi.hssf.record.VCenterRecord;
import com.fr.third.org.apache.poi.hssf.record.WSBoolRecord;
import com.fr.third.org.apache.poi.hssf.record.WindowTwoRecord;
import com.fr.third.org.apache.poi.hssf.record.aggregates.CFRecordsAggregate;
import com.fr.third.org.apache.poi.hssf.record.aggregates.ColumnInfoRecordsAggregate;
import com.fr.third.org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import com.fr.third.org.apache.poi.hssf.record.aggregates.RowRecordsAggregate;
import com.fr.third.org.apache.poi.hssf.record.aggregates.ValueRecordsAggregate;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.util.PaneInformation;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Sheet
implements Model {
    public static final short LeftMargin = 0;
    public static final short RightMargin = 1;
    public static final short TopMargin = 2;
    public static final short BottomMargin = 3;
    private static POILogger log = POILogFactory.getLogger(class$com$fr$third$org$apache$poi$hssf$model$Sheet == null ? (class$com$fr$third$org$apache$poi$hssf$model$Sheet = Sheet.class$("com.fr.third.org.apache.poi.hssf.model.Sheet")) : class$com$fr$third$org$apache$poi$hssf$model$Sheet);
    protected ArrayList records = null;
    int preoffset = 0;
    int loc = 0;
    protected int dimsloc = -1;
    protected DimensionsRecord dims;
    protected DefaultColWidthRecord defaultcolwidth = null;
    protected DefaultRowHeightRecord defaultrowheight = null;
    protected GridsetRecord gridset = null;
    protected PrintSetupRecord printSetup = null;
    protected HeaderRecord header = null;
    protected FooterRecord footer = null;
    protected PrintGridlinesRecord printGridlines = null;
    protected WindowTwoRecord windowTwo = null;
    protected MergeCellsRecord merged = null;
    protected Margin[] margins = null;
    protected List mergedRecords = new ArrayList();
    protected int numMergedRegions = 0;
    protected SelectionRecord selection = null;
    protected ColumnInfoRecordsAggregate columns = null;
    protected ValueRecordsAggregate cells = null;
    protected RowRecordsAggregate rows = null;
    private Iterator valueRecIterator = null;
    private Iterator rowRecIterator = null;
    protected int eofLoc = 0;
    protected ProtectRecord protect = null;
    protected PageBreakRecord rowBreaks = null;
    protected PageBreakRecord colBreaks = null;
    protected ObjectProtectRecord objprotect = null;
    protected ScenarioProtectRecord scenprotect = null;
    protected PasswordRecord password = null;
    protected List condFormatting = new ArrayList();
    protected boolean _isUncalced = false;
    public static final byte PANE_LOWER_RIGHT = 0;
    public static final byte PANE_UPPER_RIGHT = 1;
    public static final byte PANE_LOWER_LEFT = 2;
    public static final byte PANE_UPPER_LEFT = 3;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$model$Sheet;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$aggregates$RowRecordsAggregate;

    public static Sheet createSheet(List list, int n, int n2) {
        if (log.check(1)) {
            log.logFormatted(1, "Sheet createSheet (existing file) with %", new Integer(list.size()));
        }
        Sheet sheet = new Sheet();
        ArrayList<Record> arrayList = new ArrayList<Record>(list.size() / 5);
        boolean bl = true;
        boolean bl2 = true;
        int n3 = 0;
        for (int i = n2; i < list.size(); ++i) {
            Record record;
            Record record2 = (Record)list.get(i);
            if (record2.getSid() == 2057) {
                ++n3;
                if (log.check(1)) {
                    log.log(1, "Hit BOF record. Nesting increased to " + n3);
                }
            } else if (record2.getSid() == 10) {
                --n3;
                if (log.check(1)) {
                    log.log(1, "Hit EOF record. Nesting decreased to " + n3);
                }
                if (n3 == 0) {
                    arrayList.add(record2);
                    sheet.eofLoc = i;
                    break;
                }
            } else if (record2.getSid() == 94) {
                sheet._isUncalced = true;
            } else if (record2.getSid() == 512) {
                if (sheet.columns == null) {
                    sheet.columns = new ColumnInfoRecordsAggregate();
                    arrayList.add(sheet.columns);
                }
                sheet.dims = (DimensionsRecord)record2;
                sheet.dimsloc = arrayList.size();
            } else if (record2.getSid() == 229) {
                sheet.mergedRecords.add(record2);
                sheet.merged = (MergeCellsRecord)record2;
                sheet.numMergedRegions += sheet.merged.getNumAreas();
            } else if (record2.getSid() == 432) {
                record = CFRecordsAggregate.createCFAggregate(list, i);
                sheet.condFormatting.add(record);
                record2 = record;
            } else if (record2.getSid() == 433) {
                record2 = null;
            } else if (record2.getSid() == 125) {
                record = (ColumnInfoRecord)record2;
                if (sheet.columns != null) {
                    record2 = null;
                } else {
                    sheet.columns = new ColumnInfoRecordsAggregate();
                    record2 = sheet.columns;
                }
                sheet.columns.insertColumn((ColumnInfoRecord)record);
            } else if (record2.getSid() == 85) {
                sheet.defaultcolwidth = (DefaultColWidthRecord)record2;
            } else if (record2.getSid() == 549) {
                sheet.defaultrowheight = (DefaultRowHeightRecord)record2;
            } else if (record2.isValue() && n3 == 1) {
                if (bl) {
                    sheet.cells = new ValueRecordsAggregate();
                    record2 = sheet.cells;
                    sheet.cells.construct(i, list);
                    bl = false;
                } else {
                    record2 = null;
                }
            } else if (record2.getSid() == 519) {
                record2 = null;
            } else if (record2.getSid() == 520) {
                record = (RowRecord)record2;
                if (!bl2) {
                    record2 = null;
                }
                if (bl2) {
                    sheet.rows = new RowRecordsAggregate();
                    record2 = sheet.rows;
                    bl2 = false;
                }
                sheet.rows.insertRow((RowRecord)record);
            } else if (record2.getSid() == 43) {
                sheet.printGridlines = (PrintGridlinesRecord)record2;
            } else if (record2.getSid() == 130) {
                sheet.gridset = (GridsetRecord)record2;
            } else if (record2.getSid() == 20 && n3 == 1) {
                sheet.header = (HeaderRecord)record2;
            } else if (record2.getSid() == 21 && n3 == 1) {
                sheet.footer = (FooterRecord)record2;
            } else if (record2.getSid() == 161 && n3 == 1) {
                sheet.printSetup = (PrintSetupRecord)record2;
            } else if (record2.getSid() == 38) {
                sheet.getMargins()[0] = (LeftMarginRecord)record2;
            } else if (record2.getSid() == 39) {
                sheet.getMargins()[1] = (RightMarginRecord)record2;
            } else if (record2.getSid() == 40) {
                sheet.getMargins()[2] = (TopMarginRecord)record2;
            } else if (record2.getSid() == 41) {
                sheet.getMargins()[3] = (BottomMarginRecord)record2;
            } else if (record2.getSid() == 29) {
                sheet.selection = (SelectionRecord)record2;
            } else if (record2.getSid() == 574) {
                sheet.windowTwo = (WindowTwoRecord)record2;
            } else if (record2.getSid() == 215) {
                record2 = null;
            } else if (record2.getSid() == 523) {
                record2 = null;
            } else if (record2.getSid() == 18) {
                sheet.protect = (ProtectRecord)record2;
            } else if (record2.getSid() == 99) {
                sheet.objprotect = (ObjectProtectRecord)record2;
            } else if (record2.getSid() == 221) {
                sheet.scenprotect = (ScenarioProtectRecord)record2;
            } else if (record2.getSid() == 19) {
                sheet.password = (PasswordRecord)record2;
            } else if (record2.getSid() == 27) {
                sheet.rowBreaks = (PageBreakRecord)record2;
            } else if (record2.getSid() == 26) {
                sheet.colBreaks = (PageBreakRecord)record2;
            }
            if (record2 == null) continue;
            arrayList.add(record2);
        }
        sheet.records = arrayList;
        sheet.checkRows();
        sheet.checkCells();
        if (log.check(1)) {
            log.log(1, "sheet createSheet (existing file) exited");
        }
        return sheet;
    }

    public Sheet cloneSheet() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.records.size());
        for (int i = 0; i < this.records.size(); ++i) {
            Record record;
            Object object;
            Record record2;
            Record record3 = (Record)((Record)this.records.get(i)).clone();
            if (record3 instanceof RowRecordsAggregate) {
                record2 = (RowRecordsAggregate)record3;
                object = ((RowRecordsAggregate)record2).getIterator();
                while (object.hasNext()) {
                    record = (Record)object.next();
                    arrayList.add(record);
                }
                continue;
            }
            if (record3 instanceof ValueRecordsAggregate) {
                record2 = (ValueRecordsAggregate)record3;
                object = ((ValueRecordsAggregate)record2).getIterator();
                while (object.hasNext()) {
                    record = (Record)object.next();
                    if (record instanceof FormulaRecordAggregate) {
                        FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)record;
                        Record record4 = formulaRecordAggregate.getFormulaRecord();
                        if (record4 != null) {
                            arrayList.add(record4);
                        }
                        if ((record4 = formulaRecordAggregate.getStringRecord()) == null) continue;
                        arrayList.add(record4);
                        continue;
                    }
                    arrayList.add(record);
                }
                continue;
            }
            if (record3 instanceof FormulaRecordAggregate) {
                record2 = (FormulaRecordAggregate)record3;
                object = ((FormulaRecordAggregate)record2).getFormulaRecord();
                if (object != null) {
                    arrayList.add(object);
                }
                if ((object = ((FormulaRecordAggregate)record2).getStringRecord()) == null) continue;
                arrayList.add(object);
                continue;
            }
            arrayList.add(record3);
        }
        return Sheet.createSheet(arrayList, 0, 0);
    }

    public static Sheet createSheet(List list, int n) {
        if (log.check(1)) {
            log.log(1, "Sheet createSheet (exisiting file) assumed offset 0");
        }
        return Sheet.createSheet(list, n, 0);
    }

    public static Sheet createSheet() {
        if (log.check(1)) {
            log.log(1, "Sheet createsheet from scratch called");
        }
        Sheet sheet = new Sheet();
        ArrayList<Record> arrayList = new ArrayList<Record>(30);
        arrayList.add(sheet.createBOF());
        arrayList.add(sheet.createCalcMode());
        arrayList.add(sheet.createCalcCount());
        arrayList.add(sheet.createRefMode());
        arrayList.add(sheet.createIteration());
        arrayList.add(sheet.createDelta());
        arrayList.add(sheet.createSaveRecalc());
        arrayList.add(sheet.createPrintHeaders());
        sheet.printGridlines = (PrintGridlinesRecord)sheet.createPrintGridlines();
        arrayList.add(sheet.printGridlines);
        sheet.gridset = (GridsetRecord)sheet.createGridset();
        arrayList.add(sheet.gridset);
        arrayList.add(sheet.createGuts());
        sheet.defaultrowheight = (DefaultRowHeightRecord)sheet.createDefaultRowHeight();
        arrayList.add(sheet.defaultrowheight);
        arrayList.add(sheet.createWSBool());
        sheet.rowBreaks = new PageBreakRecord(27);
        arrayList.add(sheet.rowBreaks);
        sheet.colBreaks = new PageBreakRecord(26);
        arrayList.add(sheet.colBreaks);
        sheet.header = (HeaderRecord)sheet.createHeader();
        arrayList.add(sheet.header);
        sheet.footer = (FooterRecord)sheet.createFooter();
        arrayList.add(sheet.footer);
        arrayList.add(sheet.createHCenter());
        arrayList.add(sheet.createVCenter());
        sheet.printSetup = (PrintSetupRecord)sheet.createPrintSetup();
        arrayList.add(sheet.printSetup);
        sheet.defaultcolwidth = (DefaultColWidthRecord)sheet.createDefaultColWidth();
        arrayList.add(sheet.defaultcolwidth);
        ColumnInfoRecordsAggregate columnInfoRecordsAggregate = new ColumnInfoRecordsAggregate();
        arrayList.add(columnInfoRecordsAggregate);
        sheet.columns = columnInfoRecordsAggregate;
        sheet.dims = (DimensionsRecord)sheet.createDimensions();
        arrayList.add(sheet.dims);
        sheet.dimsloc = arrayList.size() - 1;
        sheet.windowTwo = sheet.createWindowTwo();
        arrayList.add(sheet.windowTwo);
        sheet.setLoc(arrayList.size() - 1);
        sheet.selection = (SelectionRecord)sheet.createSelection();
        arrayList.add(sheet.selection);
        sheet.protect = (ProtectRecord)sheet.createProtect();
        arrayList.add(sheet.protect);
        arrayList.add(sheet.createEOF());
        sheet.records = arrayList;
        if (log.check(1)) {
            log.log(1, "Sheet createsheet from scratch exit");
        }
        return sheet;
    }

    private void checkCells() {
        if (this.cells == null) {
            this.cells = new ValueRecordsAggregate();
            int n = this.getDimsLoc() + 1;
            if (this.records.get(n).getClass() != (class$com$fr$third$org$apache$poi$hssf$record$aggregates$RowRecordsAggregate == null ? (class$com$fr$third$org$apache$poi$hssf$record$aggregates$RowRecordsAggregate = Sheet.class$("com.fr.third.org.apache.poi.hssf.record.aggregates.RowRecordsAggregate")) : class$com$fr$third$org$apache$poi$hssf$record$aggregates$RowRecordsAggregate)) {
                throw new IllegalStateException("Cannot create value records before row records exist");
            }
            this.records.add(n + 1, this.cells);
        }
    }

    private void checkRows() {
        if (this.rows == null) {
            this.rows = new RowRecordsAggregate();
            this.records.add(this.getDimsLoc() + 1, this.rows);
        }
    }

    public int addMergedRegion(int n, short s, int n2, short s2) {
        if (n2 < n) {
            throw new IllegalArgumentException("The 'to' row (" + n2 + ") must not be less than the 'from' row (" + n + ")");
        }
        if (s2 < s) {
            throw new IllegalArgumentException("The 'to' col (" + s2 + ") must not be less than the 'from' col (" + s + ")");
        }
        if (this.merged == null || this.merged.getNumAreas() == 1027) {
            this.merged = (MergeCellsRecord)this.createMergedCells();
            this.mergedRecords.add(this.merged);
            this.records.add(this.records.size() - 1, this.merged);
        }
        this.merged.addArea(n, s, n2, s2);
        return this.numMergedRegions++;
    }

    public void removeMergedRegion(int n) {
        if (n >= this.numMergedRegions || this.mergedRecords.size() == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (this.numMergedRegions - n < this.merged.getNumAreas()) {
            n2 = this.mergedRecords.size() - 1;
            n3 = this.numMergedRegions - this.merged.getNumAreas();
        } else {
            for (int i = 0; i < this.mergedRecords.size(); ++i) {
                MergeCellsRecord mergeCellsRecord = (MergeCellsRecord)this.mergedRecords.get(i);
                if (n3 + mergeCellsRecord.getNumAreas() > n) {
                    n2 = i;
                    break;
                }
                n3 += mergeCellsRecord.getNumAreas();
            }
        }
        MergeCellsRecord mergeCellsRecord = (MergeCellsRecord)this.mergedRecords.get(n2);
        mergeCellsRecord.removeAreaAt(n - n3);
        --this.numMergedRegions;
        if (mergeCellsRecord.getNumAreas() == 0) {
            this.mergedRecords.remove(n2);
            this.records.remove(this.merged);
            if (this.merged == mergeCellsRecord) {
                this.merged = this.mergedRecords.size() > 0 ? (MergeCellsRecord)this.mergedRecords.get(this.mergedRecords.size() - 1) : null;
            }
        }
    }

    public MergeCellsRecord.MergedRegion getMergedRegionAt(int n) {
        if (n >= this.numMergedRegions || this.mergedRecords.size() == 0) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        if (this.numMergedRegions - n < this.merged.getNumAreas()) {
            n2 = this.mergedRecords.size() - 1;
            n3 = this.numMergedRegions - this.merged.getNumAreas();
        } else {
            for (int i = 0; i < this.mergedRecords.size(); ++i) {
                MergeCellsRecord mergeCellsRecord = (MergeCellsRecord)this.mergedRecords.get(i);
                if (n3 + mergeCellsRecord.getNumAreas() > n) {
                    n2 = i;
                    break;
                }
                n3 += mergeCellsRecord.getNumAreas();
            }
        }
        return ((MergeCellsRecord)this.mergedRecords.get(n2)).getAreaAt(n - n3);
    }

    public int getNumMergedRegions() {
        return this.numMergedRegions;
    }

    private int findConditionalFormattingPosition() {
        int n;
        for (int i = n = this.records.size() - 2; i >= 0; --i) {
            Record record = (Record)this.records.get(i);
            short s = record.getSid();
            if (record instanceof CFRecordsAggregate) {
                return i + 1;
            }
            if (s == 239) {
                return i + 1;
            }
            if (s == 351) {
                return i + 1;
            }
            if (s == 229) {
                return i + 1;
            }
            if (s == 153) {
                return i + 1;
            }
            if (s == 29) {
                return i + 1;
            }
            if (s == 65) {
                return i + 1;
            }
            if (s == 160) {
                return i + 1;
            }
            if (s != 574) continue;
            return i + 1;
        }
        return n;
    }

    public int addConditionalFormatting(CFRecordsAggregate cFRecordsAggregate) {
        int n = this.findConditionalFormattingPosition();
        this.records.add(n, cFRecordsAggregate);
        this.condFormatting.add(cFRecordsAggregate);
        return this.condFormatting.size() - 1;
    }

    public void removeConditionalFormatting(int n) {
        if (n >= 0 && n <= this.condFormatting.size() - 1) {
            CFRecordsAggregate cFRecordsAggregate = this.getCFRecordsAggregateAt(n);
            this.records.remove(cFRecordsAggregate);
            this.condFormatting.remove(n);
        }
    }

    public CFRecordsAggregate getCFRecordsAggregateAt(int n) {
        if (n >= 0 && n <= this.condFormatting.size() - 1) {
            return (CFRecordsAggregate)this.condFormatting.get(n);
        }
        return null;
    }

    public int getNumConditionalFormattings() {
        return this.condFormatting.size();
    }

    public int getNumRecords() {
        this.checkCells();
        this.checkRows();
        if (log.check(1)) {
            log.log(1, "Sheet.getNumRecords");
            log.logFormatted(1, "returning % + % + % - 2 = %", new int[]{this.records.size(), this.cells.getPhysicalNumberOfCells(), this.rows.getPhysicalNumberOfRows(), this.records.size() + this.cells.getPhysicalNumberOfCells() + this.rows.getPhysicalNumberOfRows() - 2});
        }
        return this.records.size() + this.cells.getPhysicalNumberOfCells() + this.rows.getPhysicalNumberOfRows() - 2;
    }

    public void setDimensions(int n, short s, int n2, short s2) {
        if (log.check(1)) {
            log.log(1, "Sheet.setDimensions");
            log.log(1, "firstrow" + n + "firstcol" + s + "lastrow" + n2 + "lastcol" + s2);
        }
        this.dims.setFirstCol(s);
        this.dims.setFirstRow(n);
        this.dims.setLastCol(s2);
        this.dims.setLastRow(n2);
        if (log.check(1)) {
            log.log(1, "Sheet.setDimensions exiting");
        }
    }

    public void setLoc(int n) {
        this.valueRecIterator = null;
        if (log.check(1)) {
            log.log(1, "sheet.setLoc(): " + n);
        }
        this.loc = n;
    }

    public int getLoc() {
        if (log.check(1)) {
            log.log(1, "sheet.getLoc():" + this.loc);
        }
        return this.loc;
    }

    public void setPreOffset(int n) {
        this.preoffset = n;
    }

    public int getPreOffset() {
        return this.preoffset;
    }

    public int serialize(int n, byte[] byArray) {
        if (log.check(1)) {
            log.log(1, "Sheet.serialize using offsets");
        }
        int n2 = n;
        boolean bl = false;
        for (int i = 0; i < this.records.size(); ++i) {
            Record record = (Record)this.records.get(i);
            if (record instanceof UncalcedRecord) continue;
            if (record instanceof RowRecordsAggregate) {
                n2 += ((RowRecordsAggregate)record).serialize(n2, byArray, this.cells);
            } else if (!(record instanceof ValueRecordsAggregate)) {
                n2 += record.serialize(n2, byArray);
            }
            if (record.getSid() != 2057) continue;
            if (this._isUncalced) {
                UncalcedRecord uncalcedRecord = new UncalcedRecord();
                n2 += uncalcedRecord.serialize(n2, byArray);
            }
            if (this.rows == null || bl) continue;
            bl = true;
            n2 += this.serializeIndexRecord(i, n2, byArray);
        }
        if (log.check(1)) {
            log.log(1, "Sheet.serialize returning ");
        }
        return n2 - n;
    }

    private int serializeIndexRecord(int n, int n2, byte[] byArray) {
        int n3;
        IndexRecord indexRecord = new IndexRecord();
        indexRecord.setFirstRow(this.rows.getFirstRowNum());
        indexRecord.setLastRowAdd1(this.rows.getLastRowNum() + 1);
        int n4 = 0;
        for (n3 = n + 1; n3 < this.records.size(); ++n3) {
            Record record = (Record)this.records.get(n3);
            if (record instanceof UncalcedRecord) continue;
            if (record instanceof RowRecordsAggregate) break;
            n4 += record.getRecordSize();
        }
        if (this._isUncalced) {
            n4 += UncalcedRecord.getStaticRecordSize();
        }
        n3 = this.rows.getRowBlockCount();
        int n5 = IndexRecord.getRecordSizeForBlockCount(n3);
        int n6 = n2 + n5 + n4;
        for (int i = 0; i < n3; ++i) {
            n6 += this.rows.getRowBlockSize(i);
            indexRecord.addDbcell(n6 += null == this.cells ? 0 : this.cells.getRowCellBlockSize(this.rows.getStartRowNumberForBlock(i), this.rows.getEndRowNumberForBlock(i)));
            n6 += 8 + this.rows.getRowCountForBlock(i) * 2;
        }
        return indexRecord.serialize(n2, byArray);
    }

    public RowRecord createRow(int n) {
        return RowRecordsAggregate.createRow(n);
    }

    public LabelSSTRecord createLabelSST(int n, short s, int n2) {
        log.logFormatted(1, "create labelsst row,col,index %,%,%", new int[]{n, s, n2});
        LabelSSTRecord labelSSTRecord = new LabelSSTRecord();
        labelSSTRecord.setRow(n);
        labelSSTRecord.setColumn(s);
        labelSSTRecord.setSSTIndex(n2);
        labelSSTRecord.setXFIndex((short)15);
        return labelSSTRecord;
    }

    public NumberRecord createNumber(int n, short s, double d) {
        log.logFormatted(1, "create number row,col,value %,%,%", new double[]{n, s, d});
        NumberRecord numberRecord = new NumberRecord();
        numberRecord.setRow(n);
        numberRecord.setColumn(s);
        numberRecord.setValue(d);
        numberRecord.setXFIndex((short)15);
        return numberRecord;
    }

    public BlankRecord createBlank(int n, short s) {
        log.logFormatted(1, "create blank row,col %,%", new int[]{n, s});
        BlankRecord blankRecord = new BlankRecord();
        blankRecord.setRow(n);
        blankRecord.setColumn(s);
        blankRecord.setXFIndex((short)15);
        return blankRecord;
    }

    public FormulaRecord createFormula(int n, short s, String string) {
        log.logFormatted(1, "create formula row,col,formula %,%,%", new int[]{n, s}, string);
        FormulaRecord formulaRecord = new FormulaRecord();
        formulaRecord.setRow(n);
        formulaRecord.setColumn(s);
        formulaRecord.setOptions((short)2);
        formulaRecord.setValue(0.0);
        formulaRecord.setXFIndex((short)15);
        FormulaParser formulaParser = new FormulaParser(string, null);
        formulaParser.parse();
        Ptg[] ptgArray = formulaParser.getRPNPtg();
        int n2 = 0;
        for (int i = 0; i < ptgArray.length; ++i) {
            n2 += ptgArray[i].getSize();
            formulaRecord.pushExpressionToken(ptgArray[i]);
        }
        formulaRecord.setExpressionLength((short)n2);
        return formulaRecord;
    }

    public void addValueRecord(int n, CellValueRecordInterface cellValueRecordInterface) {
        this.checkCells();
        if (log.check(1)) {
            log.logFormatted(1, "add value record  row,loc %,%", new int[]{n, this.loc});
        }
        DimensionsRecord dimensionsRecord = (DimensionsRecord)this.records.get(this.getDimsLoc());
        if (cellValueRecordInterface.getColumn() > dimensionsRecord.getLastCol()) {
            dimensionsRecord.setLastCol((short)(cellValueRecordInterface.getColumn() + 1));
        }
        if (cellValueRecordInterface.getColumn() < dimensionsRecord.getFirstCol()) {
            dimensionsRecord.setFirstCol(cellValueRecordInterface.getColumn());
        }
        this.cells.insertCell(cellValueRecordInterface);
    }

    public void removeValueRecord(int n, CellValueRecordInterface cellValueRecordInterface) {
        this.checkCells();
        log.logFormatted(1, "remove value record row,dimsloc %,%", new int[]{n, this.dimsloc});
        this.loc = this.dimsloc;
        this.cells.removeCell(cellValueRecordInterface);
    }

    public void replaceValueRecord(CellValueRecordInterface cellValueRecordInterface) {
        this.checkCells();
        this.setLoc(this.dimsloc);
        if (log.check(1)) {
            log.log(1, "replaceValueRecord ");
        }
        this.cells.removeCell(cellValueRecordInterface);
        this.cells.insertCell(cellValueRecordInterface);
    }

    public void addRow(RowRecord rowRecord) {
        RowRecord rowRecord2;
        this.checkRows();
        if (log.check(1)) {
            log.log(1, "addRow ");
        }
        DimensionsRecord dimensionsRecord = (DimensionsRecord)this.records.get(this.getDimsLoc());
        if (rowRecord.getRowNumber() >= dimensionsRecord.getLastRow()) {
            dimensionsRecord.setLastRow(rowRecord.getRowNumber() + 1);
        }
        if (rowRecord.getRowNumber() < dimensionsRecord.getFirstRow()) {
            dimensionsRecord.setFirstRow(rowRecord.getRowNumber());
        }
        if ((rowRecord2 = this.rows.getRow(rowRecord.getRowNumber())) != null) {
            this.rows.removeRow(rowRecord2);
        }
        this.rows.insertRow(rowRecord);
        if (log.check(1)) {
            log.log(1, "exit addRow");
        }
    }

    public void removeRow(RowRecord rowRecord) {
        this.checkRows();
        this.setLoc(this.getDimsLoc());
        this.rows.removeRow(rowRecord);
    }

    public CellValueRecordInterface getNextValueRecord() {
        if (log.check(1)) {
            log.log(1, "getNextValue loc= " + this.loc);
        }
        if (this.valueRecIterator == null) {
            this.valueRecIterator = this.cells.getIterator();
        }
        if (!this.valueRecIterator.hasNext()) {
            return null;
        }
        return (CellValueRecordInterface)this.valueRecIterator.next();
    }

    public RowRecord getNextRow() {
        if (log.check(1)) {
            log.log(1, "getNextRow loc= " + this.loc);
        }
        if (this.rowRecIterator == null) {
            this.rowRecIterator = this.rows.getIterator();
        }
        if (!this.rowRecIterator.hasNext()) {
            return null;
        }
        return (RowRecord)this.rowRecIterator.next();
    }

    public RowRecord getRow(int n) {
        if (log.check(1)) {
            log.log(1, "getNextRow loc= " + this.loc);
        }
        return this.rows.getRow(n);
    }

    protected Record createBOF() {
        BOFRecord bOFRecord = new BOFRecord();
        bOFRecord.setVersion((short)1536);
        bOFRecord.setType((short)16);
        bOFRecord.setBuild((short)3515);
        bOFRecord.setBuildYear((short)1996);
        bOFRecord.setHistoryBitMask(193);
        bOFRecord.setRequiredVersion(6);
        return bOFRecord;
    }

    protected Record createIndex() {
        IndexRecord indexRecord = new IndexRecord();
        indexRecord.setFirstRow(0);
        indexRecord.setLastRowAdd1(0);
        return indexRecord;
    }

    protected Record createCalcMode() {
        CalcModeRecord calcModeRecord = new CalcModeRecord();
        calcModeRecord.setCalcMode((short)1);
        return calcModeRecord;
    }

    protected Record createCalcCount() {
        CalcCountRecord calcCountRecord = new CalcCountRecord();
        calcCountRecord.setIterations((short)100);
        return calcCountRecord;
    }

    protected Record createRefMode() {
        RefModeRecord refModeRecord = new RefModeRecord();
        refModeRecord.setMode((short)1);
        return refModeRecord;
    }

    protected Record createIteration() {
        IterationRecord iterationRecord = new IterationRecord();
        iterationRecord.setIteration(false);
        return iterationRecord;
    }

    protected Record createDelta() {
        DeltaRecord deltaRecord = new DeltaRecord();
        deltaRecord.setMaxChange(0.001);
        return deltaRecord;
    }

    protected Record createSaveRecalc() {
        SaveRecalcRecord saveRecalcRecord = new SaveRecalcRecord();
        saveRecalcRecord.setRecalc(true);
        return saveRecalcRecord;
    }

    protected Record createPrintHeaders() {
        PrintHeadersRecord printHeadersRecord = new PrintHeadersRecord();
        printHeadersRecord.setPrintHeaders(false);
        return printHeadersRecord;
    }

    protected Record createPrintGridlines() {
        PrintGridlinesRecord printGridlinesRecord = new PrintGridlinesRecord();
        printGridlinesRecord.setPrintGridlines(false);
        return printGridlinesRecord;
    }

    protected Record createGridset() {
        GridsetRecord gridsetRecord = new GridsetRecord();
        gridsetRecord.setGridset(true);
        return gridsetRecord;
    }

    protected Record createGuts() {
        GutsRecord gutsRecord = new GutsRecord();
        gutsRecord.setLeftRowGutter((short)0);
        gutsRecord.setTopColGutter((short)0);
        gutsRecord.setRowLevelMax((short)0);
        gutsRecord.setColLevelMax((short)0);
        return gutsRecord;
    }

    protected Record createDefaultRowHeight() {
        DefaultRowHeightRecord defaultRowHeightRecord = new DefaultRowHeightRecord();
        defaultRowHeightRecord.setOptionFlags((short)0);
        defaultRowHeightRecord.setRowHeight((short)255);
        return defaultRowHeightRecord;
    }

    protected Record createWSBool() {
        WSBoolRecord wSBoolRecord = new WSBoolRecord();
        wSBoolRecord.setWSBool1((byte)4);
        wSBoolRecord.setWSBool2((byte)-63);
        return wSBoolRecord;
    }

    protected Record createHeader() {
        HeaderRecord headerRecord = new HeaderRecord();
        headerRecord.setHeaderLength((byte)0);
        headerRecord.setHeader(null);
        return headerRecord;
    }

    protected Record createFooter() {
        FooterRecord footerRecord = new FooterRecord();
        footerRecord.setFooterLength((byte)0);
        footerRecord.setFooter(null);
        return footerRecord;
    }

    protected Record createHCenter() {
        HCenterRecord hCenterRecord = new HCenterRecord();
        hCenterRecord.setHCenter(false);
        return hCenterRecord;
    }

    protected Record createVCenter() {
        VCenterRecord vCenterRecord = new VCenterRecord();
        vCenterRecord.setVCenter(false);
        return vCenterRecord;
    }

    protected Record createPrintSetup() {
        PrintSetupRecord printSetupRecord = new PrintSetupRecord();
        printSetupRecord.setPaperSize((short)1);
        printSetupRecord.setScale((short)100);
        printSetupRecord.setPageStart((short)1);
        printSetupRecord.setFitWidth((short)1);
        printSetupRecord.setFitHeight((short)1);
        printSetupRecord.setOptions((short)2);
        printSetupRecord.setHResolution((short)300);
        printSetupRecord.setVResolution((short)300);
        printSetupRecord.setHeaderMargin(0.5);
        printSetupRecord.setFooterMargin(0.5);
        printSetupRecord.setCopies((short)0);
        return printSetupRecord;
    }

    protected Record createDefaultColWidth() {
        DefaultColWidthRecord defaultColWidthRecord = new DefaultColWidthRecord();
        defaultColWidthRecord.setColWidth((short)8);
        return defaultColWidthRecord;
    }

    protected Record createColInfo() {
        return ColumnInfoRecordsAggregate.createColInfo();
    }

    public short getDefaultColumnWidth() {
        return this.defaultcolwidth.getColWidth();
    }

    public boolean isGridsPrinted() {
        if (this.gridset == null) {
            this.gridset = (GridsetRecord)this.createGridset();
            int n = this.findFirstRecordLocBySid((short)10);
            this.records.add(n, this.gridset);
        }
        return !this.gridset.getGridset();
    }

    public void setGridsPrinted(boolean bl) {
        this.gridset.setGridset(!bl);
    }

    public void setDefaultColumnWidth(short s) {
        this.defaultcolwidth.setColWidth(s);
    }

    public void setDefaultRowHeight(short s) {
        this.defaultrowheight.setRowHeight(s);
    }

    public short getDefaultRowHeight() {
        return this.defaultrowheight.getRowHeight();
    }

    public short getColumnWidth(short s) {
        short s2 = 0;
        ColumnInfoRecord columnInfoRecord = null;
        if (this.columns != null) {
            int n = this.columns.getNumColumns();
            for (int i = 0; i < n && ((columnInfoRecord = this.columns.getColInfo(i)).getFirstColumn() > s || s > columnInfoRecord.getLastColumn()); ++i) {
                columnInfoRecord = null;
            }
        }
        s2 = columnInfoRecord != null ? columnInfoRecord.getColumnWidth() : (short)(256 * this.defaultcolwidth.getColWidth());
        return s2;
    }

    public short getXFIndexForColAt(short s) {
        short s2 = 0;
        ColumnInfoRecord columnInfoRecord = null;
        if (this.columns != null) {
            int n = this.columns.getNumColumns();
            for (int i = 0; i < n && ((columnInfoRecord = this.columns.getColInfo(i)).getFirstColumn() > s || s > columnInfoRecord.getLastColumn()); ++i) {
                columnInfoRecord = null;
            }
        }
        s2 = columnInfoRecord != null ? (short)columnInfoRecord.getXFIndex() : (short)15;
        return s2;
    }

    public void setColumnWidth(short s, short s2) {
        this.setColumn(s, new Short(s2), null, null, null);
    }

    public boolean isColumnHidden(short s) {
        boolean bl = false;
        ColumnInfoRecord columnInfoRecord = null;
        if (this.columns != null) {
            Iterator iterator = this.columns.getIterator();
            while (iterator.hasNext() && ((columnInfoRecord = (ColumnInfoRecord)iterator.next()).getFirstColumn() > s || s > columnInfoRecord.getLastColumn())) {
                columnInfoRecord = null;
            }
        }
        if (columnInfoRecord != null) {
            bl = columnInfoRecord.getHidden();
        }
        return bl;
    }

    public void setColumnHidden(short s, boolean bl) {
        this.setColumn(s, null, null, new Boolean(bl), null);
    }

    public void setColumn(short s, Short s2, Integer n, Boolean bl, Boolean bl2) {
        if (this.columns == null) {
            this.columns = new ColumnInfoRecordsAggregate();
        }
        this.columns.setColumn(s, null, s2, n, bl, bl2);
    }

    public void setColumn(short s, Short s2, Short s3, Integer n, Boolean bl, Boolean bl2) {
        if (this.columns == null) {
            this.columns = new ColumnInfoRecordsAggregate();
        }
        this.columns.setColumn(s, s2, s3, n, bl, bl2);
    }

    public void groupColumnRange(short s, short s2, boolean bl) {
        this.columns.groupColumnRange(s, s2, bl);
        int n = 0;
        int n2 = this.columns.getNumColumns();
        for (int i = 0; i < n2; ++i) {
            ColumnInfoRecord columnInfoRecord = this.columns.getColInfo(i);
            n = Math.max(columnInfoRecord.getOutlineLevel(), n);
        }
        GutsRecord gutsRecord = (GutsRecord)this.findFirstRecordBySid((short)128);
        gutsRecord.setColLevelMax((short)(n + 1));
        if (n == 0) {
            gutsRecord.setTopColGutter((short)0);
        } else {
            gutsRecord.setTopColGutter((short)(29 + 12 * (n - 1)));
        }
    }

    protected Record createDimensions() {
        DimensionsRecord dimensionsRecord = new DimensionsRecord();
        dimensionsRecord.setFirstCol((short)0);
        dimensionsRecord.setLastRow(1);
        dimensionsRecord.setFirstRow(0);
        dimensionsRecord.setLastCol((short)1);
        return dimensionsRecord;
    }

    protected WindowTwoRecord createWindowTwo() {
        WindowTwoRecord windowTwoRecord = new WindowTwoRecord();
        windowTwoRecord.setOptions((short)1718);
        windowTwoRecord.setTopRow((short)0);
        windowTwoRecord.setLeftCol((short)0);
        windowTwoRecord.setHeaderColor(64);
        windowTwoRecord.setPageBreakZoom((short)0);
        windowTwoRecord.setNormalZoom((short)0);
        return windowTwoRecord;
    }

    protected Record createSelection() {
        SelectionRecord selectionRecord = new SelectionRecord();
        selectionRecord.setPane((byte)3);
        selectionRecord.setActiveCellCol((short)0);
        selectionRecord.setActiveCellRow(0);
        selectionRecord.setNumRefs((short)0);
        return selectionRecord;
    }

    public short getTopRow() {
        return this.windowTwo == null ? (short)0 : this.windowTwo.getTopRow();
    }

    public void setTopRow(short s) {
        if (this.windowTwo != null) {
            this.windowTwo.setTopRow(s);
        }
    }

    public void setLeftCol(short s) {
        if (this.windowTwo != null) {
            this.windowTwo.setLeftCol(s);
        }
    }

    public short getLeftCol() {
        return this.windowTwo == null ? (short)0 : this.windowTwo.getLeftCol();
    }

    public int getActiveCellRow() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getActiveCellRow();
    }

    public void setActiveCellRow(int n) {
        if (this.selection != null) {
            this.selection.setActiveCellRow(n);
        }
    }

    public short getActiveCellCol() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getActiveCellCol();
    }

    public void setActiveCellCol(short s) {
        if (this.selection != null) {
            this.selection.setActiveCellCol(s);
        }
    }

    protected Record createMergedCells() {
        MergeCellsRecord mergeCellsRecord = new MergeCellsRecord();
        mergeCellsRecord.setNumAreas((short)0);
        return mergeCellsRecord;
    }

    protected Record createEOF() {
        return new EOFRecord();
    }

    public int getDimsLoc() {
        if (log.check(1)) {
            log.log(1, "getDimsLoc dimsloc= " + this.dimsloc);
        }
        return this.dimsloc;
    }

    public void checkDimsLoc(Record record, int n) {
        if (record.getSid() == 512) {
            this.loc = n;
            this.dimsloc = n;
        }
    }

    public int getSize() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.records.size(); ++n) {
            Record record = (Record)this.records.get(n);
            if (record instanceof UncalcedRecord) continue;
            n2 += record.getRecordSize();
        }
        if (this.rows != null) {
            n = this.rows.getRowBlockCount();
            int n3 = 0;
            if (this.cells != null) {
                Iterator iterator = this.rows.getIterator();
                while (iterator.hasNext()) {
                    RowRecord rowRecord = (RowRecord)iterator.next();
                    if (!this.cells.rowHasCells(rowRecord.getRowNumber())) continue;
                    ++n3;
                }
            }
            n2 += IndexRecord.getRecordSizeForBlockCount(n);
            n2 += DBCellRecord.calculateSizeOfRecords(n, n3);
        }
        if (this._isUncalced) {
            n2 += UncalcedRecord.getStaticRecordSize();
        }
        return n2;
    }

    public List getRecords() {
        return this.records;
    }

    public GridsetRecord getGridsetRecord() {
        return this.gridset;
    }

    public Record findFirstRecordBySid(short s) {
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() != s) continue;
            return record;
        }
        return null;
    }

    public void setSCLRecord(SCLRecord sCLRecord) {
        int n = this.findFirstRecordLocBySid((short)160);
        if (n == -1) {
            int n2 = this.findFirstRecordLocBySid((short)574);
            this.records.add(n2 + 1, sCLRecord);
        } else {
            this.records.set(n, sCLRecord);
        }
    }

    public int findFirstRecordLocBySid(short s) {
        int n = 0;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() == s) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public HeaderRecord getHeader() {
        return this.header;
    }

    public WindowTwoRecord getWindowTwo() {
        return this.windowTwo;
    }

    public void setHeader(HeaderRecord headerRecord) {
        this.header = headerRecord;
    }

    public FooterRecord getFooter() {
        return this.footer;
    }

    public void setFooter(FooterRecord footerRecord) {
        this.footer = footerRecord;
    }

    public PrintSetupRecord getPrintSetup() {
        return this.printSetup;
    }

    public void setPrintSetup(PrintSetupRecord printSetupRecord) {
        this.printSetup = printSetupRecord;
    }

    public PrintGridlinesRecord getPrintGridlines() {
        return this.printGridlines;
    }

    public void setPrintGridlines(PrintGridlinesRecord printGridlinesRecord) {
        this.printGridlines = printGridlinesRecord;
    }

    public void setSelected(boolean bl) {
        this.windowTwo.setSelected(bl);
    }

    public double getMargin(short s) {
        if (this.getMargins()[s] != null) {
            return this.margins[s].getMargin();
        }
        switch (s) {
            case 0: {
                return 0.75;
            }
            case 1: {
                return 0.75;
            }
            case 2: {
                return 1.0;
            }
            case 3: {
                return 1.0;
            }
        }
        throw new RuntimeException("Unknown margin constant:  " + s);
    }

    public void setMargin(short s, double d) {
        Margin margin = this.getMargins()[s];
        if (margin == null) {
            switch (s) {
                case 0: {
                    margin = new LeftMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, margin);
                    break;
                }
                case 1: {
                    margin = new RightMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, margin);
                    break;
                }
                case 2: {
                    margin = new TopMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, margin);
                    break;
                }
                case 3: {
                    margin = new BottomMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, margin);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown margin constant:  " + s);
                }
            }
            this.margins[s] = margin;
        }
        margin.setMargin(d);
    }

    public int getEofLoc() {
        return this.eofLoc;
    }

    public void createFreezePane(int n, int n2, int n3, int n4) {
        int n5 = this.findFirstRecordLocBySid((short)65);
        if (n5 != -1) {
            this.records.remove(n5);
        }
        int n6 = this.findFirstRecordLocBySid((short)574);
        PaneRecord paneRecord = new PaneRecord();
        paneRecord.setX((short)n);
        paneRecord.setY((short)n2);
        paneRecord.setTopRow((short)n3);
        paneRecord.setLeftColumn((short)n4);
        if (n2 == 0) {
            paneRecord.setTopRow((short)0);
            paneRecord.setActivePane((short)1);
        } else if (n == 0) {
            paneRecord.setLeftColumn((short)64);
            paneRecord.setActivePane((short)2);
        } else {
            paneRecord.setActivePane((short)0);
        }
        this.records.add(n6 + 1, paneRecord);
        this.windowTwo.setFreezePanes(true);
        this.windowTwo.setFreezePanesNoSplit(true);
        SelectionRecord selectionRecord = (SelectionRecord)this.findFirstRecordBySid((short)29);
        selectionRecord.setPane((byte)paneRecord.getActivePane());
    }

    public void createSplitPane(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.findFirstRecordLocBySid((short)65);
        if (n6 != -1) {
            this.records.remove(n6);
        }
        int n7 = this.findFirstRecordLocBySid((short)574);
        PaneRecord paneRecord = new PaneRecord();
        paneRecord.setX((short)n);
        paneRecord.setY((short)n2);
        paneRecord.setTopRow((short)n3);
        paneRecord.setLeftColumn((short)n4);
        paneRecord.setActivePane((short)n5);
        this.records.add(n7 + 1, paneRecord);
        this.windowTwo.setFreezePanes(false);
        this.windowTwo.setFreezePanesNoSplit(false);
        SelectionRecord selectionRecord = (SelectionRecord)this.findFirstRecordBySid((short)29);
        selectionRecord.setPane((byte)0);
    }

    public PaneInformation getPaneInformation() {
        PaneRecord paneRecord = (PaneRecord)this.findFirstRecordBySid((short)65);
        if (paneRecord == null) {
            return null;
        }
        return new PaneInformation(paneRecord.getX(), paneRecord.getY(), paneRecord.getTopRow(), paneRecord.getLeftColumn(), (byte)paneRecord.getActivePane(), this.windowTwo.getFreezePanes());
    }

    public SelectionRecord getSelection() {
        return this.selection;
    }

    public void setSelection(SelectionRecord selectionRecord) {
        this.selection = selectionRecord;
    }

    protected Record createProtect() {
        if (log.check(1)) {
            log.log(1, "create protect record with protection disabled");
        }
        ProtectRecord protectRecord = new ProtectRecord();
        protectRecord.setProtect(false);
        return protectRecord;
    }

    protected ObjectProtectRecord createObjectProtect() {
        if (log.check(1)) {
            log.log(1, "create protect record with protection disabled");
        }
        ObjectProtectRecord objectProtectRecord = new ObjectProtectRecord();
        objectProtectRecord.setProtect(false);
        return objectProtectRecord;
    }

    protected ScenarioProtectRecord createScenarioProtect() {
        if (log.check(1)) {
            log.log(1, "create protect record with protection disabled");
        }
        ScenarioProtectRecord scenarioProtectRecord = new ScenarioProtectRecord();
        scenarioProtectRecord.setProtect(false);
        return scenarioProtectRecord;
    }

    public ProtectRecord getProtect() {
        if (this.protect == null) {
            this.protect = (ProtectRecord)this.createProtect();
            int n = this.findFirstRecordLocBySid((short)10);
            this.records.add(n, this.protect);
        }
        return this.protect;
    }

    public PasswordRecord getPassword() {
        if (this.password == null) {
            this.password = this.createPassword();
            int n = this.findFirstRecordLocBySid((short)10);
            this.records.add(n, this.password);
        }
        return this.password;
    }

    protected PasswordRecord createPassword() {
        if (log.check(1)) {
            log.log(1, "create password record with 00 password");
        }
        PasswordRecord passwordRecord = new PasswordRecord();
        passwordRecord.setPassword((short)0);
        return passwordRecord;
    }

    public void setDisplayGridlines(boolean bl) {
        this.windowTwo.setDisplayGridlines(bl);
    }

    public boolean isDisplayGridlines() {
        return this.windowTwo.getDisplayGridlines();
    }

    public void setDisplayFormulas(boolean bl) {
        this.windowTwo.setDisplayFormulas(bl);
    }

    public boolean isDisplayFormulas() {
        return this.windowTwo.getDisplayFormulas();
    }

    public void setDisplayRowColHeadings(boolean bl) {
        this.windowTwo.setDisplayRowColHeadings(bl);
    }

    public boolean isDisplayRowColHeadings() {
        return this.windowTwo.getDisplayRowColHeadings();
    }

    public boolean getUncalced() {
        return this._isUncalced;
    }

    public void setUncalced(boolean bl) {
        this._isUncalced = bl;
    }

    protected Margin[] getMargins() {
        if (this.margins == null) {
            this.margins = new Margin[4];
        }
        return this.margins;
    }

    public int aggregateDrawingRecords(DrawingManager2 drawingManager2, boolean bl) {
        boolean bl2;
        int n = this.findFirstRecordLocBySid((short)236);
        boolean bl3 = bl2 = n == -1;
        if (bl2) {
            if (!bl) {
                return -1;
            }
            EscherAggregate escherAggregate = new EscherAggregate(drawingManager2);
            n = this.findFirstRecordLocBySid((short)9876);
            if (n == -1) {
                n = this.findFirstRecordLocBySid((short)574);
            } else {
                this.getRecords().remove(n);
            }
            this.getRecords().add(n, escherAggregate);
            return n;
        }
        List list = this.getRecords();
        EscherAggregate escherAggregate = EscherAggregate.createAggregate(list, n, drawingManager2);
        int n2 = n;
        while (n + 1 < list.size() && list.get(n) instanceof DrawingRecord && list.get(n + 1) instanceof ObjRecord) {
            n += 2;
        }
        int n3 = n - 1;
        for (int i = 0; i < n3 - n2 + 1; ++i) {
            list.remove(n2);
        }
        list.add(n2, escherAggregate);
        return n2;
    }

    public void preSerialize() {
        Iterator iterator = this.getRecords().iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (!(record instanceof EscherAggregate)) continue;
            record.getRecordSize();
        }
    }

    public void shiftBreaks(PageBreakRecord pageBreakRecord, short s, short s2, int n) {
        PageBreakRecord.Break break_;
        if (this.rowBreaks == null) {
            return;
        }
        Iterator iterator = pageBreakRecord.getBreaksIterator();
        ArrayList<PageBreakRecord.Break> arrayList = new ArrayList<PageBreakRecord.Break>();
        while (iterator.hasNext()) {
            boolean bl;
            break_ = (PageBreakRecord.Break)iterator.next();
            short s3 = break_.main;
            boolean bl2 = s3 >= s;
            boolean bl3 = bl = s3 <= s2;
            if (!bl2 || !bl) continue;
            arrayList.add(break_);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            break_ = (PageBreakRecord.Break)iterator.next();
            pageBreakRecord.removeBreak(break_.main);
            pageBreakRecord.addBreak((short)(break_.main + n), break_.subFrom, break_.subTo);
        }
    }

    public void setRowBreak(int n, short s, short s2) {
        if (this.rowBreaks == null) {
            int n2 = this.findFirstRecordLocBySid((short)574);
            this.rowBreaks = new PageBreakRecord(27);
            this.records.add(n2, this.rowBreaks);
        }
        this.rowBreaks.addBreak((short)n, s, s2);
    }

    public void removeRowBreak(int n) {
        if (this.rowBreaks == null) {
            throw new IllegalArgumentException("Sheet does not define any row breaks");
        }
        this.rowBreaks.removeBreak((short)n);
    }

    public boolean isRowBroken(int n) {
        return this.rowBreaks == null ? false : this.rowBreaks.getBreak((short)n) != null;
    }

    public void setColumnBreak(short s, short s2, short s3) {
        if (this.colBreaks == null) {
            int n = this.findFirstRecordLocBySid((short)574);
            this.colBreaks = new PageBreakRecord(26);
            this.records.add(n, this.colBreaks);
        }
        this.colBreaks.addBreak(s, s2, s3);
    }

    public void removeColumnBreak(short s) {
        if (this.colBreaks == null) {
            throw new IllegalArgumentException("Sheet does not define any column breaks");
        }
        this.colBreaks.removeBreak(s);
    }

    public boolean isColumnBroken(short s) {
        return this.colBreaks == null ? false : this.colBreaks.getBreak(s) != null;
    }

    public void shiftRowBreaks(int n, int n2, int n3) {
        this.shiftBreaks(this.rowBreaks, (short)n, (short)n2, (short)n3);
    }

    public void shiftColumnBreaks(short s, short s2, short s3) {
        this.shiftBreaks(this.colBreaks, s, s2, s3);
    }

    public Iterator getRowBreaks() {
        return this.rowBreaks.getBreaksIterator();
    }

    public int getNumRowBreaks() {
        return this.rowBreaks == null ? 0 : (int)this.rowBreaks.getNumBreaks();
    }

    public Iterator getColumnBreaks() {
        return this.colBreaks.getBreaksIterator();
    }

    public int getNumColumnBreaks() {
        return this.colBreaks == null ? 0 : (int)this.colBreaks.getNumBreaks();
    }

    public void setColumnGroupCollapsed(short s, boolean bl) {
        if (bl) {
            this.columns.collapseColumn(s);
        } else {
            this.columns.expandColumn(s);
        }
    }

    public void protectSheet(String string, boolean bl, boolean bl2) {
        Record record;
        int n = -1;
        ProtectRecord protectRecord = this.getProtect();
        PasswordRecord passwordRecord = this.getPassword();
        protectRecord.setProtect(true);
        passwordRecord.setPassword(PasswordRecord.hashPassword(string));
        if (this.objprotect == null && bl || this.scenprotect != null && bl2) {
            n = this.records.indexOf(this.protect);
        }
        if (this.objprotect == null && bl) {
            record = this.createObjectProtect();
            ((ObjectProtectRecord)record).setProtect(true);
            this.records.add(n + 1, record);
            this.objprotect = record;
        }
        if (this.scenprotect == null && bl2) {
            record = this.createScenarioProtect();
            ((ScenarioProtectRecord)record).setProtect(true);
            this.records.add(n + 2, record);
            this.scenprotect = record;
        }
    }

    public void unprotectSheet(boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            ProtectRecord protectRecord = this.getProtect();
            protectRecord.setProtect(bl);
            PasswordRecord passwordRecord = this.getPassword();
            passwordRecord.setPassword((short)0);
        }
        if (this.objprotect != null && !bl2) {
            this.objprotect.setProtect(false);
        }
        if (this.scenprotect != null && !bl3) {
            this.scenprotect.setProtect(false);
        }
    }

    public boolean[] isProtected() {
        return new boolean[]{this.protect != null && this.protect.getProtect(), this.objprotect != null && this.objprotect.getProtect(), this.scenprotect != null && this.scenprotect.getProtect()};
    }

    public void groupRowRange(int n, int n2, boolean bl) {
        this.checkRows();
        for (int i = n; i <= n2; ++i) {
            RowRecord rowRecord = this.getRow(i);
            if (rowRecord == null) {
                rowRecord = this.createRow(i);
                this.addRow(rowRecord);
            }
            int n3 = rowRecord.getOutlineLevel();
            n3 = bl ? ++n3 : --n3;
            n3 = Math.max(0, n3);
            n3 = Math.min(7, n3);
            rowRecord.setOutlineLevel((short)n3);
        }
        this.recalcRowGutter();
    }

    private void recalcRowGutter() {
        Record record;
        int n = 0;
        Iterator iterator = this.rows.getIterator();
        while (iterator.hasNext()) {
            record = (RowRecord)iterator.next();
            n = Math.max(((RowRecord)record).getOutlineLevel(), n);
        }
        record = (GutsRecord)this.findFirstRecordBySid((short)128);
        if (record == null) {
            record = new GutsRecord();
            this.records.add(record);
        }
        ((GutsRecord)record).setRowLevelMax((short)(n + 1));
        ((GutsRecord)record).setLeftRowGutter((short)(29 + 12 * n));
    }

    public void setRowGroupCollapsed(int n, boolean bl) {
        if (bl) {
            this.rows.collapseRow(n);
        } else {
            this.rows.expandRow(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

