/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.model;

import com.fr.third.org.apache.poi.ddf.EscherClientDataRecord;
import com.fr.third.org.apache.poi.ddf.EscherContainerRecord;
import com.fr.third.org.apache.poi.ddf.EscherOptRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherSimpleProperty;
import com.fr.third.org.apache.poi.ddf.EscherSpRecord;
import com.fr.third.org.apache.poi.hssf.model.AbstractShape;
import com.fr.third.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import com.fr.third.org.apache.poi.hssf.record.EndSubRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPicture;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShape;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSimpleShape;

public class PictureShape
extends AbstractShape {
    private EscherContainerRecord spContainer;
    private ObjRecord objRecord;

    PictureShape(HSSFSimpleShape hSSFSimpleShape, int n) {
        this.spContainer = this.createSpContainer(hSSFSimpleShape, n);
        this.objRecord = this.createObjRecord(hSSFSimpleShape, n);
    }

    private EscherContainerRecord createSpContainer(HSSFSimpleShape hSSFSimpleShape, int n) {
        HSSFPicture hSSFPicture = (HSSFPicture)hSSFSimpleShape;
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        EscherSpRecord escherSpRecord = new EscherSpRecord();
        EscherOptRecord escherOptRecord = new EscherOptRecord();
        EscherClientDataRecord escherClientDataRecord = new EscherClientDataRecord();
        escherContainerRecord.setRecordId((short)-4092);
        escherContainerRecord.setOptions((short)15);
        escherSpRecord.setRecordId((short)-4086);
        escherSpRecord.setOptions((short)1202);
        escherSpRecord.setShapeId(n);
        escherSpRecord.setFlags(2560);
        escherOptRecord.setRecordId((short)-4085);
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(260, false, true, hSSFPicture.getPictureIndex()));
        this.addStandardOptions(hSSFPicture, escherOptRecord);
        HSSFAnchor hSSFAnchor = hSSFPicture.getAnchor();
        if (hSSFAnchor.isHorizontallyFlipped()) {
            escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x40);
        }
        if (hSSFAnchor.isVerticallyFlipped()) {
            escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x80);
        }
        EscherRecord escherRecord = this.createAnchor(hSSFAnchor);
        escherClientDataRecord.setRecordId((short)-4079);
        escherClientDataRecord.setOptions((short)0);
        escherContainerRecord.addChildRecord(escherSpRecord);
        escherContainerRecord.addChildRecord(escherOptRecord);
        escherContainerRecord.addChildRecord(escherRecord);
        escherContainerRecord.addChildRecord(escherClientDataRecord);
        return escherContainerRecord;
    }

    private ObjRecord createObjRecord(HSSFShape hSSFShape, int n) {
        HSSFShape hSSFShape2 = hSSFShape;
        ObjRecord objRecord = new ObjRecord();
        CommonObjectDataSubRecord commonObjectDataSubRecord = new CommonObjectDataSubRecord();
        commonObjectDataSubRecord.setObjectType((short)((HSSFSimpleShape)hSSFShape2).getShapeType());
        commonObjectDataSubRecord.setObjectId((short)n);
        commonObjectDataSubRecord.setLocked(true);
        commonObjectDataSubRecord.setPrintable(true);
        commonObjectDataSubRecord.setAutofill(true);
        commonObjectDataSubRecord.setAutoline(true);
        commonObjectDataSubRecord.setReserved2(0);
        EndSubRecord endSubRecord = new EndSubRecord();
        objRecord.addSubRecord(commonObjectDataSubRecord);
        objRecord.addSubRecord(endSubRecord);
        return objRecord;
    }

    public EscherContainerRecord getSpContainer() {
        return this.spContainer;
    }

    public ObjRecord getObjRecord() {
        return this.objRecord;
    }
}

