/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.model;

import com.fr.third.org.apache.poi.hssf.model.ParseNode;
import com.fr.third.org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ControlPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.record.formula.ValueOperatorPtg;

final class OperandClassTransformer {
    private final int _formulaType;

    public OperandClassTransformer(int n) {
        this._formulaType = n;
    }

    public void transformFormula(ParseNode parseNode) {
        byte by;
        switch (this._formulaType) {
            case 0: {
                by = 32;
                break;
            }
            default: {
                throw new RuntimeException("Incomplete code - formula type (" + this._formulaType + ") not supported yet");
            }
        }
        this.transformNode(parseNode, by, false);
    }

    private void transformNode(ParseNode parseNode, byte by, boolean bl) {
        block10: {
            Ptg ptg;
            block9: {
                ptg = parseNode.getToken();
                ParseNode[] parseNodeArray = parseNode.getChildren();
                if (ptg instanceof ValueOperatorPtg || ptg instanceof ControlPtg) {
                    for (int i = 0; i < parseNodeArray.length; ++i) {
                        ParseNode parseNode2 = parseNodeArray[i];
                        this.transformNode(parseNode2, by, bl);
                    }
                    return;
                }
                if (ptg instanceof AbstractFunctionPtg) {
                    this.transformFunctionNode((AbstractFunctionPtg)ptg, parseNodeArray, by, bl);
                    return;
                }
                if (parseNodeArray.length > 0) {
                    throw new IllegalStateException("Node should not have any children");
                }
                if (ptg.isBaseToken()) {
                    return;
                }
                if (!bl) break block9;
                switch (by) {
                    case 32: 
                    case 64: {
                        ptg.setClass((byte)64);
                        break block10;
                    }
                    case 0: {
                        ptg.setClass((byte)0);
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + by + ")");
                    }
                }
            }
            ptg.setClass(by);
        }
    }

    private void transformFunctionNode(AbstractFunctionPtg abstractFunctionPtg, ParseNode[] parseNodeArray, byte by, boolean bl) {
        boolean bl2;
        block24: {
            byte by2;
            block23: {
                by2 = abstractFunctionPtg.getDefaultOperandClass();
                if (!bl) break block23;
                switch (by2) {
                    case 0: {
                        if (by == 0) {
                            abstractFunctionPtg.setClass((byte)0);
                        } else {
                            abstractFunctionPtg.setClass((byte)64);
                        }
                        bl2 = false;
                        break block24;
                    }
                    case 64: {
                        abstractFunctionPtg.setClass((byte)64);
                        bl2 = false;
                        break block24;
                    }
                    case 32: {
                        abstractFunctionPtg.setClass((byte)64);
                        bl2 = true;
                        break block24;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + by2 + ")");
                    }
                }
            }
            if (by2 == by) {
                bl2 = false;
                abstractFunctionPtg.setClass(by2);
            } else {
                switch (by) {
                    case 32: {
                        abstractFunctionPtg.setClass((byte)32);
                        bl2 = false;
                        break;
                    }
                    case 64: {
                        switch (by2) {
                            case 0: {
                                abstractFunctionPtg.setClass((byte)0);
                                break;
                            }
                            case 32: {
                                abstractFunctionPtg.setClass((byte)64);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected operand class (" + by2 + ")");
                            }
                        }
                        bl2 = by2 == 32;
                        break;
                    }
                    case 0: {
                        switch (by2) {
                            case 64: {
                                abstractFunctionPtg.setClass((byte)64);
                                break;
                            }
                            case 32: {
                                abstractFunctionPtg.setClass((byte)32);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected operand class (" + by2 + ")");
                            }
                        }
                        bl2 = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + by + ")");
                    }
                }
            }
        }
        for (int i = 0; i < parseNodeArray.length; ++i) {
            ParseNode parseNode = parseNodeArray[i];
            byte by3 = abstractFunctionPtg.getParameterClass(i);
            this.transformNode(parseNode, by3, bl2);
        }
    }
}

