/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.model;

import com.fr.third.org.apache.poi.hssf.model.RecordStream;
import com.fr.third.org.apache.poi.hssf.model.WorkbookRecordList;
import com.fr.third.org.apache.poi.hssf.record.CRNCountRecord;
import com.fr.third.org.apache.poi.hssf.record.CRNRecord;
import com.fr.third.org.apache.poi.hssf.record.ExternSheetRecord;
import com.fr.third.org.apache.poi.hssf.record.ExternSheetSubRecord;
import com.fr.third.org.apache.poi.hssf.record.ExternalNameRecord;
import com.fr.third.org.apache.poi.hssf.record.NameRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.SupBookRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class LinkTable {
    private final ExternalBookBlock[] _externalBookBlocks;
    private final ExternSheetRecord _externSheetRecord;
    private final List _definedNames;
    private final int _recordCount;
    private final WorkbookRecordList _workbookRecordList;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$ExternalNameRecord;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$CRNCountRecord;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$SupBookRecord;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$NameRecord;

    public LinkTable(List list, int n, WorkbookRecordList workbookRecordList) {
        Record record;
        this._workbookRecordList = workbookRecordList;
        RecordStream recordStream = new RecordStream(list, n);
        ArrayList<ExternalBookBlock> arrayList = new ArrayList<ExternalBookBlock>();
        while (recordStream.peekNextClass() == (class$com$fr$third$org$apache$poi$hssf$record$SupBookRecord == null ? LinkTable.class$("com.fr.third.org.apache.poi.hssf.record.SupBookRecord") : class$com$fr$third$org$apache$poi$hssf$record$SupBookRecord)) {
            arrayList.add(new ExternalBookBlock(recordStream));
        }
        this._externalBookBlocks = new ExternalBookBlock[arrayList.size()];
        arrayList.toArray(this._externalBookBlocks);
        arrayList.clear();
        if (this._externalBookBlocks.length > 0) {
            record = recordStream.getNext();
            this._externSheetRecord = (ExternSheetRecord)record;
        } else {
            this._externSheetRecord = null;
        }
        this._definedNames = new ArrayList();
        while (recordStream.peekNextClass() == (class$com$fr$third$org$apache$poi$hssf$record$NameRecord == null ? LinkTable.class$("com.fr.third.org.apache.poi.hssf.record.NameRecord") : class$com$fr$third$org$apache$poi$hssf$record$NameRecord)) {
            record = (NameRecord)recordStream.getNext();
            this._definedNames.add(record);
        }
        this._recordCount = recordStream.getCountRead();
        this._workbookRecordList.getRecords().addAll(list.subList(n, n + this._recordCount));
    }

    public LinkTable(short s, WorkbookRecordList workbookRecordList) {
        this._workbookRecordList = workbookRecordList;
        this._definedNames = new ArrayList();
        this._externalBookBlocks = new ExternalBookBlock[]{new ExternalBookBlock(s)};
        this._externSheetRecord = new ExternSheetRecord();
        this._recordCount = 2;
        SupBookRecord supBookRecord = this._externalBookBlocks[0].getExternalBookRecord();
        int n = this.findFirstRecordLocBySid((short)140);
        if (n < 0) {
            throw new RuntimeException("CountryRecord not found");
        }
        this._workbookRecordList.add(n + 1, this._externSheetRecord);
        this._workbookRecordList.add(n + 1, supBookRecord);
    }

    public int getRecordCount() {
        return this._recordCount;
    }

    public NameRecord getSpecificBuiltinRecord(byte by, int n) {
        Iterator iterator = this._definedNames.iterator();
        while (iterator.hasNext()) {
            NameRecord nameRecord = (NameRecord)iterator.next();
            if (nameRecord.getBuiltInName() != by || nameRecord.getIndexToSheet() != n) continue;
            return nameRecord;
        }
        return null;
    }

    public void removeBuiltinRecord(byte by, int n) {
        NameRecord nameRecord = this.getSpecificBuiltinRecord(by, n);
        if (nameRecord != null) {
            this._definedNames.remove(nameRecord);
        }
    }

    public int getNumNames() {
        return this._definedNames.size();
    }

    public NameRecord getNameRecord(int n) {
        return (NameRecord)this._definedNames.get(n);
    }

    public void addName(NameRecord nameRecord) {
        this._definedNames.add(nameRecord);
        int n = this.findFirstRecordLocBySid((short)23);
        if (n == -1) {
            n = this.findFirstRecordLocBySid((short)430);
        }
        if (n == -1) {
            n = this.findFirstRecordLocBySid((short)140);
        }
        int n2 = this._definedNames.size();
        this._workbookRecordList.add(n + n2, nameRecord);
    }

    public void removeName(int n) {
        this._definedNames.remove(n);
    }

    public short getIndexToSheet(short s) {
        return this._externSheetRecord.getREFRecordAt(s).getIndexToFirstSupBook();
    }

    public int getSheetIndexFromExternSheetIndex(int n) {
        if (n >= this._externSheetRecord.getNumOfREFStructures()) {
            return -1;
        }
        return this._externSheetRecord.getREFRecordAt(n).getIndexToFirstSupBook();
    }

    public short addSheetIndexToExternSheet(short s) {
        ExternSheetSubRecord externSheetSubRecord = new ExternSheetSubRecord();
        externSheetSubRecord.setIndexToFirstSupBook(s);
        externSheetSubRecord.setIndexToLastSupBook(s);
        this._externSheetRecord.addREFRecord(externSheetSubRecord);
        this._externSheetRecord.setNumOfREFStructures((short)(this._externSheetRecord.getNumOfREFStructures() + 1));
        return (short)(this._externSheetRecord.getNumOfREFStructures() - 1);
    }

    public short checkExternSheet(int n) {
        short s = this._externSheetRecord.getNumOfREFStructures();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            ExternSheetSubRecord externSheetSubRecord = this._externSheetRecord.getREFRecordAt(s2);
            if (externSheetSubRecord.getIndexToFirstSupBook() != n || externSheetSubRecord.getIndexToLastSupBook() != n) continue;
            return s2;
        }
        return this.addSheetIndexToExternSheet((short)n);
    }

    private int findFirstRecordLocBySid(short s) {
        int n = 0;
        Iterator iterator = this._workbookRecordList.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() == s) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getNumberOfREFStructures() {
        return this._externSheetRecord.getNumOfREFStructures();
    }

    public String resolveNameXText(int n, int n2) {
        short s = this._externSheetRecord.getREFRecordAt(n).getIndexToSupBook();
        return this._externalBookBlocks[s].getNameText(n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ExternalBookBlock {
        private final SupBookRecord _externalBookRecord;
        private final ExternalNameRecord[] _externalNameRecords;
        private final CRNBlock[] _crnBlocks;

        public ExternalBookBlock(RecordStream recordStream) {
            this._externalBookRecord = (SupBookRecord)recordStream.getNext();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (recordStream.peekNextClass() == (class$com$fr$third$org$apache$poi$hssf$record$ExternalNameRecord == null ? LinkTable.class$("com.fr.third.org.apache.poi.hssf.record.ExternalNameRecord") : class$com$fr$third$org$apache$poi$hssf$record$ExternalNameRecord)) {
                arrayList.add(recordStream.getNext());
            }
            this._externalNameRecords = new ExternalNameRecord[arrayList.size()];
            arrayList.toArray(this._externalNameRecords);
            arrayList.clear();
            while (recordStream.peekNextClass() == (class$com$fr$third$org$apache$poi$hssf$record$CRNCountRecord == null ? LinkTable.class$("com.fr.third.org.apache.poi.hssf.record.CRNCountRecord") : class$com$fr$third$org$apache$poi$hssf$record$CRNCountRecord)) {
                arrayList.add(new CRNBlock(recordStream));
            }
            this._crnBlocks = new CRNBlock[arrayList.size()];
            arrayList.toArray(this._crnBlocks);
        }

        public ExternalBookBlock(short s) {
            this._externalBookRecord = SupBookRecord.createInternalReferences(s);
            this._externalNameRecords = new ExternalNameRecord[0];
            this._crnBlocks = new CRNBlock[0];
        }

        public SupBookRecord getExternalBookRecord() {
            return this._externalBookRecord;
        }

        public String getNameText(int n) {
            return this._externalNameRecords[n].getText();
        }
    }

    private static final class CRNBlock {
        private final CRNCountRecord _countRecord;
        private final CRNRecord[] _crns;

        public CRNBlock(RecordStream recordStream) {
            this._countRecord = (CRNCountRecord)recordStream.getNext();
            int n = this._countRecord.getNumberOfCRNs();
            CRNRecord[] cRNRecordArray = new CRNRecord[n];
            for (int i = 0; i < cRNRecordArray.length; ++i) {
                cRNRecordArray[i] = (CRNRecord)recordStream.getNext();
            }
            this._crns = cRNRecordArray;
        }

        public CRNRecord[] getCrns() {
            return (CRNRecord[])this._crns.clone();
        }
    }
}

