/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.model;

import com.fr.third.org.apache.poi.hssf.model.OperandClassTransformer;
import com.fr.third.org.apache.poi.hssf.model.ParseNode;
import com.fr.third.org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.AddPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Area3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.AttrPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.BoolPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ConcatPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.DividePtg;
import com.fr.third.org.apache.poi.hssf.record.formula.EqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ErrPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.FuncPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.FuncVarPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.GreaterThanPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.IntPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.LessEqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.LessThanPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MemAreaPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MemErrPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MemFuncPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MissingArgPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MultiplyPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NamePtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NotEqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NumberPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.OperationPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ParenthesisPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.PercentPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.PowerPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ref3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.RefPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.StringPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.SubtractPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ValueOperatorPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;

public final class FormulaParser {
    public static final int FORMULA_TYPE_CELL = 0;
    public static final int FORMULA_TYPE_SHARED = 1;
    public static final int FORMULA_TYPE_ARRAY = 2;
    public static final int FORMULA_TYPE_CONDFOMRAT = 3;
    public static final int FORMULA_TYPE_NAMEDRANGE = 4;
    private final String formulaString;
    private final int formulaLength;
    private int pointer;
    private ParseNode _rootNode;
    private static final Pattern CELL_REFERENCE_PATTERN = Pattern.compile("(?:('?)[^:\\\\/\\?\\*\\[\\]]+\\1!)?\\$?[A-Za-z]+\\$?[\\d]+");
    private static char TAB = (char)9;
    private char look;
    private HSSFWorkbook book;

    public FormulaParser(String string, HSSFWorkbook hSSFWorkbook) {
        this.formulaString = string;
        this.pointer = 0;
        this.book = hSSFWorkbook;
        this.formulaLength = this.formulaString.length();
    }

    public static Ptg[] parse(String string, HSSFWorkbook hSSFWorkbook) {
        FormulaParser formulaParser = new FormulaParser(string, hSSFWorkbook);
        formulaParser.parse();
        return formulaParser.getRPNPtg();
    }

    private void GetChar() {
        if (this.pointer > this.formulaLength) {
            throw new RuntimeException("too far");
        }
        this.look = this.pointer < this.formulaLength ? this.formulaString.charAt(this.pointer) : (char)'\u0000';
        ++this.pointer;
    }

    private RuntimeException expected(String string) {
        String string2 = "Parse error near char " + (this.pointer - 1) + " '" + this.look + "'" + " in specified formula '" + this.formulaString + "'. Expected " + string;
        return new FormulaParseException(string2);
    }

    private boolean IsAlpha(char c) {
        return Character.isLetter(c) || c == '$' || c == '_';
    }

    private boolean IsDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean IsAlNum(char c) {
        return this.IsAlpha(c) || this.IsDigit(c);
    }

    private boolean IsWhite(char c) {
        return c == ' ' || c == TAB;
    }

    private void SkipWhite() {
        while (this.IsWhite(this.look)) {
            this.GetChar();
        }
    }

    private void Match(char c) {
        if (this.look != c) {
            throw this.expected("'" + c + "'");
        }
        this.GetChar();
    }

    private String GetName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.IsAlpha(this.look) && this.look != '\'') {
            throw this.expected("Name");
        }
        if (this.look == '\'') {
            boolean bl;
            this.Match('\'');
            boolean bl2 = bl = this.look == '\'';
            while (!bl) {
                stringBuffer.append(this.look);
                this.GetChar();
                if (this.look != '\'') continue;
                this.Match('\'');
                bl = this.look != '\'';
            }
        } else {
            while (this.IsAlNum(this.look)) {
                stringBuffer.append(this.look);
                this.GetChar();
            }
        }
        return stringBuffer.toString();
    }

    private String GetNum() {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.IsDigit(this.look)) {
            stringBuffer.append(this.look);
            this.GetChar();
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    private ParseNode parseFunctionOrIdentifier() {
        String string = this.GetName();
        if (this.look == '(') {
            return this.function(string);
        }
        return new ParseNode(this.parseIdentifier(string));
    }

    private Ptg parseIdentifier(String string) {
        if (this.look == ':' || this.look == '.') {
            this.GetChar();
            while (this.look == '.') {
                this.GetChar();
            }
            String string2 = string;
            String string3 = this.GetName();
            return new AreaPtg(string2 + ":" + string3);
        }
        if (this.look == '!') {
            this.Match('!');
            String string4 = string;
            String string5 = this.GetName();
            short s = this.book.getExternalSheetIndex(this.book.getSheetIndex(string4));
            if (this.look == ':') {
                this.Match(':');
                String string6 = this.GetName();
                if (this.look == '!') {
                    this.Match('!');
                    String string7 = this.GetName();
                    if (!string4.equals(string6)) {
                        throw new RuntimeException("Unhandled double sheet reference.");
                    }
                    return new Area3DPtg(string5 + ":" + string7, s);
                }
                return new Area3DPtg(string5 + ":" + string6, s);
            }
            return new Ref3DPtg(string5, s);
        }
        if (string.equalsIgnoreCase("TRUE") || string.equalsIgnoreCase("FALSE")) {
            return new BoolPtg(string.toUpperCase());
        }
        boolean bl = CELL_REFERENCE_PATTERN.matcher(string).matches();
        if (bl) {
            return new RefPtg(string);
        }
        for (int i = 0; i < this.book.getNumberOfNames(); ++i) {
            if (!this.book.getNameAt(i).getNameName().equalsIgnoreCase(string)) continue;
            return new NamePtg(string, this.book);
        }
        throw new FormulaParseException("Found reference to named range \"" + string + "\", but that named range wasn't defined!");
    }

    private ParseNode function(String string) {
        NamePtg namePtg = null;
        if (!AbstractFunctionPtg.isInternalFunctionName(string)) {
            namePtg = new NamePtg(string, this.book);
        }
        this.Match('(');
        ParseNode[] parseNodeArray = this.Arguments();
        this.Match(')');
        return this.getFunction(string, namePtg, parseNodeArray);
    }

    private ParseNode getFunction(String string, NamePtg namePtg, ParseNode[] parseNodeArray) {
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByName(string.toUpperCase());
        int n = parseNodeArray.length;
        if (functionMetadata == null) {
            if (namePtg == null) {
                throw new IllegalStateException("NamePtg must be supplied for external functions");
            }
            ParseNode[] parseNodeArray2 = new ParseNode[n + 1];
            parseNodeArray2[0] = new ParseNode(namePtg);
            System.arraycopy(parseNodeArray, 0, parseNodeArray2, 1, n);
            return new ParseNode((Ptg)new FuncVarPtg(string, (byte)(n + 1)), parseNodeArray2);
        }
        if (namePtg != null) {
            throw new IllegalStateException("NamePtg no applicable to internal functions");
        }
        boolean bl = !functionMetadata.hasFixedArgsLength();
        int n2 = functionMetadata.getIndex();
        this.validateNumArgs(parseNodeArray.length, functionMetadata);
        AbstractFunctionPtg abstractFunctionPtg = bl ? new FuncVarPtg(string, (byte)n) : new FuncPtg(n2);
        return new ParseNode((Ptg)abstractFunctionPtg, parseNodeArray);
    }

    private void validateNumArgs(int n, FunctionMetadata functionMetadata) {
        if (n < functionMetadata.getMinParams()) {
            String string = "Too few arguments to function '" + functionMetadata.getName() + "'. ";
            string = functionMetadata.hasFixedArgsLength() ? string + "Expected " + functionMetadata.getMinParams() : string + "At least " + functionMetadata.getMinParams() + " were expected";
            string = string + " but got " + n + ".";
            throw new FormulaParseException(string);
        }
        if (n > functionMetadata.getMaxParams()) {
            String string = "Too many arguments to function '" + functionMetadata.getName() + "'. ";
            string = functionMetadata.hasFixedArgsLength() ? string + "Expected " + functionMetadata.getMaxParams() : string + "At most " + functionMetadata.getMaxParams() + " were expected";
            string = string + " but got " + n + ".";
            throw new FormulaParseException(string);
        }
    }

    private static boolean isArgumentDelimiter(char c) {
        return c == ',' || c == ')';
    }

    private ParseNode[] Arguments() {
        ArrayList<ParseNode> arrayList;
        block5: {
            arrayList = new ArrayList<ParseNode>(2);
            this.SkipWhite();
            if (this.look == ')') {
                return ParseNode.EMPTY_ARRAY;
            }
            boolean bl = true;
            int n = 0;
            while (true) {
                this.SkipWhite();
                if (FormulaParser.isArgumentDelimiter(this.look)) {
                    if (bl) {
                        arrayList.add(new ParseNode(MissingArgPtg.instance));
                        ++n;
                    }
                    if (this.look != ')') {
                        this.Match(',');
                        bl = true;
                        continue;
                    }
                    break block5;
                }
                arrayList.add(this.comparisonExpression());
                ++n;
                bl = false;
                this.SkipWhite();
                if (!FormulaParser.isArgumentDelimiter(this.look)) break;
            }
            throw this.expected("',' or ')'");
        }
        ParseNode[] parseNodeArray = new ParseNode[arrayList.size()];
        arrayList.toArray(parseNodeArray);
        return parseNodeArray;
    }

    private ParseNode powerFactor() {
        ParseNode parseNode = this.percentFactor();
        while (true) {
            this.SkipWhite();
            if (this.look != '^') {
                return parseNode;
            }
            this.Match('^');
            ParseNode parseNode2 = this.percentFactor();
            parseNode = new ParseNode(PowerPtg.instance, parseNode, parseNode2);
        }
    }

    private ParseNode percentFactor() {
        ParseNode parseNode = this.parseSimpleFactor();
        while (true) {
            this.SkipWhite();
            if (this.look != '%') {
                return parseNode;
            }
            this.Match('%');
            parseNode = new ParseNode((Ptg)PercentPtg.instance, parseNode);
        }
    }

    private ParseNode parseSimpleFactor() {
        this.SkipWhite();
        switch (this.look) {
            case '#': {
                return new ParseNode(this.parseErrorLiteral());
            }
            case '-': {
                this.Match('-');
                return new ParseNode((Ptg)UnaryMinusPtg.instance, this.powerFactor());
            }
            case '+': {
                this.Match('+');
                return new ParseNode((Ptg)UnaryPlusPtg.instance, this.powerFactor());
            }
            case '(': {
                this.Match('(');
                ParseNode parseNode = this.comparisonExpression();
                this.Match(')');
                return new ParseNode((Ptg)ParenthesisPtg.instance, parseNode);
            }
            case '\"': {
                return new ParseNode(this.parseStringLiteral());
            }
        }
        if (this.IsAlpha(this.look) || this.look == '\'') {
            return this.parseFunctionOrIdentifier();
        }
        return new ParseNode(this.parseNumber());
    }

    private Ptg parseNumber() {
        String string = null;
        String string2 = null;
        String string3 = this.GetNum();
        if (this.look == '.') {
            this.GetChar();
            string = this.GetNum();
        }
        if (this.look == 'E') {
            this.GetChar();
            String string4 = "";
            if (this.look == '+') {
                this.GetChar();
            } else if (this.look == '-') {
                this.GetChar();
                string4 = "-";
            }
            String string5 = this.GetNum();
            if (string5 == null) {
                throw this.expected("Integer");
            }
            string2 = string4 + string5;
        }
        if (string3 == null && string == null) {
            throw this.expected("Integer");
        }
        return FormulaParser.getNumberPtgFromString(string3, string, string2);
    }

    private ErrPtg parseErrorLiteral() {
        this.Match('#');
        String string = this.GetName().toUpperCase();
        switch (string.charAt(0)) {
            case 'V': {
                if (string.equals("VALUE")) {
                    this.Match('!');
                    return ErrPtg.VALUE_INVALID;
                }
                throw this.expected("#VALUE!");
            }
            case 'R': {
                if (string.equals("REF")) {
                    this.Match('!');
                    return ErrPtg.REF_INVALID;
                }
                throw this.expected("#REF!");
            }
            case 'D': {
                if (string.equals("DIV")) {
                    this.Match('/');
                    this.Match('0');
                    this.Match('!');
                    return ErrPtg.DIV_ZERO;
                }
                throw this.expected("#DIV/0!");
            }
            case 'N': {
                if (string.equals("NAME")) {
                    this.Match('?');
                    return ErrPtg.NAME_INVALID;
                }
                if (string.equals("NUM")) {
                    this.Match('!');
                    return ErrPtg.NUM_ERROR;
                }
                if (string.equals("NULL")) {
                    this.Match('!');
                    return ErrPtg.NULL_INTERSECTION;
                }
                if (string.equals("N")) {
                    this.Match('/');
                    if (this.look != 'A' && this.look != 'a') {
                        throw this.expected("#N/A");
                    }
                    this.Match(this.look);
                    return ErrPtg.N_A;
                }
                throw this.expected("#NAME?, #NUM!, #NULL! or #N/A");
            }
        }
        throw this.expected("#VALUE!, #REF!, #DIV/0!, #NAME?, #NUM!, #NULL! or #N/A");
    }

    private static Ptg getNumberPtgFromString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null) {
            int n;
            stringBuffer.append(string);
            if (string3 != null) {
                stringBuffer.append('E');
                stringBuffer.append(string3);
            }
            String string4 = stringBuffer.toString();
            try {
                n = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                return new NumberPtg(string4);
            }
            if (IntPtg.isInRange(n)) {
                return new IntPtg(n);
            }
            return new NumberPtg(string4);
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append('.');
        stringBuffer.append(string2);
        if (string3 != null) {
            stringBuffer.append('E');
            stringBuffer.append(string3);
        }
        return new NumberPtg(stringBuffer.toString());
    }

    private StringPtg parseStringLiteral() {
        this.Match('\"');
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if (this.look == '\"') {
                this.GetChar();
                if (this.look != '\"') break;
            }
            stringBuffer.append(this.look);
            this.GetChar();
        }
        return new StringPtg(stringBuffer.toString());
    }

    private ParseNode Term() {
        ParseNode parseNode = this.powerFactor();
        while (true) {
            ValueOperatorPtg valueOperatorPtg;
            this.SkipWhite();
            switch (this.look) {
                case '*': {
                    this.Match('*');
                    valueOperatorPtg = MultiplyPtg.instance;
                    break;
                }
                case '/': {
                    this.Match('/');
                    valueOperatorPtg = DividePtg.instance;
                    break;
                }
                default: {
                    return parseNode;
                }
            }
            ParseNode parseNode2 = this.powerFactor();
            parseNode = new ParseNode(valueOperatorPtg, parseNode, parseNode2);
        }
    }

    private ParseNode comparisonExpression() {
        ParseNode parseNode = this.concatExpression();
        block3: while (true) {
            this.SkipWhite();
            switch (this.look) {
                case '<': 
                case '=': 
                case '>': {
                    Ptg ptg = this.getComparisonToken();
                    ParseNode parseNode2 = this.concatExpression();
                    parseNode = new ParseNode(ptg, parseNode, parseNode2);
                    continue block3;
                }
            }
            break;
        }
        return parseNode;
    }

    private Ptg getComparisonToken() {
        if (this.look == '=') {
            this.Match(this.look);
            return EqualPtg.instance;
        }
        boolean bl = this.look == '>';
        this.Match(this.look);
        if (bl) {
            if (this.look == '=') {
                this.Match('=');
                return GreaterEqualPtg.instance;
            }
            return GreaterThanPtg.instance;
        }
        switch (this.look) {
            case '=': {
                this.Match('=');
                return LessEqualPtg.instance;
            }
            case '>': {
                this.Match('>');
                return NotEqualPtg.instance;
            }
        }
        return LessThanPtg.instance;
    }

    private ParseNode concatExpression() {
        ParseNode parseNode = this.additiveExpression();
        while (true) {
            this.SkipWhite();
            if (this.look != '&') break;
            this.Match('&');
            ParseNode parseNode2 = this.additiveExpression();
            parseNode = new ParseNode(ConcatPtg.instance, parseNode, parseNode2);
        }
        return parseNode;
    }

    private ParseNode additiveExpression() {
        ParseNode parseNode = this.Term();
        while (true) {
            ValueOperatorPtg valueOperatorPtg;
            this.SkipWhite();
            switch (this.look) {
                case '+': {
                    this.Match('+');
                    valueOperatorPtg = AddPtg.instance;
                    break;
                }
                case '-': {
                    this.Match('-');
                    valueOperatorPtg = SubtractPtg.instance;
                    break;
                }
                default: {
                    return parseNode;
                }
            }
            ParseNode parseNode2 = this.Term();
            parseNode = new ParseNode(valueOperatorPtg, parseNode, parseNode2);
        }
    }

    public void parse() {
        this.pointer = 0;
        this.GetChar();
        this._rootNode = this.comparisonExpression();
        if (this.pointer <= this.formulaLength) {
            String string = "Unused input [" + this.formulaString.substring(this.pointer - 1) + "] after attempting to parse the formula [" + this.formulaString + "]";
            throw new FormulaParseException(string);
        }
    }

    public Ptg[] getRPNPtg() {
        return this.getRPNPtg(0);
    }

    public Ptg[] getRPNPtg(int n) {
        OperandClassTransformer operandClassTransformer = new OperandClassTransformer(n);
        operandClassTransformer.transformFormula(this._rootNode);
        return ParseNode.toTokenArray(this._rootNode);
    }

    public static String toFormulaString(HSSFWorkbook hSSFWorkbook, List list) {
        String string = null;
        if (list == null || list.size() == 0) {
            return "#NAME";
        }
        Ptg[] ptgArray = new Ptg[list.size()];
        ptgArray = list.toArray(ptgArray);
        string = FormulaParser.toFormulaString(hSSFWorkbook, ptgArray);
        return string;
    }

    public String toFormulaString(List list) {
        return FormulaParser.toFormulaString(this.book, list);
    }

    public static String toFormulaString(HSSFWorkbook hSSFWorkbook, Ptg[] ptgArray) {
        if (ptgArray == null || ptgArray.length == 0) {
            return "#NAME";
        }
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < ptgArray.length; ++i) {
            String[] stringArray;
            Object object;
            Ptg ptg = ptgArray[i];
            if (ptg instanceof MemAreaPtg || ptg instanceof MemFuncPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof ParenthesisPtg) {
                object = (String)stack.pop();
                stack.push("(" + (String)object + ")");
                continue;
            }
            if (ptg instanceof AttrPtg) {
                object = (AttrPtg)ptg;
                if (((AttrPtg)object).isOptimizedIf() || ((AttrPtg)object).isOptimizedChoose() || ((AttrPtg)object).isGoto() || ((AttrPtg)object).isSpace() || ((AttrPtg)object).isSemiVolatile()) continue;
                if (((AttrPtg)object).isSum()) {
                    stringArray = FormulaParser.getOperands(stack, ((AttrPtg)object).getNumberOfOperands());
                    stack.push(((AttrPtg)object).toFormulaString(stringArray));
                    continue;
                }
                throw new RuntimeException("Unexpected tAttr: " + ((AttrPtg)object).toString());
            }
            if (!(ptg instanceof OperationPtg)) {
                stack.push(ptg.toFormulaString(hSSFWorkbook));
                continue;
            }
            object = (OperationPtg)ptg;
            stringArray = FormulaParser.getOperands(stack, ((OperationPtg)object).getNumberOfOperands());
            stack.push(((OperationPtg)object).toFormulaString(stringArray));
        }
        if (stack.isEmpty()) {
            throw new IllegalStateException("Stack underflow");
        }
        String string = (String)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("too much stuff left on the stack");
        }
        return string;
    }

    private static String[] getOperands(Stack stack, int n) {
        String[] stringArray = new String[n];
        for (int i = n - 1; i >= 0; --i) {
            if (stack.isEmpty()) {
                String string = "Too few arguments supplied to operation. Expected (" + n + ") operands but got (" + (n - i - 1) + ")";
                throw new IllegalStateException(string);
            }
            stringArray[i] = (String)stack.pop();
        }
        return stringArray;
    }

    public String toFormulaString(Ptg[] ptgArray) {
        return FormulaParser.toFormulaString(this.book, ptgArray);
    }

    static final class FormulaParseException
    extends RuntimeException {
        public FormulaParseException(String string) {
            super(string);
        }
    }
}

