/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.model;

import com.fr.third.org.apache.poi.ddf.EscherDgRecord;
import com.fr.third.org.apache.poi.ddf.EscherDggRecord;
import java.util.ArrayList;
import java.util.List;

public class DrawingManager2 {
    EscherDggRecord dgg;
    List drawingGroups = new ArrayList();

    public DrawingManager2(EscherDggRecord escherDggRecord) {
        this.dgg = escherDggRecord;
    }

    public void clearDrawingGroups() {
        this.drawingGroups.clear();
    }

    public EscherDgRecord createDgRecord() {
        EscherDgRecord escherDgRecord = new EscherDgRecord();
        escherDgRecord.setRecordId((short)-4088);
        short s = this.findNewDrawingGroupId();
        escherDgRecord.setOptions((short)(s << 4));
        escherDgRecord.setNumShapes(0);
        escherDgRecord.setLastMSOSPID(-1);
        this.drawingGroups.add(escherDgRecord);
        this.dgg.addCluster(s, 0);
        this.dgg.setDrawingsSaved(this.dgg.getDrawingsSaved() + 1);
        return escherDgRecord;
    }

    public int allocateShapeId(short s) {
        this.dgg.setNumShapesSaved(this.dgg.getNumShapesSaved() + 1);
        for (int i = 0; i < this.dgg.getFileIdClusters().length; ++i) {
            EscherDggRecord.FileIdCluster fileIdCluster = this.dgg.getFileIdClusters()[i];
            if (fileIdCluster.getDrawingGroupId() != s || fileIdCluster.getNumShapeIdsUsed() == 1024) continue;
            int n = fileIdCluster.getNumShapeIdsUsed() + 1024 * (i + 1);
            fileIdCluster.incrementShapeId();
            EscherDgRecord escherDgRecord = this.getDrawingGroup(s);
            escherDgRecord.setNumShapes(escherDgRecord.getNumShapes() + 1);
            escherDgRecord.setLastMSOSPID(n);
            if (n >= this.dgg.getShapeIdMax()) {
                this.dgg.setShapeIdMax(n + 1);
            }
            return n;
        }
        this.dgg.addCluster(s, 0);
        this.dgg.getFileIdClusters()[this.dgg.getFileIdClusters().length - 1].incrementShapeId();
        EscherDgRecord escherDgRecord = this.getDrawingGroup(s);
        escherDgRecord.setNumShapes(escherDgRecord.getNumShapes() + 1);
        int n = 1024 * this.dgg.getFileIdClusters().length;
        escherDgRecord.setLastMSOSPID(n);
        if (n >= this.dgg.getShapeIdMax()) {
            this.dgg.setShapeIdMax(n + 1);
        }
        return n;
    }

    short findNewDrawingGroupId() {
        short s = 1;
        while (this.drawingGroupExists(s)) {
            s = (short)(s + 1);
        }
        return s;
    }

    EscherDgRecord getDrawingGroup(int n) {
        return (EscherDgRecord)this.drawingGroups.get(n - 1);
    }

    boolean drawingGroupExists(short s) {
        for (int i = 0; i < this.dgg.getFileIdClusters().length; ++i) {
            if (this.dgg.getFileIdClusters()[i].getDrawingGroupId() != s) continue;
            return true;
        }
        return false;
    }

    int findFreeSPIDBlock() {
        int n = this.dgg.getShapeIdMax();
        int n2 = (n / 1024 + 1) * 1024;
        return n2;
    }

    public EscherDggRecord getDgg() {
        return this.dgg;
    }
}

