/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.model;

import com.fr.third.org.apache.poi.ddf.EscherOptRecord;
import com.fr.third.org.apache.poi.ddf.EscherProperty;
import com.fr.third.org.apache.poi.ddf.EscherSimpleProperty;
import com.fr.third.org.apache.poi.hssf.model.TextboxShape;
import com.fr.third.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import com.fr.third.org.apache.poi.hssf.record.NoteRecord;
import com.fr.third.org.apache.poi.hssf.record.NoteStructureSubRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFComment;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShape;
import java.util.List;

public class CommentShape
extends TextboxShape {
    private NoteRecord note;

    public CommentShape(HSSFComment hSSFComment, int n) {
        super(hSSFComment, n);
        this.note = this.createNoteRecord(hSSFComment, n);
        ObjRecord objRecord = this.getObjRecord();
        List list = objRecord.getSubRecords();
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof CommonObjectDataSubRecord)) continue;
            CommonObjectDataSubRecord commonObjectDataSubRecord = (CommonObjectDataSubRecord)e;
            commonObjectDataSubRecord.setAutofill(false);
            n2 = i;
        }
        NoteStructureSubRecord noteStructureSubRecord = new NoteStructureSubRecord();
        objRecord.addSubRecord(n2 + 1, noteStructureSubRecord);
    }

    private NoteRecord createNoteRecord(HSSFComment hSSFComment, int n) {
        NoteRecord noteRecord = new NoteRecord();
        noteRecord.setColumn(hSSFComment.getColumn());
        noteRecord.setRow((short)hSSFComment.getRow());
        noteRecord.setFlags(hSSFComment.isVisible() ? (short)2 : 0);
        noteRecord.setShapeId((short)n);
        noteRecord.setAuthor(hSSFComment.getAuthor() == null ? "" : hSSFComment.getAuthor());
        return noteRecord;
    }

    protected int addStandardOptions(HSSFShape hSSFShape, EscherOptRecord escherOptRecord) {
        super.addStandardOptions(hSSFShape, escherOptRecord);
        List list = escherOptRecord.getEscherProperties();
        Object object = list.iterator();
        while (object.hasNext()) {
            EscherProperty escherProperty = (EscherProperty)object.next();
            switch (escherProperty.getId()) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 387: 
                case 448: 
                case 959: {
                    object.remove();
                }
            }
        }
        object = (HSSFComment)hSSFShape;
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(959, ((HSSFComment)object).isVisible() ? 655360 : 655362));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(575, 196611));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(513, 0));
        escherOptRecord.sortProperties();
        return escherOptRecord.getEscherProperties().size();
    }

    public NoteRecord getNoteRecord() {
        return this.note;
    }
}

