/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.extractor;

import com.fr.third.org.apache.poi.POIOLE2TextExtractor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFComment;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFTextbox;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.IOException;

public class ExcelExtractor
extends POIOLE2TextExtractor {
    private HSSFWorkbook wb;
    private boolean includeSheetNames = true;
    private boolean formulasNotResults = false;
    private boolean includeCellComments = false;

    public ExcelExtractor(HSSFWorkbook hSSFWorkbook) {
        super(hSSFWorkbook);
        this.wb = hSSFWorkbook;
    }

    public ExcelExtractor(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(new HSSFWorkbook(pOIFSFileSystem));
    }

    public void setIncludeSheetNames(boolean bl) {
        this.includeSheetNames = bl;
    }

    public void setFormulasNotResults(boolean bl) {
        this.formulasNotResults = bl;
    }

    public void setIncludeCellComments(boolean bl) {
        this.includeCellComments = bl;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.wb.getNumberOfSheets(); ++i) {
            String string;
            HSSFSheet hSSFSheet = this.wb.getSheetAt(i);
            if (hSSFSheet == null) continue;
            if (this.includeSheetNames && (string = this.wb.getSheetName(i)) != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            int n = hSSFSheet.getFirstRowNum();
            int n2 = hSSFSheet.getLastRowNum();
            for (int j = n; j <= n2; ++j) {
                HSSFRow hSSFRow = hSSFSheet.getRow(j);
                if (hSSFRow == null) continue;
                int n3 = hSSFRow.getFirstCellNum();
                short s = hSSFRow.getLastCellNum();
                for (int k = n3; k < s; ++k) {
                    Object object;
                    HSSFCell hSSFCell = hSSFRow.getCell((short)k);
                    boolean bl = false;
                    if (hSSFCell == null) continue;
                    switch (hSSFCell.getCellType()) {
                        case 1: {
                            stringBuffer.append(hSSFCell.getRichStringCellValue().getString());
                            bl = true;
                            break;
                        }
                        case 0: {
                            stringBuffer.append(hSSFCell.getNumericCellValue());
                            bl = true;
                            break;
                        }
                        case 4: {
                            stringBuffer.append(hSSFCell.getBooleanCellValue());
                            bl = true;
                            break;
                        }
                        case 2: {
                            if (this.formulasNotResults) {
                                stringBuffer.append(hSSFCell.getCellFormula());
                            } else {
                                object = hSSFCell.getRichStringCellValue();
                                if (object != null && ((HSSFRichTextString)object).length() > 0) {
                                    stringBuffer.append(((HSSFRichTextString)object).toString());
                                } else {
                                    double d = hSSFCell.getNumericCellValue();
                                    stringBuffer.append(d);
                                }
                            }
                            bl = true;
                        }
                    }
                    object = hSSFCell.getCellComment();
                    if (this.includeCellComments && object != null) {
                        String string2 = ((HSSFTextbox)object).getString().getString().replace('\n', ' ');
                        stringBuffer.append(" Comment by " + ((HSSFComment)object).getAuthor() + ": " + string2);
                    }
                    if (!bl || k >= s - 1) continue;
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }
}

