/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.extractor;

import com.fr.third.org.apache.poi.POIOLE2TextExtractor;
import com.fr.third.org.apache.poi.hpsf.DocumentSummaryInformation;
import com.fr.third.org.apache.poi.hpsf.SummaryInformation;
import com.fr.third.org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import com.fr.third.org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import com.fr.third.org.apache.poi.hssf.eventusermodel.HSSFListener;
import com.fr.third.org.apache.poi.hssf.eventusermodel.HSSFRequest;
import com.fr.third.org.apache.poi.hssf.model.FormulaParser;
import com.fr.third.org.apache.poi.hssf.record.BOFRecord;
import com.fr.third.org.apache.poi.hssf.record.BoundSheetRecord;
import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.FormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.NoteRecord;
import com.fr.third.org.apache.poi.hssf.record.NumberRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.SSTRecord;
import com.fr.third.org.apache.poi.hssf.record.StringRecord;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EventBasedExcelExtractor
extends POIOLE2TextExtractor {
    private POIFSFileSystem fs;
    private boolean includeSheetNames = true;
    private boolean formulasNotResults = false;

    public EventBasedExcelExtractor(POIFSFileSystem pOIFSFileSystem) throws IOException {
        super(null);
        this.fs = pOIFSFileSystem;
    }

    public DocumentSummaryInformation getDocSummaryInformation() {
        throw new IllegalStateException("Metadata extraction not supported in streaming mode, please use ExcelExtractor");
    }

    public SummaryInformation getSummaryInformation() {
        throw new IllegalStateException("Metadata extraction not supported in streaming mode, please use ExcelExtractor");
    }

    public void setIncludeSheetNames(boolean bl) {
        this.includeSheetNames = bl;
    }

    public void setFormulasNotResults(boolean bl) {
        this.formulasNotResults = bl;
    }

    public String getText() {
        String string = null;
        try {
            TextListener textListener = this.triggerExtraction();
            string = textListener.text.toString();
            if (!string.endsWith("\n")) {
                string = string + "\n";
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return string;
    }

    private TextListener triggerExtraction() throws IOException {
        TextListener textListener = new TextListener();
        FormatTrackingHSSFListener formatTrackingHSSFListener = new FormatTrackingHSSFListener(textListener);
        textListener.ft = formatTrackingHSSFListener;
        HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
        HSSFRequest hSSFRequest = new HSSFRequest();
        hSSFRequest.addListenerForAllRecords(formatTrackingHSSFListener);
        hSSFEventFactory.processWorkbookEvents(hSSFRequest, this.fs);
        return textListener;
    }

    private class TextListener
    implements HSSFListener {
        private FormatTrackingHSSFListener ft;
        private SSTRecord sstRecord;
        private List sheetNames = new ArrayList();
        private StringBuffer text = new StringBuffer();
        private int sheetNum = -1;
        private int rowNum;
        private boolean outputNextStringValue = false;
        private int nextRow = -1;

        private TextListener() {
        }

        public void processRecord(Record record) {
            String string = null;
            int n = -1;
            switch (record.getSid()) {
                case 133: {
                    BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                    this.sheetNames.add(boundSheetRecord.getSheetname());
                    break;
                }
                case 2057: {
                    BOFRecord bOFRecord = (BOFRecord)record;
                    if (bOFRecord.getType() != 16) break;
                    ++this.sheetNum;
                    this.rowNum = -1;
                    if (!EventBasedExcelExtractor.this.includeSheetNames) break;
                    if (this.text.length() > 0) {
                        this.text.append("\n");
                    }
                    this.text.append(this.sheetNames.get(this.sheetNum));
                    break;
                }
                case 252: {
                    this.sstRecord = (SSTRecord)record;
                    break;
                }
                case 6: {
                    FormulaRecord formulaRecord = (FormulaRecord)record;
                    n = formulaRecord.getRow();
                    if (EventBasedExcelExtractor.this.formulasNotResults) {
                        string = FormulaParser.toFormulaString(null, formulaRecord.getParsedExpression());
                        break;
                    }
                    if (Double.isNaN(formulaRecord.getValue())) {
                        this.outputNextStringValue = true;
                        this.nextRow = formulaRecord.getRow();
                        break;
                    }
                    string = this.formatNumberDateCell(formulaRecord, formulaRecord.getValue());
                    break;
                }
                case 519: {
                    if (!this.outputNextStringValue) break;
                    StringRecord stringRecord = (StringRecord)record;
                    string = stringRecord.getString();
                    n = this.nextRow;
                    this.outputNextStringValue = false;
                    break;
                }
                case 516: {
                    LabelRecord labelRecord = (LabelRecord)record;
                    n = labelRecord.getRow();
                    string = labelRecord.getValue();
                    break;
                }
                case 253: {
                    LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                    n = labelSSTRecord.getRow();
                    if (this.sstRecord == null) {
                        throw new IllegalStateException("No SST record found");
                    }
                    string = this.sstRecord.getString(labelSSTRecord.getSSTIndex()).toString();
                    break;
                }
                case 28: {
                    NoteRecord noteRecord = (NoteRecord)record;
                    n = noteRecord.getRow();
                    break;
                }
                case 515: {
                    NumberRecord numberRecord = (NumberRecord)record;
                    n = numberRecord.getRow();
                    string = this.formatNumberDateCell(numberRecord, numberRecord.getValue());
                    break;
                }
            }
            if (string != null) {
                if (n != this.rowNum) {
                    this.rowNum = n;
                    if (this.text.length() > 0) {
                        this.text.append("\n");
                    }
                } else {
                    this.text.append("\t");
                }
                this.text.append(string);
            }
        }

        private String formatNumberDateCell(CellValueRecordInterface cellValueRecordInterface, double d) {
            int n = this.ft.getFormatIndex(cellValueRecordInterface);
            String string = this.ft.getFormatString(cellValueRecordInterface);
            if (string == null) {
                return Double.toString(d);
            }
            if (HSSFDateUtil.isADateFormat(n, string) && HSSFDateUtil.isValidExcelDate(d)) {
                string = string.replace('m', 'M');
                string = string.replaceAll("\\\\-", "-");
                Date date = HSSFDateUtil.getJavaDate(d, false);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                return simpleDateFormat.format(date);
            }
            if (string == "General") {
                return Double.toString(d);
            }
            DecimalFormat decimalFormat = new DecimalFormat(string);
            return decimalFormat.format(d);
        }
    }
}

