/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.eventusermodel;

import com.fr.third.org.apache.poi.hssf.eventusermodel.HSSFListener;
import com.fr.third.org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import com.fr.third.org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import com.fr.third.org.apache.poi.hssf.eventusermodel.dummyrecord.MissingRowDummyRecord;
import com.fr.third.org.apache.poi.hssf.record.BOFRecord;
import com.fr.third.org.apache.poi.hssf.record.BlankRecord;
import com.fr.third.org.apache.poi.hssf.record.BoolErrRecord;
import com.fr.third.org.apache.poi.hssf.record.BoundSheetRecord;
import com.fr.third.org.apache.poi.hssf.record.FormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.NoteRecord;
import com.fr.third.org.apache.poi.hssf.record.NumberRecord;
import com.fr.third.org.apache.poi.hssf.record.RKRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RowRecord;

public class MissingRecordAwareHSSFListener
implements HSSFListener {
    private HSSFListener childListener;
    private int lastSeenRow = -1;
    private int lastSeenColumn = -1;

    public MissingRecordAwareHSSFListener(HSSFListener hSSFListener) {
        this.childListener = hSSFListener;
    }

    public void processRecord(Record record) {
        Record record2;
        Record record3;
        Record record4;
        int n = -1;
        int n2 = -1;
        switch (record.getSid()) {
            case 2057: {
                record4 = (BOFRecord)record;
                if (record4.getType() == 5) {
                    this.lastSeenRow = -1;
                    this.lastSeenColumn = -1;
                    break;
                }
                if (record4.getType() != 16) break;
                this.lastSeenRow = -1;
                this.lastSeenColumn = -1;
                break;
            }
            case 133: {
                record3 = (BoundSheetRecord)record;
                break;
            }
            case 520: {
                Record record5;
                record2 = (RowRecord)record;
                if (this.lastSeenRow + 1 < record2.getRowNumber()) {
                    for (int i = this.lastSeenRow + 1; i < record2.getRowNumber(); ++i) {
                        record5 = new MissingRowDummyRecord(i);
                        this.childListener.processRecord(record5);
                    }
                }
                this.lastSeenRow = record2.getRowNumber();
                break;
            }
            case 513: {
                BlankRecord blankRecord = (BlankRecord)record;
                n = blankRecord.getRow();
                n2 = blankRecord.getColumn();
                break;
            }
            case 517: {
                Record record5 = (BoolErrRecord)record;
                n = record5.getRow();
                n2 = record5.getColumn();
                break;
            }
            case 6: {
                FormulaRecord formulaRecord = (FormulaRecord)record;
                n = formulaRecord.getRow();
                n2 = formulaRecord.getColumn();
                break;
            }
            case 516: {
                LabelRecord labelRecord = (LabelRecord)record;
                n = labelRecord.getRow();
                n2 = labelRecord.getColumn();
                break;
            }
            case 253: {
                LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                n = labelSSTRecord.getRow();
                n2 = labelSSTRecord.getColumn();
                break;
            }
            case 28: {
                NoteRecord noteRecord = (NoteRecord)record;
                n = noteRecord.getRow();
                n2 = noteRecord.getColumn();
                break;
            }
            case 515: {
                NumberRecord numberRecord = (NumberRecord)record;
                n = numberRecord.getRow();
                n2 = numberRecord.getColumn();
                break;
            }
            case 638: {
                RKRecord rKRecord = (RKRecord)record;
                n = rKRecord.getRow();
                n2 = rKRecord.getColumn();
                break;
            }
        }
        if (n != this.lastSeenRow) {
            for (int i = this.lastSeenRow; i < n; ++i) {
                int n3 = -1;
                if (i == this.lastSeenRow) {
                    n3 = this.lastSeenColumn;
                }
                record2 = new LastCellOfRowDummyRecord(i, n3);
                this.childListener.processRecord(record2);
            }
        }
        if (this.lastSeenRow != -1 && this.lastSeenColumn != -1 && n == -1) {
            record4 = new LastCellOfRowDummyRecord(this.lastSeenRow, this.lastSeenColumn);
            this.childListener.processRecord(record4);
            this.lastSeenRow = -1;
            this.lastSeenColumn = -1;
        }
        if (n != this.lastSeenRow) {
            this.lastSeenColumn = -1;
        }
        if (this.lastSeenColumn != n2 - 1) {
            for (int i = this.lastSeenColumn + 1; i < n2; ++i) {
                record3 = new MissingCellDummyRecord(n, i);
                this.childListener.processRecord(record3);
            }
        }
        if (n2 != -1) {
            this.lastSeenRow = n;
            this.lastSeenColumn = n2;
        }
        this.childListener.processRecord(record);
    }
}

