/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.eventusermodel;

import com.fr.third.org.apache.poi.hssf.record.ContinueRecord;
import com.fr.third.org.apache.poi.hssf.record.DrawingGroupRecord;
import com.fr.third.org.apache.poi.hssf.record.DrawingRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFactory;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.TextObjectRecord;
import com.fr.third.org.apache.poi.hssf.record.UnknownRecord;
import java.util.Vector;

public class HSSFRecordStream {
    private RecordInputStream in;
    private boolean hitEOS = false;
    private boolean complete = false;
    private Vector bonusRecords = null;
    private Record rec = null;
    private Record lastRec = null;
    private DrawingRecord lastDrawingRecord = new DrawingRecord();

    public HSSFRecordStream(RecordInputStream recordInputStream) {
        this.in = recordInputStream;
    }

    public Record nextRecord() {
        Record record = null;
        while (record == null && !this.complete) {
            record = this.getBonusRecord();
            if (record != null) continue;
            record = this.getNextRecord();
        }
        return record;
    }

    private Record getBonusRecord() {
        if (this.bonusRecords != null) {
            Record record = (Record)this.bonusRecords.remove(0);
            if (this.bonusRecords.size() == 0) {
                this.bonusRecords = null;
            }
            return record;
        }
        return null;
    }

    private Record getNextRecord() {
        Record record = null;
        if (this.in.hasNextRecord()) {
            this.in.nextRecord();
            short s = this.in.getSid();
            if (s == 0) {
                return null;
            }
            if (this.rec != null && s != 60) {
                record = this.rec;
            }
            if (s != 60) {
                Record[] recordArray = RecordFactory.createRecord(this.in);
                if (recordArray.length > 1) {
                    this.bonusRecords = new Vector(recordArray.length - 1);
                    for (int i = 0; i < recordArray.length - 1; ++i) {
                        this.bonusRecords.add(recordArray[i]);
                    }
                }
                this.rec = recordArray[recordArray.length - 1];
            } else {
                Record[] recordArray = RecordFactory.createRecord(this.in);
                ContinueRecord continueRecord = (ContinueRecord)recordArray[0];
                if (this.lastRec instanceof ObjRecord || this.lastRec instanceof TextObjectRecord) {
                    this.lastDrawingRecord.processContinueRecord(continueRecord.getData());
                    this.rec = this.lastDrawingRecord;
                } else if (this.lastRec instanceof DrawingGroupRecord) {
                    ((DrawingGroupRecord)this.lastRec).processContinueRecord(continueRecord.getData());
                    this.rec = this.lastRec;
                } else if (!(this.rec instanceof UnknownRecord)) {
                    throw new RecordFormatException("Records should handle ContinueRecord internally. Should not see this exception");
                }
            }
            this.lastRec = this.rec;
            if (this.rec instanceof DrawingRecord) {
                this.lastDrawingRecord = (DrawingRecord)this.rec;
            }
        } else {
            this.hitEOS = true;
        }
        if (this.hitEOS) {
            this.complete = true;
            if (this.rec != null) {
                record = this.rec;
                this.rec = null;
            }
        }
        return record;
    }
}

