/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.eventusermodel;

import com.fr.third.org.apache.poi.hssf.eventusermodel.HSSFRecordStream;
import com.fr.third.org.apache.poi.hssf.eventusermodel.HSSFRequest;
import com.fr.third.org.apache.poi.hssf.eventusermodel.HSSFUserException;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentInputStream;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.IOException;
import java.io.InputStream;

public class HSSFEventFactory {
    public void processWorkbookEvents(HSSFRequest hSSFRequest, POIFSFileSystem pOIFSFileSystem) throws IOException {
        DocumentInputStream documentInputStream = pOIFSFileSystem.createDocumentInputStream("Workbook");
        this.processEvents(hSSFRequest, documentInputStream);
    }

    public short abortableProcessWorkbookEvents(HSSFRequest hSSFRequest, POIFSFileSystem pOIFSFileSystem) throws IOException, HSSFUserException {
        DocumentInputStream documentInputStream = pOIFSFileSystem.createDocumentInputStream("Workbook");
        return this.abortableProcessEvents(hSSFRequest, documentInputStream);
    }

    public void processEvents(HSSFRequest hSSFRequest, InputStream inputStream) throws IOException {
        try {
            this.genericProcessEvents(hSSFRequest, new RecordInputStream(inputStream));
        }
        catch (HSSFUserException hSSFUserException) {
            // empty catch block
        }
    }

    public short abortableProcessEvents(HSSFRequest hSSFRequest, InputStream inputStream) throws IOException, HSSFUserException {
        return this.genericProcessEvents(hSSFRequest, new RecordInputStream(inputStream));
    }

    protected short genericProcessEvents(HSSFRequest hSSFRequest, RecordInputStream recordInputStream) throws IOException, HSSFUserException {
        boolean bl = true;
        short s = 0;
        Record record = null;
        HSSFRecordStream hSSFRecordStream = new HSSFRecordStream(recordInputStream);
        while (bl) {
            record = hSSFRecordStream.nextRecord();
            if (record != null) {
                s = hSSFRequest.processRecord(record);
                if (s == 0) continue;
                break;
            }
            bl = false;
        }
        return s;
    }
}

