/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.eventusermodel;

import com.fr.third.org.apache.poi.hssf.eventusermodel.HSSFListener;
import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.ExtendedFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.FormatRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class FormatTrackingHSSFListener
implements HSSFListener {
    private HSSFListener childListener;
    private Map customFormatRecords = new Hashtable();
    private List xfRecords = new ArrayList();

    public FormatTrackingHSSFListener(HSSFListener hSSFListener) {
        this.childListener = hSSFListener;
    }

    public void processRecord(Record record) {
        this.processRecordInternally(record);
        this.childListener.processRecord(record);
    }

    public void processRecordInternally(Record record) {
        Record record2;
        if (record instanceof FormatRecord) {
            record2 = (FormatRecord)record;
            this.customFormatRecords.put(new Integer(((FormatRecord)record2).getIndexCode()), record2);
        }
        if (record instanceof ExtendedFormatRecord) {
            record2 = (ExtendedFormatRecord)record;
            this.xfRecords.add(record2);
        }
    }

    public String getFormatString(int n) {
        String string = null;
        if (n >= HSSFDataFormat.getNumberOfBuiltinBuiltinFormats()) {
            FormatRecord formatRecord = (FormatRecord)this.customFormatRecords.get(new Integer(n));
            if (formatRecord == null) {
                System.err.println("Requested format at index " + n + ", but it wasn't found");
            } else {
                string = formatRecord.getFormatString();
            }
        } else {
            string = HSSFDataFormat.getBuiltinFormat((short)n);
        }
        return string;
    }

    public String getFormatString(CellValueRecordInterface cellValueRecordInterface) {
        int n = this.getFormatIndex(cellValueRecordInterface);
        if (n == -1) {
            return null;
        }
        return this.getFormatString(n);
    }

    public int getFormatIndex(CellValueRecordInterface cellValueRecordInterface) {
        ExtendedFormatRecord extendedFormatRecord = (ExtendedFormatRecord)this.xfRecords.get(cellValueRecordInterface.getXFIndex());
        if (extendedFormatRecord == null) {
            System.err.println("Cell " + cellValueRecordInterface.getRow() + "," + cellValueRecordInterface.getColumn() + " uses XF with index " + cellValueRecordInterface.getXFIndex() + ", but we don't have that");
            return -1;
        }
        return extendedFormatRecord.getFormatIndex();
    }
}

