/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.eventmodel;

import com.fr.third.org.apache.poi.hssf.eventmodel.ERFListener;
import com.fr.third.org.apache.poi.hssf.eventmodel.EventRecordFactory;
import com.fr.third.org.apache.poi.hssf.eventmodel.ModelFactoryListener;
import com.fr.third.org.apache.poi.hssf.model.Model;
import com.fr.third.org.apache.poi.hssf.model.Sheet;
import com.fr.third.org.apache.poi.hssf.model.Workbook;
import com.fr.third.org.apache.poi.hssf.record.BOFRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModelFactory
implements ERFListener {
    List listeners = new ArrayList(1);
    Model currentmodel;
    boolean lastEOF;

    public void registerListener(ModelFactoryListener modelFactoryListener) {
        this.listeners.add(modelFactoryListener);
    }

    public void run(InputStream inputStream) {
        EventRecordFactory eventRecordFactory = new EventRecordFactory(true);
        eventRecordFactory.registerListener(this, null);
        this.lastEOF = true;
        eventRecordFactory.processRecords(inputStream);
    }

    public boolean processRecord(Record record) {
        if (record.getSid() == 2057) {
            if (!this.lastEOF) {
                throw new RuntimeException("Not yet handled embedded models");
            }
            BOFRecord bOFRecord = (BOFRecord)record;
            switch (bOFRecord.getType()) {
                case 5: {
                    this.currentmodel = new Workbook();
                    break;
                }
                case 16: {
                    this.currentmodel = new Sheet();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported model type " + bOFRecord.getType());
                }
            }
        }
        if (record.getSid() == 10) {
            this.lastEOF = true;
            this.throwEvent(this.currentmodel);
        } else {
            this.lastEOF = false;
        }
        return true;
    }

    private void throwEvent(Model model) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ModelFactoryListener modelFactoryListener = (ModelFactoryListener)iterator.next();
            modelFactoryListener.process(model);
        }
    }
}

