/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.dev;

import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.Region;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class HSSF {
    private String filename = null;
    protected HSSFWorkbook hssfworkbook = null;

    public HSSF(String string) throws IOException {
        this.filename = string;
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(new FileInputStream(string));
        this.hssfworkbook = new HSSFWorkbook(pOIFSFileSystem);
    }

    public HSSF(String string, boolean bl) throws IOException {
        short s;
        int n = 0;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook();
        HSSFSheet hSSFSheet = hSSFWorkbook.createSheet();
        HSSFRow hSSFRow = null;
        HSSFCell hSSFCell = null;
        HSSFCellStyle hSSFCellStyle = hSSFWorkbook.createCellStyle();
        HSSFCellStyle hSSFCellStyle2 = hSSFWorkbook.createCellStyle();
        HSSFCellStyle hSSFCellStyle3 = hSSFWorkbook.createCellStyle();
        HSSFFont hSSFFont = hSSFWorkbook.createFont();
        HSSFFont hSSFFont2 = hSSFWorkbook.createFont();
        hSSFFont.setFontHeightInPoints((short)12);
        hSSFFont.setColor((short)10);
        hSSFFont.setBoldweight((short)700);
        hSSFFont2.setFontHeightInPoints((short)10);
        hSSFFont2.setColor((short)15);
        hSSFFont2.setBoldweight((short)700);
        hSSFCellStyle.setFont(hSSFFont);
        hSSFCellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat("($#,##0_);[Red]($#,##0)"));
        hSSFCellStyle2.setBorderBottom((short)1);
        hSSFCellStyle2.setFillPattern((short)1);
        hSSFCellStyle2.setFillForegroundColor((short)10);
        hSSFCellStyle2.setFont(hSSFFont2);
        hSSFWorkbook.setSheetName(0, "HSSF Test");
        for (n = 0; n < 300; n = (int)((short)(n + 1))) {
            hSSFRow = hSSFSheet.createRow(n);
            if (n % 2 == 0) {
                hSSFRow.setHeight((short)585);
            }
            for (s = 0; s < 50; s = (short)(s + 2)) {
                hSSFCell = hSSFRow.createCell(s, 0);
                hSSFCell.setCellValue((double)(n * 10000 + s) + ((double)n / 1000.0 + (double)s / 10000.0));
                if (n % 2 == 0) {
                    hSSFCell.setCellStyle(hSSFCellStyle);
                }
                hSSFCell = hSSFRow.createCell((short)(s + 1), 1);
                hSSFCell.setCellValue("TEST");
                hSSFSheet.setColumnWidth((short)(s + 1), (short)8000);
                if (n % 2 != 0) continue;
                hSSFCell.setCellStyle(hSSFCellStyle2);
            }
        }
        n = (short)(n + 1);
        n = (short)(n + 1);
        hSSFRow = hSSFSheet.createRow(n);
        hSSFCellStyle3.setBorderBottom((short)5);
        for (s = 0; s < 50; s = (short)(s + 1)) {
            hSSFCell = hSSFRow.createCell(s, 3);
            hSSFCell.setCellStyle(hSSFCellStyle3);
        }
        hSSFSheet.addMergedRegion(new Region(0, 0, 3, 3));
        hSSFSheet.addMergedRegion(new Region(100, 100, 110, 110));
        hSSFSheet = hSSFWorkbook.createSheet();
        hSSFWorkbook.setSheetName(1, "DeletedSheet");
        hSSFWorkbook.removeSheetAt(1);
        hSSFWorkbook.write(fileOutputStream);
        fileOutputStream.close();
    }

    public HSSF(String string, String string2, boolean bl) throws IOException {
        this.filename = string;
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(new FileInputStream(this.filename));
        this.hssfworkbook = new HSSFWorkbook(pOIFSFileSystem);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 2) {
            if (stringArray.length == 2) {
                if (stringArray[1].toLowerCase().equals("write")) {
                    System.out.println("Write mode");
                    try {
                        long l = System.currentTimeMillis();
                        HSSF hSSF = new HSSF(stringArray[0], true);
                        System.out.println("" + (System.currentTimeMillis() - l) + " ms generation time");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    System.out.println("readwrite test");
                    try {
                        HSSF hSSF = new HSSF(stringArray[0]);
                        HSSFWorkbook hSSFWorkbook = hSSF.hssfworkbook;
                        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
                        hSSFWorkbook.write(fileOutputStream);
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            } else if (stringArray.length == 3 && stringArray[2].toLowerCase().equals("modify1")) {
                try {
                    Object object;
                    int n;
                    HSSF hSSF = new HSSF(stringArray[0]);
                    HSSFWorkbook hSSFWorkbook = hSSF.hssfworkbook;
                    FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
                    HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(0);
                    for (n = 0; n < 25; ++n) {
                        object = hSSFSheet.getRow(n);
                        hSSFSheet.removeRow((HSSFRow)object);
                    }
                    for (n = 74; n < 100; ++n) {
                        object = hSSFSheet.getRow(n);
                        hSSFSheet.removeRow((HSSFRow)object);
                    }
                    HSSFRow hSSFRow = hSSFSheet.getRow(39);
                    object = hSSFRow.getCell((short)3);
                    ((HSSFCell)object).setCellType(1);
                    ((HSSFCell)object).setCellValue("MODIFIED CELL!!!!!");
                    hSSFWorkbook.write(fileOutputStream);
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

