/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.dev;

import com.fr.third.org.apache.poi.hssf.model.FormulaParser;
import com.fr.third.org.apache.poi.hssf.record.FormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFactory;
import com.fr.third.org.apache.poi.hssf.record.formula.ExpPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.FuncPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.OperationPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.FileInputStream;
import java.util.List;

public class FormulaViewer {
    private String file;
    private boolean list = false;

    public void run() throws Exception {
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(new FileInputStream(this.file));
        List list = RecordFactory.createRecords(pOIFSFileSystem.createDocumentInputStream("Workbook"));
        for (int i = 0; i < list.size(); ++i) {
            Record record = (Record)list.get(i);
            if (record.getSid() != 6) continue;
            if (this.list) {
                this.listFormula((FormulaRecord)record);
                continue;
            }
            this.parseFormulaRecord((FormulaRecord)record);
        }
    }

    private void listFormula(FormulaRecord formulaRecord) {
        String string = "~";
        List list = formulaRecord.getParsedExpression();
        int n = formulaRecord.getNumberOfExpressionTokens();
        Ptg ptg = null;
        if (list != null) {
            ptg = (Ptg)list.get(n - 1);
            String string2 = ptg instanceof FuncPtg ? String.valueOf(n - 1) : String.valueOf(-1);
            StringBuffer stringBuffer = new StringBuffer();
            if (ptg instanceof ExpPtg) {
                return;
            }
            String string3 = ((OperationPtg)ptg).toFormulaString((HSSFWorkbook)null);
            stringBuffer.append(string3);
            stringBuffer.append(string);
            switch (ptg.getPtgClass()) {
                case 0: {
                    stringBuffer.append("REF");
                    break;
                }
                case 32: {
                    stringBuffer.append("VALUE");
                    break;
                }
                case 64: {
                    stringBuffer.append("ARRAY");
                }
            }
            stringBuffer.append(string);
            if (n > 1) {
                ptg = (Ptg)list.get(n - 2);
                switch (ptg.getPtgClass()) {
                    case 0: {
                        stringBuffer.append("REF");
                        break;
                    }
                    case 32: {
                        stringBuffer.append("VALUE");
                        break;
                    }
                    case 64: {
                        stringBuffer.append("ARRAY");
                    }
                }
            } else {
                stringBuffer.append("VALUE");
            }
            stringBuffer.append(string);
            stringBuffer.append(string2);
            System.out.println(stringBuffer.toString());
        } else {
            System.out.println("#NAME");
        }
    }

    public void parseFormulaRecord(FormulaRecord formulaRecord) {
        System.out.println("==============================");
        System.out.print("row = " + formulaRecord.getRow());
        System.out.println(", col = " + formulaRecord.getColumn());
        System.out.println("value = " + formulaRecord.getValue());
        System.out.print("xf = " + formulaRecord.getXFIndex());
        System.out.print(", number of ptgs = " + formulaRecord.getNumberOfExpressionTokens());
        System.out.println(", options = " + formulaRecord.getOptions());
        System.out.println("RPN List = " + this.formulaString(formulaRecord));
        System.out.println("Formula text = " + this.composeFormula(formulaRecord));
    }

    private String formulaString(FormulaRecord formulaRecord) {
        StringBuffer stringBuffer = new StringBuffer("=");
        int n = formulaRecord.getNumberOfExpressionTokens();
        List list = formulaRecord.getParsedExpression();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            Ptg ptg = (Ptg)list.get(i);
            stringBuffer2.append(ptg.toFormulaString(null));
            switch (ptg.getPtgClass()) {
                case 0: {
                    stringBuffer2.append("(R)");
                    break;
                }
                case 32: {
                    stringBuffer2.append("(V)");
                    break;
                }
                case 64: {
                    stringBuffer2.append("(A)");
                }
            }
            stringBuffer2.append(' ');
        }
        return stringBuffer2.toString();
    }

    private String composeFormula(FormulaRecord formulaRecord) {
        return FormulaParser.toFormulaString((HSSFWorkbook)null, formulaRecord.getParsedExpression());
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void setList(boolean bl) {
        this.list = bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length > 2 || stringArray[0].equals("--help")) {
            System.out.println("FormulaViewer .8 proof that the devil lies in the details (or just in BIFF8 files in general)");
            System.out.println("usage: Give me a big fat file name");
        } else if (stringArray[0].equals("--listFunctions")) {
            try {
                FormulaViewer formulaViewer = new FormulaViewer();
                formulaViewer.setFile(stringArray[1]);
                formulaViewer.setList(true);
                formulaViewer.run();
            }
            catch (Exception exception) {
                System.out.println("Whoops!");
                exception.printStackTrace();
            }
        } else {
            try {
                FormulaViewer formulaViewer = new FormulaViewer();
                formulaViewer.setFile(stringArray[0]);
                formulaViewer.run();
            }
            catch (Exception exception) {
                System.out.println("Whoops!");
                exception.printStackTrace();
            }
        }
    }
}

