/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.dev;

import com.fr.third.org.apache.poi.hssf.record.AreaFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.AreaRecord;
import com.fr.third.org.apache.poi.hssf.record.AxisLineFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.AxisOptionsRecord;
import com.fr.third.org.apache.poi.hssf.record.AxisParentRecord;
import com.fr.third.org.apache.poi.hssf.record.AxisRecord;
import com.fr.third.org.apache.poi.hssf.record.AxisUsedRecord;
import com.fr.third.org.apache.poi.hssf.record.BOFRecord;
import com.fr.third.org.apache.poi.hssf.record.BackupRecord;
import com.fr.third.org.apache.poi.hssf.record.BarRecord;
import com.fr.third.org.apache.poi.hssf.record.BeginRecord;
import com.fr.third.org.apache.poi.hssf.record.BlankRecord;
import com.fr.third.org.apache.poi.hssf.record.BookBoolRecord;
import com.fr.third.org.apache.poi.hssf.record.BoolErrRecord;
import com.fr.third.org.apache.poi.hssf.record.BottomMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.BoundSheetRecord;
import com.fr.third.org.apache.poi.hssf.record.CalcCountRecord;
import com.fr.third.org.apache.poi.hssf.record.CalcModeRecord;
import com.fr.third.org.apache.poi.hssf.record.CategorySeriesAxisRecord;
import com.fr.third.org.apache.poi.hssf.record.ChartFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.ChartRecord;
import com.fr.third.org.apache.poi.hssf.record.CodepageRecord;
import com.fr.third.org.apache.poi.hssf.record.ColumnInfoRecord;
import com.fr.third.org.apache.poi.hssf.record.ContinueRecord;
import com.fr.third.org.apache.poi.hssf.record.CountryRecord;
import com.fr.third.org.apache.poi.hssf.record.DBCellRecord;
import com.fr.third.org.apache.poi.hssf.record.DSFRecord;
import com.fr.third.org.apache.poi.hssf.record.DatRecord;
import com.fr.third.org.apache.poi.hssf.record.DataFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.DateWindow1904Record;
import com.fr.third.org.apache.poi.hssf.record.DefaultColWidthRecord;
import com.fr.third.org.apache.poi.hssf.record.DefaultDataLabelTextPropertiesRecord;
import com.fr.third.org.apache.poi.hssf.record.DefaultRowHeightRecord;
import com.fr.third.org.apache.poi.hssf.record.DeltaRecord;
import com.fr.third.org.apache.poi.hssf.record.DimensionsRecord;
import com.fr.third.org.apache.poi.hssf.record.DrawingGroupRecord;
import com.fr.third.org.apache.poi.hssf.record.DrawingRecordForBiffViewer;
import com.fr.third.org.apache.poi.hssf.record.DrawingSelectionRecord;
import com.fr.third.org.apache.poi.hssf.record.EOFRecord;
import com.fr.third.org.apache.poi.hssf.record.EndRecord;
import com.fr.third.org.apache.poi.hssf.record.ExtSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.ExtendedFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.ExternSheetRecord;
import com.fr.third.org.apache.poi.hssf.record.FilePassRecord;
import com.fr.third.org.apache.poi.hssf.record.FileSharingRecord;
import com.fr.third.org.apache.poi.hssf.record.FnGroupCountRecord;
import com.fr.third.org.apache.poi.hssf.record.FontBasisRecord;
import com.fr.third.org.apache.poi.hssf.record.FontIndexRecord;
import com.fr.third.org.apache.poi.hssf.record.FontRecord;
import com.fr.third.org.apache.poi.hssf.record.FooterRecord;
import com.fr.third.org.apache.poi.hssf.record.FormatRecord;
import com.fr.third.org.apache.poi.hssf.record.FormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.FrameRecord;
import com.fr.third.org.apache.poi.hssf.record.GridsetRecord;
import com.fr.third.org.apache.poi.hssf.record.GutsRecord;
import com.fr.third.org.apache.poi.hssf.record.HCenterRecord;
import com.fr.third.org.apache.poi.hssf.record.HeaderRecord;
import com.fr.third.org.apache.poi.hssf.record.HideObjRecord;
import com.fr.third.org.apache.poi.hssf.record.HorizontalPageBreakRecord;
import com.fr.third.org.apache.poi.hssf.record.HyperlinkRecord;
import com.fr.third.org.apache.poi.hssf.record.IndexRecord;
import com.fr.third.org.apache.poi.hssf.record.InterfaceEndRecord;
import com.fr.third.org.apache.poi.hssf.record.InterfaceHdrRecord;
import com.fr.third.org.apache.poi.hssf.record.IterationRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelRecord;
import com.fr.third.org.apache.poi.hssf.record.LabelSSTRecord;
import com.fr.third.org.apache.poi.hssf.record.LeftMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.LegendRecord;
import com.fr.third.org.apache.poi.hssf.record.LineFormatRecord;
import com.fr.third.org.apache.poi.hssf.record.LinkedDataRecord;
import com.fr.third.org.apache.poi.hssf.record.MMSRecord;
import com.fr.third.org.apache.poi.hssf.record.MergeCellsRecord;
import com.fr.third.org.apache.poi.hssf.record.MulBlankRecord;
import com.fr.third.org.apache.poi.hssf.record.MulRKRecord;
import com.fr.third.org.apache.poi.hssf.record.NameRecord;
import com.fr.third.org.apache.poi.hssf.record.NoteRecord;
import com.fr.third.org.apache.poi.hssf.record.NumberRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjectLinkRecord;
import com.fr.third.org.apache.poi.hssf.record.PaletteRecord;
import com.fr.third.org.apache.poi.hssf.record.PaneRecord;
import com.fr.third.org.apache.poi.hssf.record.PasswordRecord;
import com.fr.third.org.apache.poi.hssf.record.PasswordRev4Record;
import com.fr.third.org.apache.poi.hssf.record.PlotAreaRecord;
import com.fr.third.org.apache.poi.hssf.record.PlotGrowthRecord;
import com.fr.third.org.apache.poi.hssf.record.PrecisionRecord;
import com.fr.third.org.apache.poi.hssf.record.PrintGridlinesRecord;
import com.fr.third.org.apache.poi.hssf.record.PrintHeadersRecord;
import com.fr.third.org.apache.poi.hssf.record.PrintSetupRecord;
import com.fr.third.org.apache.poi.hssf.record.ProtectRecord;
import com.fr.third.org.apache.poi.hssf.record.ProtectionRev4Record;
import com.fr.third.org.apache.poi.hssf.record.RKRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.RefModeRecord;
import com.fr.third.org.apache.poi.hssf.record.RefreshAllRecord;
import com.fr.third.org.apache.poi.hssf.record.RightMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.RowRecord;
import com.fr.third.org.apache.poi.hssf.record.SCLRecord;
import com.fr.third.org.apache.poi.hssf.record.SSTRecord;
import com.fr.third.org.apache.poi.hssf.record.SaveRecalcRecord;
import com.fr.third.org.apache.poi.hssf.record.SelectionRecord;
import com.fr.third.org.apache.poi.hssf.record.SeriesIndexRecord;
import com.fr.third.org.apache.poi.hssf.record.SeriesListRecord;
import com.fr.third.org.apache.poi.hssf.record.SeriesRecord;
import com.fr.third.org.apache.poi.hssf.record.SeriesTextRecord;
import com.fr.third.org.apache.poi.hssf.record.SeriesToChartGroupRecord;
import com.fr.third.org.apache.poi.hssf.record.SharedFormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.SheetPropertiesRecord;
import com.fr.third.org.apache.poi.hssf.record.StringRecord;
import com.fr.third.org.apache.poi.hssf.record.StyleRecord;
import com.fr.third.org.apache.poi.hssf.record.SupBookRecord;
import com.fr.third.org.apache.poi.hssf.record.TabIdRecord;
import com.fr.third.org.apache.poi.hssf.record.TextObjectRecord;
import com.fr.third.org.apache.poi.hssf.record.TextRecord;
import com.fr.third.org.apache.poi.hssf.record.TickRecord;
import com.fr.third.org.apache.poi.hssf.record.TopMarginRecord;
import com.fr.third.org.apache.poi.hssf.record.UnitsRecord;
import com.fr.third.org.apache.poi.hssf.record.UnknownRecord;
import com.fr.third.org.apache.poi.hssf.record.UseSelFSRecord;
import com.fr.third.org.apache.poi.hssf.record.VCenterRecord;
import com.fr.third.org.apache.poi.hssf.record.ValueRangeRecord;
import com.fr.third.org.apache.poi.hssf.record.VerticalPageBreakRecord;
import com.fr.third.org.apache.poi.hssf.record.WSBoolRecord;
import com.fr.third.org.apache.poi.hssf.record.WindowOneRecord;
import com.fr.third.org.apache.poi.hssf.record.WindowProtectRecord;
import com.fr.third.org.apache.poi.hssf.record.WindowTwoRecord;
import com.fr.third.org.apache.poi.hssf.record.WriteAccessRecord;
import com.fr.third.org.apache.poi.hssf.record.WriteProtectRecord;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentInputStream;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.third.org.apache.poi.util.HexDump;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public final class BiffViewer {
    private final File _inputFile;
    private boolean dump;
    private final PrintStream _ps;

    public BiffViewer(File file, PrintStream printStream) {
        this._inputFile = file;
        this._ps = printStream;
    }

    public void run() {
        try {
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(new FileInputStream(this._inputFile));
            DocumentInputStream documentInputStream = pOIFSFileSystem.createDocumentInputStream("Workbook");
            BiffViewer.createRecords(documentInputStream, this.dump, this._ps);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Record[] createRecords(InputStream inputStream, boolean bl, PrintStream printStream) throws RecordFormatException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        RecordDetails recordDetails = null;
        BiffviewRecordInputStream biffviewRecordInputStream = new BiffviewRecordInputStream(inputStream);
        while (biffviewRecordInputStream.hasNextRecord()) {
            biffviewRecordInputStream.nextRecord();
            if (biffviewRecordInputStream.getSid() == 0) continue;
            object = BiffViewer.createRecord(biffviewRecordInputStream);
            if (((Record)object).getSid() != 60) {
                arrayList.add(object);
                if (recordDetails != null) {
                    recordDetails.dump(printStream);
                }
                int n = (int)(biffviewRecordInputStream.getPos() - (long)biffviewRecordInputStream.getLength() - 4L);
                recordDetails = new RecordDetails(biffviewRecordInputStream.getSid(), biffviewRecordInputStream.getLength(), n, (Record)object);
            }
            if (!bl) continue;
            biffviewRecordInputStream.dumpBytes(printStream);
        }
        if (recordDetails != null) {
            recordDetails.dump(printStream);
        }
        object = new Record[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    private static Record createRecord(RecordInputStream recordInputStream) {
        switch (recordInputStream.getSid()) {
            case 4098: {
                return new ChartRecord(recordInputStream);
            }
            case 4116: {
                return new ChartFormatRecord(recordInputStream);
            }
            case 4099: {
                return new SeriesRecord(recordInputStream);
            }
            case 4147: {
                return new BeginRecord(recordInputStream);
            }
            case 4148: {
                return new EndRecord(recordInputStream);
            }
            case 2057: {
                return new BOFRecord(recordInputStream);
            }
            case 225: {
                return new InterfaceHdrRecord(recordInputStream);
            }
            case 193: {
                return new MMSRecord(recordInputStream);
            }
            case 226: {
                return new InterfaceEndRecord(recordInputStream);
            }
            case 92: {
                return new WriteAccessRecord(recordInputStream);
            }
            case 66: {
                return new CodepageRecord(recordInputStream);
            }
            case 353: {
                return new DSFRecord(recordInputStream);
            }
            case 317: {
                return new TabIdRecord(recordInputStream);
            }
            case 156: {
                return new FnGroupCountRecord(recordInputStream);
            }
            case 25: {
                return new WindowProtectRecord(recordInputStream);
            }
            case 18: {
                return new ProtectRecord(recordInputStream);
            }
            case 19: {
                return new PasswordRecord(recordInputStream);
            }
            case 431: {
                return new ProtectionRev4Record(recordInputStream);
            }
            case 444: {
                return new PasswordRev4Record(recordInputStream);
            }
            case 61: {
                return new WindowOneRecord(recordInputStream);
            }
            case 64: {
                return new BackupRecord(recordInputStream);
            }
            case 141: {
                return new HideObjRecord(recordInputStream);
            }
            case 34: {
                return new DateWindow1904Record(recordInputStream);
            }
            case 14: {
                return new PrecisionRecord(recordInputStream);
            }
            case 439: {
                return new RefreshAllRecord(recordInputStream);
            }
            case 218: {
                return new BookBoolRecord(recordInputStream);
            }
            case 49: {
                return new FontRecord(recordInputStream);
            }
            case 1054: {
                return new FormatRecord(recordInputStream);
            }
            case 224: {
                return new ExtendedFormatRecord(recordInputStream);
            }
            case 659: {
                return new StyleRecord(recordInputStream);
            }
            case 352: {
                return new UseSelFSRecord(recordInputStream);
            }
            case 133: {
                return new BoundSheetRecord(recordInputStream);
            }
            case 140: {
                return new CountryRecord(recordInputStream);
            }
            case 252: {
                return new SSTRecord(recordInputStream);
            }
            case 255: {
                return new ExtSSTRecord(recordInputStream);
            }
            case 10: {
                return new EOFRecord(recordInputStream);
            }
            case 523: {
                return new IndexRecord(recordInputStream);
            }
            case 13: {
                return new CalcModeRecord(recordInputStream);
            }
            case 12: {
                return new CalcCountRecord(recordInputStream);
            }
            case 15: {
                return new RefModeRecord(recordInputStream);
            }
            case 17: {
                return new IterationRecord(recordInputStream);
            }
            case 16: {
                return new DeltaRecord(recordInputStream);
            }
            case 95: {
                return new SaveRecalcRecord(recordInputStream);
            }
            case 42: {
                return new PrintHeadersRecord(recordInputStream);
            }
            case 43: {
                return new PrintGridlinesRecord(recordInputStream);
            }
            case 130: {
                return new GridsetRecord(recordInputStream);
            }
            case 235: {
                return new DrawingGroupRecord(recordInputStream);
            }
            case 236: {
                return new DrawingRecordForBiffViewer(recordInputStream);
            }
            case 237: {
                return new DrawingSelectionRecord(recordInputStream);
            }
            case 128: {
                return new GutsRecord(recordInputStream);
            }
            case 549: {
                return new DefaultRowHeightRecord(recordInputStream);
            }
            case 129: {
                return new WSBoolRecord(recordInputStream);
            }
            case 20: {
                return new HeaderRecord(recordInputStream);
            }
            case 21: {
                return new FooterRecord(recordInputStream);
            }
            case 131: {
                return new HCenterRecord(recordInputStream);
            }
            case 132: {
                return new VCenterRecord(recordInputStream);
            }
            case 161: {
                return new PrintSetupRecord(recordInputStream);
            }
            case 85: {
                return new DefaultColWidthRecord(recordInputStream);
            }
            case 512: {
                return new DimensionsRecord(recordInputStream);
            }
            case 520: {
                return new RowRecord(recordInputStream);
            }
            case 253: {
                return new LabelSSTRecord(recordInputStream);
            }
            case 638: {
                return new RKRecord(recordInputStream);
            }
            case 515: {
                return new NumberRecord(recordInputStream);
            }
            case 215: {
                return new DBCellRecord(recordInputStream);
            }
            case 574: {
                return new WindowTwoRecord(recordInputStream);
            }
            case 29: {
                return new SelectionRecord(recordInputStream);
            }
            case 60: {
                return new ContinueRecord(recordInputStream);
            }
            case 516: {
                return new LabelRecord(recordInputStream);
            }
            case 189: {
                return new MulRKRecord(recordInputStream);
            }
            case 190: {
                return new MulBlankRecord(recordInputStream);
            }
            case 513: {
                return new BlankRecord(recordInputStream);
            }
            case 517: {
                return new BoolErrRecord(recordInputStream);
            }
            case 125: {
                return new ColumnInfoRecord(recordInputStream);
            }
            case 229: {
                return new MergeCellsRecord(recordInputStream);
            }
            case 4122: {
                return new AreaRecord(recordInputStream);
            }
            case 4102: {
                return new DataFormatRecord(recordInputStream);
            }
            case 4119: {
                return new BarRecord(recordInputStream);
            }
            case 4195: {
                return new DatRecord(recordInputStream);
            }
            case 4196: {
                return new PlotGrowthRecord(recordInputStream);
            }
            case 4097: {
                return new UnitsRecord(recordInputStream);
            }
            case 4146: {
                return new FrameRecord(recordInputStream);
            }
            case 4127: {
                return new ValueRangeRecord(recordInputStream);
            }
            case 4118: {
                return new SeriesListRecord(recordInputStream);
            }
            case 4192: {
                return new FontBasisRecord(recordInputStream);
            }
            case 4134: {
                return new FontIndexRecord(recordInputStream);
            }
            case 4103: {
                return new LineFormatRecord(recordInputStream);
            }
            case 4106: {
                return new AreaFormatRecord(recordInputStream);
            }
            case 4177: {
                return new LinkedDataRecord(recordInputStream);
            }
            case 6: {
                return new FormulaRecord(recordInputStream);
            }
            case 4164: {
                return new SheetPropertiesRecord(recordInputStream);
            }
            case 4132: {
                return new DefaultDataLabelTextPropertiesRecord(recordInputStream);
            }
            case 4133: {
                return new TextRecord(recordInputStream);
            }
            case 4161: {
                return new AxisParentRecord(recordInputStream);
            }
            case 4129: {
                return new AxisLineFormatRecord(recordInputStream);
            }
            case 430: {
                return new SupBookRecord(recordInputStream);
            }
            case 23: {
                return new ExternSheetRecord(recordInputStream);
            }
            case 160: {
                return new SCLRecord(recordInputStream);
            }
            case 4165: {
                return new SeriesToChartGroupRecord(recordInputStream);
            }
            case 4166: {
                return new AxisUsedRecord(recordInputStream);
            }
            case 4125: {
                return new AxisRecord(recordInputStream);
            }
            case 4128: {
                return new CategorySeriesAxisRecord(recordInputStream);
            }
            case 4194: {
                return new AxisOptionsRecord(recordInputStream);
            }
            case 4126: {
                return new TickRecord(recordInputStream);
            }
            case 4109: {
                return new SeriesTextRecord(recordInputStream);
            }
            case 4135: {
                return new ObjectLinkRecord(recordInputStream);
            }
            case 4149: {
                return new PlotAreaRecord(recordInputStream);
            }
            case 4197: {
                return new SeriesIndexRecord(recordInputStream);
            }
            case 4117: {
                return new LegendRecord(recordInputStream);
            }
            case 38: {
                return new LeftMarginRecord(recordInputStream);
            }
            case 39: {
                return new RightMarginRecord(recordInputStream);
            }
            case 40: {
                return new TopMarginRecord(recordInputStream);
            }
            case 41: {
                return new BottomMarginRecord(recordInputStream);
            }
            case 146: {
                return new PaletteRecord(recordInputStream);
            }
            case 519: {
                return new StringRecord(recordInputStream);
            }
            case 24: {
                return new NameRecord(recordInputStream);
            }
            case 65: {
                return new PaneRecord(recordInputStream);
            }
            case 1212: {
                return new SharedFormulaRecord(recordInputStream);
            }
            case 93: {
                return new ObjRecord(recordInputStream);
            }
            case 438: {
                return new TextObjectRecord(recordInputStream);
            }
            case 27: {
                return new HorizontalPageBreakRecord(recordInputStream);
            }
            case 26: {
                return new VerticalPageBreakRecord(recordInputStream);
            }
            case 134: {
                return new WriteProtectRecord(recordInputStream);
            }
            case 47: {
                return new FilePassRecord(recordInputStream);
            }
            case 28: {
                return new NoteRecord(recordInputStream);
            }
            case 91: {
                return new FileSharingRecord(recordInputStream);
            }
            case 440: {
                return new HyperlinkRecord(recordInputStream);
            }
        }
        return new UnknownRecord(recordInputStream);
    }

    public void setDump(boolean bl) {
        this.dump = bl;
    }

    public static void main(String[] stringArray) {
        System.setProperty("poi.deserialize.escher", "true");
        if (stringArray.length == 0) {
            System.out.println("Biff viewer needs a filename");
            return;
        }
        try {
            String string = stringArray[0];
            File file = new File(string);
            if (!file.exists()) {
                throw new RuntimeException("specified inputFile '" + string + "' does not exist");
            }
            PrintStream printStream = System.out;
            BiffViewer biffViewer = new BiffViewer(file, printStream);
            if (stringArray.length > 1 && stringArray[1].equals("on")) {
                biffViewer.setDump(true);
            }
            if (stringArray.length > 1 && stringArray[1].equals("bfd")) {
                POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(new FileInputStream(file));
                DocumentInputStream documentInputStream = pOIFSFileSystem.createDocumentInputStream("Workbook");
                int n = ((InputStream)documentInputStream).available();
                byte[] byArray = new byte[n];
                ((InputStream)documentInputStream).read(byArray);
                HexDump.dump(byArray, 0L, System.out, 0);
            } else {
                biffViewer.run();
            }
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static final class BiffviewRecordInputStream
    extends RecordInputStream {
        public BiffviewRecordInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public void dumpBytes(PrintStream printStream) {
            printStream.println(HexDump.dump(this.data, 0L, this.currentLength));
        }
    }

    private static final class RecordDetails {
        short rectype;
        short recsize;
        int startloc;
        Record record;

        public RecordDetails(short s, short s2, int n, Record record) {
            this.rectype = s;
            this.recsize = s2;
            this.startloc = n;
            this.record = record;
        }

        public short getRectype() {
            return this.rectype;
        }

        public short getRecsize() {
            return this.recsize;
        }

        public Record getRecord() {
            return this.record;
        }

        public void dump(PrintStream printStream) {
            printStream.println("Offset 0x" + Integer.toHexString(this.startloc) + " (" + this.startloc + ")");
            printStream.println("recordid = 0x" + Integer.toHexString(this.rectype) + ", size = " + this.recsize);
            printStream.println(this.record.toString());
        }
    }
}

