/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hpsf;

import com.fr.third.org.apache.poi.hpsf.ReadingNotSupportedException;
import com.fr.third.org.apache.poi.hpsf.TypeWriter;
import com.fr.third.org.apache.poi.hpsf.UnsupportedVariantTypeException;
import com.fr.third.org.apache.poi.hpsf.Util;
import com.fr.third.org.apache.poi.hpsf.Variant;
import com.fr.third.org.apache.poi.hpsf.WritingNotSupportedException;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class VariantSupport
extends Variant {
    private static boolean logUnsupportedTypes = false;
    protected static List unsupportedMessage;
    public static final int[] SUPPORTED_TYPES;
    static /* synthetic */ Class class$java$lang$Integer;

    public static void setLogUnsupportedTypes(boolean bl) {
        logUnsupportedTypes = bl;
    }

    public static boolean isLogUnsupportedTypes() {
        return logUnsupportedTypes;
    }

    protected static void writeUnsupportedTypeMessage(UnsupportedVariantTypeException unsupportedVariantTypeException) {
        if (VariantSupport.isLogUnsupportedTypes()) {
            Long l;
            if (unsupportedMessage == null) {
                unsupportedMessage = new LinkedList();
            }
            if (!unsupportedMessage.contains(l = new Long(unsupportedVariantTypeException.getVariantType()))) {
                System.err.println(unsupportedVariantTypeException.getMessage());
                unsupportedMessage.add(l);
            }
        }
    }

    public boolean isSupportedType(int n) {
        for (int i = 0; i < SUPPORTED_TYPES.length; ++i) {
            if (n != SUPPORTED_TYPES[i]) continue;
            return true;
        }
        return false;
    }

    public static Object read(byte[] byArray, int n, int n2, long l, int n3) throws ReadingNotSupportedException, UnsupportedEncodingException {
        Object object;
        int n4 = n;
        int n5 = n2 - 4;
        long l2 = l;
        if (n3 == 1200 && l == 30L) {
            l2 = 31L;
        }
        switch ((int)l2) {
            case 0: {
                object = null;
                break;
            }
            case 2: {
                object = new Integer(LittleEndian.getShort(byArray, n4));
                break;
            }
            case 3: {
                object = new Integer(LittleEndian.getInt(byArray, n4));
                break;
            }
            case 20: {
                object = new Long(LittleEndian.getLong(byArray, n4));
                break;
            }
            case 5: {
                object = new Double(LittleEndian.getDouble(byArray, n4));
                break;
            }
            case 64: {
                long l3 = LittleEndian.getUInt(byArray, n4);
                long l4 = LittleEndian.getUInt(byArray, n4 += 4);
                object = Util.filetimeToDate((int)l4, (int)l3);
                break;
            }
            case 30: {
                int n6 = n4 + 4;
                long l5 = (long)n6 + LittleEndian.getUInt(byArray, n4) - 1L;
                n4 += 4;
                while (byArray[(int)l5] == 0 && (long)n6 <= l5) {
                    --l5;
                }
                int n7 = (int)(l5 - (long)n6 + 1L);
                object = n3 != -1 ? new String(byArray, n6, n7, VariantSupport.codepageToEncoding(n3)) : new String(byArray, n6, n7);
                break;
            }
            case 31: {
                int n8 = n4 + 4;
                long l6 = (long)n8 + LittleEndian.getUInt(byArray, n4) - 1L;
                long l7 = l6 - (long)n8;
                n4 += 4;
                StringBuffer stringBuffer = new StringBuffer((int)(l6 - (long)n8));
                int n9 = 0;
                while ((long)n9 <= l7) {
                    int n10 = n4 + n9 * 2;
                    int n11 = n10 + 1;
                    int n12 = byArray[n11] << 8;
                    int n13 = byArray[n10] & 0xFF;
                    char c = (char)(n12 | n13);
                    stringBuffer.append(c);
                    ++n9;
                }
                while (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '\u0000') {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                object = stringBuffer.toString();
                break;
            }
            case 71: {
                byte[] byArray2 = new byte[n5];
                for (int i = 0; i < n5; ++i) {
                    byArray2[i] = byArray[n4 + i];
                }
                object = byArray2;
                break;
            }
            case 11: {
                long l8 = LittleEndian.getUInt(byArray, n4);
                if (l8 != 0L) {
                    object = Boolean.TRUE;
                    break;
                }
                object = Boolean.FALSE;
                break;
            }
            default: {
                byte[] byArray3 = new byte[n5];
                for (int i = 0; i < n5; ++i) {
                    byArray3[i] = byArray[n4 + i];
                }
                throw new ReadingNotSupportedException(l, byArray3);
            }
        }
        return object;
    }

    public static String codepageToEncoding(int n) throws UnsupportedEncodingException {
        if (n <= 0) {
            throw new UnsupportedEncodingException("Codepage number may not be " + n);
        }
        switch (n) {
            case 1200: {
                return "UTF-16";
            }
            case 1201: {
                return "UTF-16BE";
            }
            case 65001: {
                return "UTF-8";
            }
            case 37: {
                return "cp037";
            }
            case 936: {
                return "GBK";
            }
            case 949: {
                return "ms949";
            }
            case 1250: {
                return "windows-1250";
            }
            case 1251: {
                return "windows-1251";
            }
            case 1252: {
                return "windows-1252";
            }
            case 1253: {
                return "windows-1253";
            }
            case 1254: {
                return "windows-1254";
            }
            case 1255: {
                return "windows-1255";
            }
            case 1256: {
                return "windows-1256";
            }
            case 1257: {
                return "windows-1257";
            }
            case 1258: {
                return "windows-1258";
            }
            case 1361: {
                return "johab";
            }
            case 10000: {
                return "MacRoman";
            }
            case 10001: {
                return "SJIS";
            }
            case 10002: {
                return "Big5";
            }
            case 10003: {
                return "EUC-KR";
            }
            case 10004: {
                return "MacArabic";
            }
            case 10005: {
                return "MacHebrew";
            }
            case 10006: {
                return "MacGreek";
            }
            case 10007: {
                return "MacCyrillic";
            }
            case 10008: {
                return "EUC_CN";
            }
            case 10010: {
                return "MacRomania";
            }
            case 10017: {
                return "MacUkraine";
            }
            case 10021: {
                return "MacThai";
            }
            case 10029: {
                return "MacCentralEurope";
            }
            case 10079: {
                return "MacIceland";
            }
            case 10081: {
                return "MacTurkish";
            }
            case 10082: {
                return "MacCroatian";
            }
            case 20127: 
            case 65000: {
                return "US-ASCII";
            }
            case 20866: {
                return "KOI8-R";
            }
            case 28591: {
                return "ISO-8859-1";
            }
            case 28592: {
                return "ISO-8859-2";
            }
            case 28593: {
                return "ISO-8859-3";
            }
            case 28594: {
                return "ISO-8859-4";
            }
            case 28595: {
                return "ISO-8859-5";
            }
            case 28596: {
                return "ISO-8859-6";
            }
            case 28597: {
                return "ISO-8859-7";
            }
            case 28598: {
                return "ISO-8859-8";
            }
            case 28599: {
                return "ISO-8859-9";
            }
            case 50220: 
            case 50221: 
            case 50222: {
                return "ISO-2022-JP";
            }
            case 50225: {
                return "ISO-2022-KR";
            }
            case 51932: {
                return "EUC-JP";
            }
            case 51949: {
                return "EUC-KR";
            }
            case 52936: {
                return "GB2312";
            }
            case 54936: {
                return "GB18030";
            }
            case 932: {
                return "SJIS";
            }
        }
        return "cp" + n;
    }

    public static int write(OutputStream outputStream, long l, Object object, int n) throws IOException, WritingNotSupportedException {
        int n2 = 0;
        switch ((int)l) {
            case 11: {
                int n3 = (Boolean)object != false ? 1 : 0;
                n2 = TypeWriter.writeUIntToStream(outputStream, n3);
                break;
            }
            case 30: {
                byte[] byArray = n == -1 ? ((String)object).getBytes() : ((String)object).getBytes(VariantSupport.codepageToEncoding(n));
                n2 = TypeWriter.writeUIntToStream(outputStream, byArray.length + 1);
                byte[] byArray2 = new byte[byArray.length + 1];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray2[byArray2.length - 1] = 0;
                outputStream.write(byArray2);
                n2 += byArray2.length;
                break;
            }
            case 31: {
                int n4 = ((String)object).length() + 1;
                n2 += TypeWriter.writeUIntToStream(outputStream, n4);
                char[] cArray = Util.pad4((String)object);
                for (int i = 0; i < cArray.length; ++i) {
                    int n5 = (cArray[i] & 0xFF00) >> 8;
                    int n6 = cArray[i] & 0xFF;
                    byte by = (byte)n5;
                    byte by2 = (byte)n6;
                    outputStream.write(by2);
                    outputStream.write(by);
                    n2 += 2;
                }
                outputStream.write(0);
                outputStream.write(0);
                n2 += 2;
                break;
            }
            case 71: {
                byte[] byArray = (byte[])object;
                outputStream.write(byArray);
                n2 = byArray.length;
                break;
            }
            case 0: {
                TypeWriter.writeUIntToStream(outputStream, 0L);
                n2 = 4;
                break;
            }
            case 2: {
                TypeWriter.writeToStream(outputStream, ((Integer)object).shortValue());
                n2 = 2;
                break;
            }
            case 3: {
                if (!(object instanceof Integer)) {
                    throw new ClassCastException("Could not cast an object to " + (class$java$lang$Integer == null ? (class$java$lang$Integer = VariantSupport.class$("java.lang.Integer")) : class$java$lang$Integer).toString() + ": " + object.getClass().toString() + ", " + object.toString());
                }
                n2 += TypeWriter.writeToStream(outputStream, (Integer)object);
                break;
            }
            case 20: {
                TypeWriter.writeToStream(outputStream, (Long)object);
                n2 = 8;
                break;
            }
            case 5: {
                n2 += TypeWriter.writeToStream(outputStream, (Double)object);
                break;
            }
            case 64: {
                long l2 = Util.dateToFileTime((Date)object);
                int n7 = (int)(l2 >> 32 & 0xFFFFFFFFL);
                int n8 = (int)(l2 & 0xFFFFFFFFL);
                n2 += TypeWriter.writeUIntToStream(outputStream, 0xFFFFFFFFL & (long)n8);
                n2 += TypeWriter.writeUIntToStream(outputStream, 0xFFFFFFFFL & (long)n7);
                break;
            }
            default: {
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    outputStream.write(byArray);
                    n2 = byArray.length;
                    VariantSupport.writeUnsupportedTypeMessage(new WritingNotSupportedException(l, object));
                    break;
                }
                throw new WritingNotSupportedException(l, object);
            }
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SUPPORTED_TYPES = new int[]{0, 2, 3, 20, 5, 64, 30, 31, 71, 11};
    }
}

