/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hpsf;

import com.fr.third.org.apache.poi.hpsf.ClassID;
import com.fr.third.org.apache.poi.hpsf.IllegalPropertySetDataException;
import com.fr.third.org.apache.poi.hpsf.Property;
import com.fr.third.org.apache.poi.hpsf.UnsupportedVariantTypeException;
import com.fr.third.org.apache.poi.hpsf.VariantSupport;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public class TypeWriter {
    public static int writeToStream(OutputStream outputStream, short s) throws IOException {
        byte[] byArray = new byte[2];
        LittleEndian.putShort(byArray, 0, s);
        outputStream.write(byArray, 0, 2);
        return 2;
    }

    public static int writeToStream(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[4];
        LittleEndian.putInt(byArray, 0, n);
        outputStream.write(byArray, 0, 4);
        return 4;
    }

    public static int writeToStream(OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[8];
        LittleEndian.putLong(byArray, 0, l);
        outputStream.write(byArray, 0, 8);
        return 8;
    }

    public static void writeUShortToStream(OutputStream outputStream, int n) throws IOException {
        int n2 = n & 0xFFFF0000;
        if (n2 != 0) {
            throw new IllegalPropertySetDataException("Value " + n + " cannot be represented by 2 bytes.");
        }
        TypeWriter.writeToStream(outputStream, (short)n);
    }

    public static int writeUIntToStream(OutputStream outputStream, long l) throws IOException {
        long l2 = l & 0xFFFFFFFF00000000L;
        if (l2 != 0L && l2 != -4294967296L) {
            throw new IllegalPropertySetDataException("Value " + l + " cannot be represented by 4 bytes.");
        }
        return TypeWriter.writeToStream(outputStream, (int)l);
    }

    public static int writeToStream(OutputStream outputStream, ClassID classID) throws IOException {
        byte[] byArray = new byte[16];
        classID.write(byArray, 0);
        outputStream.write(byArray, 0, byArray.length);
        return byArray.length;
    }

    public static void writeToStream(OutputStream outputStream, Property[] propertyArray, int n) throws IOException, UnsupportedVariantTypeException {
        Property property;
        int n2;
        if (propertyArray == null) {
            return;
        }
        for (n2 = 0; n2 < propertyArray.length; ++n2) {
            property = propertyArray[n2];
            TypeWriter.writeUIntToStream(outputStream, property.getID());
            TypeWriter.writeUIntToStream(outputStream, property.getSize());
        }
        for (n2 = 0; n2 < propertyArray.length; ++n2) {
            property = propertyArray[n2];
            long l = property.getType();
            TypeWriter.writeUIntToStream(outputStream, l);
            VariantSupport.write(outputStream, (int)l, property.getValue(), n);
        }
    }

    public static int writeToStream(OutputStream outputStream, double d) throws IOException {
        byte[] byArray = new byte[8];
        LittleEndian.putDouble(byArray, 0, d);
        outputStream.write(byArray, 0, 8);
        return 8;
    }
}

