/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hpsf;

import com.fr.third.org.apache.poi.hpsf.DocumentSummaryInformation;
import com.fr.third.org.apache.poi.hpsf.HPSFRuntimeException;
import com.fr.third.org.apache.poi.hpsf.MarkUnsupportedException;
import com.fr.third.org.apache.poi.hpsf.MutablePropertySet;
import com.fr.third.org.apache.poi.hpsf.MutableSection;
import com.fr.third.org.apache.poi.hpsf.NoPropertySetStreamException;
import com.fr.third.org.apache.poi.hpsf.PropertySet;
import com.fr.third.org.apache.poi.hpsf.SummaryInformation;
import com.fr.third.org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import com.fr.third.org.apache.poi.hpsf.wellknown.SectionIDMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.UnexpectedException;

public class PropertySetFactory {
    public static PropertySet create(InputStream inputStream) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        PropertySet propertySet = new PropertySet(inputStream);
        try {
            if (propertySet.isSummaryInformation()) {
                return new SummaryInformation(propertySet);
            }
            if (propertySet.isDocumentSummaryInformation()) {
                return new DocumentSummaryInformation(propertySet);
            }
            return propertySet;
        }
        catch (UnexpectedPropertySetTypeException unexpectedPropertySetTypeException) {
            throw new UnexpectedException(unexpectedPropertySetTypeException.toString());
        }
    }

    public static SummaryInformation newSummaryInformation() {
        MutablePropertySet mutablePropertySet = new MutablePropertySet();
        MutableSection mutableSection = (MutableSection)mutablePropertySet.getFirstSection();
        mutableSection.setFormatID(SectionIDMap.SUMMARY_INFORMATION_ID);
        try {
            return new SummaryInformation((PropertySet)mutablePropertySet);
        }
        catch (UnexpectedPropertySetTypeException unexpectedPropertySetTypeException) {
            throw new HPSFRuntimeException(unexpectedPropertySetTypeException);
        }
    }

    public static DocumentSummaryInformation newDocumentSummaryInformation() {
        MutablePropertySet mutablePropertySet = new MutablePropertySet();
        MutableSection mutableSection = (MutableSection)mutablePropertySet.getFirstSection();
        mutableSection.setFormatID(SectionIDMap.DOCUMENT_SUMMARY_INFORMATION_ID[0]);
        try {
            return new DocumentSummaryInformation((PropertySet)mutablePropertySet);
        }
        catch (UnexpectedPropertySetTypeException unexpectedPropertySetTypeException) {
            throw new HPSFRuntimeException(unexpectedPropertySetTypeException);
        }
    }
}

