/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hpsf;

import com.fr.third.org.apache.poi.hpsf.ClassID;
import com.fr.third.org.apache.poi.hpsf.HPSFRuntimeException;
import com.fr.third.org.apache.poi.hpsf.IllegalPropertySetDataException;
import com.fr.third.org.apache.poi.hpsf.MutableProperty;
import com.fr.third.org.apache.poi.hpsf.Property;
import com.fr.third.org.apache.poi.hpsf.Section;
import com.fr.third.org.apache.poi.hpsf.TypeWriter;
import com.fr.third.org.apache.poi.hpsf.Util;
import com.fr.third.org.apache.poi.hpsf.VariantSupport;
import com.fr.third.org.apache.poi.hpsf.WritingNotSupportedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MutableSection
extends Section {
    private boolean dirty = true;
    private List preprops;
    private byte[] sectionBytes;

    public MutableSection() {
        this.dirty = true;
        this.formatID = null;
        this.offset = -1L;
        this.preprops = new LinkedList();
    }

    public MutableSection(Section section) {
        this.setFormatID(section.getFormatID());
        Property[] propertyArray = section.getProperties();
        Property[] propertyArray2 = new MutableProperty[propertyArray.length];
        for (int i = 0; i < propertyArray.length; ++i) {
            propertyArray2[i] = new MutableProperty(propertyArray[i]);
        }
        this.setProperties(propertyArray2);
        this.setDictionary(section.getDictionary());
    }

    public void setFormatID(ClassID classID) {
        this.formatID = classID;
    }

    public void setFormatID(byte[] byArray) {
        ClassID classID = this.getFormatID();
        if (classID == null) {
            classID = new ClassID();
            this.setFormatID(classID);
        }
        classID.setBytes(byArray);
    }

    public void setProperties(Property[] propertyArray) {
        this.properties = propertyArray;
        this.preprops = new LinkedList();
        for (int i = 0; i < propertyArray.length; ++i) {
            this.preprops.add(propertyArray[i]);
        }
        this.dirty = true;
    }

    public void setProperty(int n, String string) {
        this.setProperty(n, 31L, string);
        this.dirty = true;
    }

    public void setProperty(int n, int n2) {
        this.setProperty(n, 3L, new Integer(n2));
        this.dirty = true;
    }

    public void setProperty(int n, long l) {
        this.setProperty(n, 20L, new Long(l));
        this.dirty = true;
    }

    public void setProperty(int n, boolean bl) {
        this.setProperty(n, 11L, new Boolean(bl));
        this.dirty = true;
    }

    public void setProperty(int n, long l, Object object) {
        MutableProperty mutableProperty = new MutableProperty();
        mutableProperty.setID(n);
        mutableProperty.setType(l);
        mutableProperty.setValue(object);
        this.setProperty(mutableProperty);
        this.dirty = true;
    }

    public void setProperty(Property property) {
        long l = property.getID();
        this.removeProperty(l);
        this.preprops.add(property);
        this.dirty = true;
    }

    public void removeProperty(long l) {
        Iterator iterator = this.preprops.iterator();
        while (iterator.hasNext()) {
            if (((Property)iterator.next()).getID() != l) continue;
            iterator.remove();
            break;
        }
        this.dirty = true;
    }

    protected void setPropertyBooleanValue(int n, boolean bl) {
        this.setProperty(n, 11L, new Boolean(bl));
    }

    public int getSize() {
        if (this.dirty) {
            try {
                this.size = this.calcSize();
                this.dirty = false;
            }
            catch (HPSFRuntimeException hPSFRuntimeException) {
                throw hPSFRuntimeException;
            }
            catch (Exception exception) {
                throw new HPSFRuntimeException(exception);
            }
        }
        return this.size;
    }

    private int calcSize() throws WritingNotSupportedException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        byteArrayOutputStream.close();
        this.sectionBytes = Util.pad4(byteArrayOutputStream.toByteArray());
        return this.sectionBytes.length;
    }

    public int write(OutputStream outputStream) throws WritingNotSupportedException, IOException {
        Object object;
        ListIterator listIterator;
        if (!this.dirty && this.sectionBytes != null) {
            outputStream.write(this.sectionBytes);
            return this.sectionBytes.length;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        int n = 0;
        n += 8 + this.getPropertyCount() * 2 * 4;
        int n2 = -1;
        if (this.getProperty(0L) != null) {
            listIterator = this.getProperty(1L);
            if (listIterator != null) {
                if (!(listIterator instanceof Integer)) {
                    throw new IllegalPropertySetDataException("The codepage property (ID = 1) must be an Integer object.");
                }
            } else {
                this.setProperty(1, 2L, new Integer(1200));
            }
            n2 = this.getCodepage();
        }
        Collections.sort(this.preprops, new Comparator(){

            public int compare(Object object, Object object2) {
                Property property = (Property)object;
                Property property2 = (Property)object2;
                if (property.getID() < property2.getID()) {
                    return -1;
                }
                if (property.getID() == property2.getID()) {
                    return 0;
                }
                return 1;
            }
        });
        listIterator = this.preprops.listIterator();
        while (listIterator.hasNext()) {
            object = (MutableProperty)listIterator.next();
            long l = ((Property)object).getID();
            TypeWriter.writeUIntToStream(byteArrayOutputStream2, ((Property)object).getID());
            TypeWriter.writeUIntToStream(byteArrayOutputStream2, n);
            if (l != 0L) {
                n += ((MutableProperty)object).write(byteArrayOutputStream, this.getCodepage());
                continue;
            }
            if (n2 == -1) {
                throw new IllegalPropertySetDataException("Codepage (property 1) is undefined.");
            }
            n += MutableSection.writeDictionary(byteArrayOutputStream, this.dictionary, n2);
        }
        byteArrayOutputStream.close();
        byteArrayOutputStream2.close();
        listIterator = (ListIterator)byteArrayOutputStream2.toByteArray();
        object = byteArrayOutputStream.toByteArray();
        TypeWriter.writeToStream(outputStream, 8 + ((Object)listIterator).length + ((Object)object).length);
        TypeWriter.writeToStream(outputStream, this.getPropertyCount());
        outputStream.write((byte[])listIterator);
        outputStream.write((byte[])object);
        int n3 = 8 + ((Object)listIterator).length + ((Object)object).length;
        return n3;
    }

    private static int writeDictionary(OutputStream outputStream, Map map, int n) throws IOException {
        int n2 = TypeWriter.writeUIntToStream(outputStream, map.size());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            String string = (String)map.get(l);
            if (n == 1200) {
                int n3 = string.length() + 1;
                if (n3 % 2 == 1) {
                    ++n3;
                }
                n2 += TypeWriter.writeUIntToStream(outputStream, l);
                n2 += TypeWriter.writeUIntToStream(outputStream, n3);
                byte[] byArray = string.getBytes(VariantSupport.codepageToEncoding(n));
                for (int i = 2; i < byArray.length; i += 2) {
                    outputStream.write(byArray[i + 1]);
                    outputStream.write(byArray[i]);
                    n2 += 2;
                }
                n3 -= string.length();
                while (n3 > 0) {
                    outputStream.write(0);
                    outputStream.write(0);
                    n2 += 2;
                    --n3;
                }
                continue;
            }
            n2 += TypeWriter.writeUIntToStream(outputStream, l);
            n2 += TypeWriter.writeUIntToStream(outputStream, string.length() + 1);
            byte[] byArray = string.getBytes(VariantSupport.codepageToEncoding(n));
            for (int i = 0; i < byArray.length; ++i) {
                outputStream.write(byArray[i]);
                ++n2;
            }
            outputStream.write(0);
            ++n2;
        }
        return n2;
    }

    public int getPropertyCount() {
        return this.preprops.size();
    }

    public Property[] getProperties() {
        this.properties = this.preprops.toArray(new Property[0]);
        return this.properties;
    }

    public Object getProperty(long l) {
        this.getProperties();
        return super.getProperty(l);
    }

    public void setDictionary(Map map) throws IllegalPropertySetDataException {
        if (map != null) {
            Object object = map.keySet().iterator();
            while (object.hasNext()) {
                if (object.next() instanceof Long) continue;
                throw new IllegalPropertySetDataException("Dictionary keys must be of type Long.");
            }
            object = map.values().iterator();
            while (object.hasNext()) {
                if (object.next() instanceof String) continue;
                throw new IllegalPropertySetDataException("Dictionary values must be of type String.");
            }
            this.dictionary = map;
            this.setProperty(0, -1L, map);
            object = (Integer)this.getProperty(1L);
            if (object == null) {
                this.setProperty(1, 2L, new Integer(1200));
            }
        } else {
            this.removeProperty(0L);
        }
    }

    public void setProperty(int n, Object object) {
        if (object instanceof String) {
            this.setProperty(n, (String)object);
        } else if (object instanceof Long) {
            this.setProperty(n, (Long)object);
        } else if (object instanceof Integer) {
            this.setProperty(n, (Integer)object);
        } else if (object instanceof Short) {
            this.setProperty(n, ((Short)object).intValue());
        } else if (object instanceof Boolean) {
            this.setProperty(n, (Boolean)object);
        } else if (object instanceof Date) {
            this.setProperty(n, 64L, object);
        } else {
            throw new HPSFRuntimeException("HPSF does not support properties of type " + object.getClass().getName() + ".");
        }
    }

    public void clear() {
        Property[] propertyArray = this.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            Property property = propertyArray[i];
            this.removeProperty(property.getID());
        }
    }

    public void setCodepage(int n) {
        this.setProperty(1, 2L, new Integer(n));
    }
}

