/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hpsf;

import com.fr.third.org.apache.poi.util.HexDump;

public class ClassID {
    protected byte[] bytes;
    public static final int LENGTH = 16;

    public ClassID(byte[] byArray, int n) {
        this.read(byArray, n);
    }

    public ClassID() {
        this.bytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            this.bytes[i] = 0;
        }
    }

    public int length() {
        return 16;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] byArray) {
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = byArray[i];
        }
    }

    public byte[] read(byte[] byArray, int n) {
        this.bytes = new byte[16];
        this.bytes[0] = byArray[3 + n];
        this.bytes[1] = byArray[2 + n];
        this.bytes[2] = byArray[1 + n];
        this.bytes[3] = byArray[0 + n];
        this.bytes[4] = byArray[5 + n];
        this.bytes[5] = byArray[4 + n];
        this.bytes[6] = byArray[7 + n];
        this.bytes[7] = byArray[6 + n];
        for (int i = 8; i < 16; ++i) {
            this.bytes[i] = byArray[i + n];
        }
        return this.bytes;
    }

    public void write(byte[] byArray, int n) throws ArrayStoreException {
        if (byArray.length < 16) {
            throw new ArrayStoreException("Destination byte[] must have room for at least 16 bytes, but has a length of only " + byArray.length + ".");
        }
        byArray[0 + n] = this.bytes[3];
        byArray[1 + n] = this.bytes[2];
        byArray[2 + n] = this.bytes[1];
        byArray[3 + n] = this.bytes[0];
        byArray[4 + n] = this.bytes[5];
        byArray[5 + n] = this.bytes[4];
        byArray[6 + n] = this.bytes[7];
        byArray[7 + n] = this.bytes[6];
        for (int i = 8; i < 16; ++i) {
            byArray[i + n] = this.bytes[i];
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ClassID)) {
            return false;
        }
        ClassID classID = (ClassID)object;
        if (this.bytes.length != classID.bytes.length) {
            return false;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == classID.bytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return new String(this.bytes).hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(38);
        stringBuffer.append('{');
        for (int i = 0; i < 16; ++i) {
            stringBuffer.append(HexDump.toHex(this.bytes[i]));
            if (i != 3 && i != 5 && i != 7 && i != 9) continue;
            stringBuffer.append('-');
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

