/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UnknownEscherRecord
extends EscherRecord {
    private static final byte[] NO_BYTES = new byte[0];
    private byte[] thedata = NO_BYTES;
    private List childRecords = new ArrayList();

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        if (this.isContainerRecord()) {
            int n3 = 0;
            this.thedata = new byte[0];
            n += 8;
            n3 += 8;
            while (n2 > 0) {
                EscherRecord escherRecord = escherRecordFactory.createRecord(byArray, n);
                int n4 = escherRecord.fillFields(byArray, n, escherRecordFactory);
                n3 += n4;
                n += n4;
                n2 -= n4;
                this.getChildRecords().add(escherRecord);
            }
            return n3;
        }
        this.thedata = new byte[n2];
        System.arraycopy(byArray, n + 8, this.thedata, 0, n2);
        return n2 + 8;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        Object object;
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        int n2 = this.thedata.length;
        Iterator iterator = this.getChildRecords().iterator();
        while (iterator.hasNext()) {
            object = (EscherRecord)iterator.next();
            n2 += ((EscherRecord)object).getRecordSize();
        }
        LittleEndian.putInt(byArray, n + 4, n2);
        System.arraycopy(this.thedata, 0, byArray, n + 8, this.thedata.length);
        int n3 = n + 8 + this.thedata.length;
        object = this.getChildRecords().iterator();
        while (object.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)object.next();
            n3 += escherRecord.serialize(n3, byArray, escherSerializationListener);
        }
        escherSerializationListener.afterRecordSerialize(n3, this.getRecordId(), n3 - n, this);
        return n3 - n;
    }

    public byte[] getData() {
        return this.thedata;
    }

    public int getRecordSize() {
        return 8 + this.thedata.length;
    }

    public List getChildRecords() {
        return this.childRecords;
    }

    public void setChildRecords(List list) {
        this.childRecords = list;
    }

    public Object clone() {
        return super.clone();
    }

    public String getRecordName() {
        return "Unknown 0x" + HexDump.toHex(this.getRecordId());
    }

    public String toString() {
        Object object;
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getChildRecords().size() > 0) {
            stringBuffer.append("  children: " + string);
            object = this.getChildRecords().iterator();
            while (object.hasNext()) {
                EscherRecord escherRecord = (EscherRecord)object.next();
                stringBuffer.append(escherRecord.toString());
                stringBuffer.append(string);
            }
        }
        object = "";
        try {
            if (this.thedata.length != 0) {
                object = "  Extra Data(" + this.thedata.length + "):" + string;
                object = (String)object + HexDump.dump(this.thedata, 0L, 0);
            }
        }
        catch (Exception exception) {
            object = "Error!!";
        }
        return this.getClass().getName() + ":" + string + "  isContainer: " + this.isContainerRecord() + string + "  options: 0x" + HexDump.toHex(this.getOptions()) + string + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + string + "  numchildren: " + this.getChildRecords().size() + string + (String)object + stringBuffer.toString();
    }

    public void addChildRecord(EscherRecord escherRecord) {
        this.getChildRecords().add(escherRecord);
    }
}

