/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class EscherSplitMenuColorsRecord
extends EscherRecord {
    public static final short RECORD_ID = -3810;
    public static final String RECORD_DESCRIPTION = "MsofbtSplitMenuColors";
    private int field_1_color1;
    private int field_2_color2;
    private int field_3_color3;
    private int field_4_color4;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        this.field_1_color1 = LittleEndian.getInt(byArray, n3 + n4);
        this.field_2_color2 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_3_color3 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_4_color4 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        if ((n2 -= (n4 += 4)) != 0) {
            throw new RecordFormatException("Expecting no remaining data but got " + n2 + " byte(s).");
        }
        return 8 + n4 + n2;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        int n2 = n;
        LittleEndian.putShort(byArray, n2, this.getOptions());
        LittleEndian.putShort(byArray, n2 += 2, this.getRecordId());
        int n3 = this.getRecordSize() - 8;
        LittleEndian.putInt(byArray, n2 += 2, n3);
        LittleEndian.putInt(byArray, n2 += 4, this.field_1_color1);
        LittleEndian.putInt(byArray, n2 += 4, this.field_2_color2);
        LittleEndian.putInt(byArray, n2 += 4, this.field_3_color3);
        LittleEndian.putInt(byArray, n2 += 4, this.field_4_color4);
        escherSerializationListener.afterRecordSerialize(n2 += 4, this.getRecordId(), n2 - n, this);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 24;
    }

    public short getRecordId() {
        return -3810;
    }

    public String getRecordName() {
        return "SplitMenuColors";
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return this.getClass().getName() + ":" + string + "  RecordId: 0x" + HexDump.toHex((short)-3810) + string + "  Options: 0x" + HexDump.toHex(this.getOptions()) + string + "  Color1: 0x" + HexDump.toHex(this.field_1_color1) + string + "  Color2: 0x" + HexDump.toHex(this.field_2_color2) + string + "  Color3: 0x" + HexDump.toHex(this.field_3_color3) + string + "  Color4: 0x" + HexDump.toHex(this.field_4_color4) + string + "";
    }

    public int getColor1() {
        return this.field_1_color1;
    }

    public void setColor1(int n) {
        this.field_1_color1 = n;
    }

    public int getColor2() {
        return this.field_2_color2;
    }

    public void setColor2(int n) {
        this.field_2_color2 = n;
    }

    public int getColor3() {
        return this.field_3_color3;
    }

    public void setColor3(int n) {
        this.field_3_color3 = n;
    }

    public int getColor4() {
        return this.field_4_color4;
    }

    public void setColor4(int n) {
        this.field_4_color4 = n;
    }
}

